/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.coupon.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.AuditStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.EnableStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponItemRange;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponItemRangeQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponTemplateReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponItemRangeRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateResDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateShowRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.coupon.service.ICouponItemService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.coupon.service.ICouponTemplateService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.coupon.service.ICouponUserService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.BeanCopyUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.das.CouponItemMappingDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.das.CouponTemplateDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponItemMappingEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponTemplateEo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class CouponTemplateServiceImpl
implements ICouponTemplateService {
    @Autowired
    private CouponTemplateDas couponTemplateDas;
    @Resource
    private CouponItemMappingDas couponItemMappingDas;
    @Autowired
    private ICouponItemService couponItemService;
    @Autowired
    private ICouponUserService couponUserService;
    @Resource
    private IActivityService activityService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long createCouponTemplate(CouponTemplateEo couponTemplateEo, String itemScopeType, List<Long> objIds, List<Long> userIds) {
        if (StringUtils.isEmpty((Object)couponTemplateEo.getCouponTemplateStatus())) {
            couponTemplateEo.setCouponTemplateStatus(AuditStatusEnum.WAIT_AUDIT.getKey());
        }
        couponTemplateEo.setStatus(EnableStatusEnum.ENABLE.getKey());
        int rows = this.couponTemplateDas.insert((BaseEo)couponTemplateEo);
        if (rows > 0) {
            this.couponItemService.batchInsert(couponTemplateEo.getId(), itemScopeType, objIds);
            this.couponUserService.batchInsert(couponTemplateEo.getId(), userIds);
        }
        return couponTemplateEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyCouponTemplate(CouponTemplateEo couponTemplateEo, String itemScopeType, List<Long> itemIds, List<Long> userIds) {
        this.couponTemplateDas.updateSelective((BaseEo)couponTemplateEo);
        this.couponItemService.batchInsert(couponTemplateEo.getId(), itemScopeType, itemIds);
        this.couponUserService.batchInsert(couponTemplateEo.getId(), userIds);
    }

    @Override
    public void modifyCouponTemplateStatus(Long couponTemplateId, AuditStatusEnum couponTemplateStatus) {
        CouponTemplateEo couponTemplateEo = new CouponTemplateEo();
        couponTemplateEo.setId(couponTemplateId);
        couponTemplateEo.setCouponTemplateStatus(couponTemplateStatus.getKey());
        this.couponTemplateDas.updateSelective((BaseEo)couponTemplateEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCouponTemplate(long couponTemplateId) {
        this.couponUserService.delete(couponTemplateId);
        this.couponItemService.delete(couponTemplateId);
        this.couponTemplateDas.logicDeleteById(Long.valueOf(couponTemplateId));
    }

    @Override
    public CouponTemplateEo getCouponTemplateById(Long templateId) {
        return (CouponTemplateEo)this.couponTemplateDas.selectByPrimaryKey(templateId);
    }

    @Override
    public List<CouponTemplateResDto> queryCouponTemplates(CouponTemplateReqDto couponTemplateReqDto) {
        ArrayList couponTemplateEos = new ArrayList();
        Long acId = couponTemplateReqDto.getActivityId();
        List activityIds = couponTemplateReqDto.getActivityIds();
        if (CollectionUtils.isEmpty((Collection)activityIds)) {
            activityIds = Lists.newLinkedList();
        }
        if (null != acId) {
            activityIds.add(acId);
            couponTemplateReqDto.setActivityId(null);
        }
        CouponTemplateEo couponTemplateEo = CouponTemplateEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)couponTemplateReqDto, (BaseEo)couponTemplateEo);
        if (!CollectionUtils.isEmpty((Collection)activityIds)) {
            couponTemplateEo.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("activity_id", activityIds).get());
        }
        if (couponTemplateReqDto.getChannel() != null) {
            couponTemplateEo.setChannel(couponTemplateReqDto.getChannel().getKey());
        }
        if (couponTemplateReqDto.getCouponType() != null) {
            couponTemplateEo.setCouponType(couponTemplateReqDto.getCouponType().getKey());
        }
        if (couponTemplateReqDto.getUseSuperimposedType() != null) {
            couponTemplateEo.setUseSuperimposedType(couponTemplateReqDto.getUseSuperimposedType().getKey());
        }
        couponTemplateEo.setCouponTemplateStatus(AuditStatusEnum.AUDIT_PASS.getKey());
        List couponTemplateEoList = this.couponTemplateDas.select((BaseEo)couponTemplateEo);
        couponTemplateEos.addAll(couponTemplateEoList);
        ArrayList<CouponTemplateResDto> couponTemplateResDtoList = new ArrayList<CouponTemplateResDto>();
        DtoHelper.eoList2DtoList(couponTemplateEos, couponTemplateResDtoList, CouponTemplateResDto.class);
        return couponTemplateResDtoList;
    }

    @Override
    public List<CouponTemplateShowRespDto> queryCouponDefinesByItemId(Long itemId) {
        List couponTemplateShowVoList = this.couponTemplateDas.selectByItemId(itemId);
        if (!CollectionUtils.isEmpty((Collection)couponTemplateShowVoList)) {
            return couponTemplateShowVoList.parallelStream().map(couponTemplateShowVo -> BeanCopyUtil.copyProperties(CouponTemplateShowRespDto.class, couponTemplateShowVo, new String[0])).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public List<Long> queryCouponTemplatesByOrderAmt(Double orderAmount) {
        return this.couponTemplateDas.selectCouponTemplatesByOrderAmt(orderAmount);
    }

    @Override
    public CouponItemRangeRespDto queryItemRange(Long couponTemplateId) {
        CouponTemplateEo templateEo = (CouponTemplateEo)this.couponTemplateDas.selectByPrimaryKey(couponTemplateId);
        if (templateEo == null) {
            throw new BusinessRuntimeException("11002", "\u4f18\u60e0\u5238\u6a21\u677f\u4e0d\u5b58\u5728 | couponTemplateId = " + couponTemplateId);
        }
        List<CouponItemMappingEo> items = this.couponItemService.queryByCouponTemplateId(couponTemplateId);
        ArrayList sellerIdList = new ArrayList();
        ArrayList shopIdList = new ArrayList();
        ArrayList categoryIdList = new ArrayList();
        ArrayList itemIdList = new ArrayList();
        if (!CollectionUtils.isEmpty(items)) {
            items.forEach(eo -> {
                if (CouponItemRange.SELLER.getKey().equals(eo.getItemRange())) {
                    sellerIdList.add(eo.getBizId());
                } else if (CouponItemRange.SHOP.getKey().equals(eo.getItemRange())) {
                    shopIdList.add(eo.getBizId());
                } else if (CouponItemRange.CATEGORY.getKey().equals(eo.getItemRange())) {
                    categoryIdList.add(eo.getBizId());
                } else if (CouponItemRange.ITEM.getKey().equals(eo.getItemRange())) {
                    itemIdList.add(eo.getBizId());
                }
            });
        }
        CouponItemRangeRespDto dto = new CouponItemRangeRespDto();
        dto.setItemRange(templateEo.getItemRange());
        dto.setSellerIdList(sellerIdList);
        dto.setShopIdList(shopIdList);
        dto.setCategoryIdList(categoryIdList);
        dto.setItemIdList(itemIdList);
        return dto;
    }

    @Override
    public List<CouponTemplateResDto> queryByItemRange(CouponItemRangeQueryReqDto couponItemRangeQueryReqDto) {
        List list;
        Long tenantId = couponItemRangeQueryReqDto.getTenantId();
        Long instanceId = couponItemRangeQueryReqDto.getInstanceId();
        Long sellerId = couponItemRangeQueryReqDto.getSellerId();
        Long shopId = couponItemRangeQueryReqDto.getShopId();
        Long categoryId = couponItemRangeQueryReqDto.getCategoryId();
        Long itemId = couponItemRangeQueryReqDto.getItemId();
        ArrayList<Long> couponTemplateIdList = new ArrayList<Long>();
        CouponItemMappingEo mappingEo = CouponItemMappingEo.newInstance();
        mappingEo.setTenantId(tenantId);
        mappingEo.setInstanceId(instanceId);
        if (sellerId != null) {
            mappingEo.setItemRange(CouponItemRange.SELLER.getKey());
            mappingEo.setBizId(sellerId);
            list = this.couponItemMappingDas.select((BaseEo)mappingEo);
            for (CouponItemMappingEo couponItemMappingEo : list) {
                couponTemplateIdList.add(couponItemMappingEo.getCouponTemplateId());
            }
        }
        if (shopId != null) {
            mappingEo.setItemRange(CouponItemRange.SHOP.getKey());
            mappingEo.setBizId(shopId);
            list = this.couponItemMappingDas.select((BaseEo)mappingEo);
            for (CouponItemMappingEo couponItemMappingEo : list) {
                couponTemplateIdList.add(couponItemMappingEo.getCouponTemplateId());
            }
        }
        if (categoryId != null) {
            mappingEo.setItemRange(CouponItemRange.CATEGORY.getKey());
            mappingEo.setBizId(categoryId);
            list = this.couponItemMappingDas.select((BaseEo)mappingEo);
            for (CouponItemMappingEo couponItemMappingEo : list) {
                couponTemplateIdList.add(couponItemMappingEo.getCouponTemplateId());
            }
        }
        if (itemId != null) {
            mappingEo.setItemRange(CouponItemRange.ITEM.getKey());
            mappingEo.setBizId(itemId);
            list = this.couponItemMappingDas.select((BaseEo)mappingEo);
            for (CouponItemMappingEo couponItemMappingEo : list) {
                couponTemplateIdList.add(couponItemMappingEo.getCouponTemplateId());
            }
        }
        if (couponTemplateIdList.isEmpty()) {
            return null;
        }
        List templateList = this.couponTemplateDas.selectByIdsAndStatus(couponTemplateIdList, ActivityStatusEnum.ACTIVATE.getKey());
        ArrayList<CouponTemplateResDto> couponTemplateResDtoList = new ArrayList<CouponTemplateResDto>();
        DtoHelper.eoList2DtoList((Collection)templateList, couponTemplateResDtoList, CouponTemplateResDto.class);
        return couponTemplateResDtoList;
    }

    @Override
    public void disable(long couponTemplateId) {
        CouponTemplateEo eo = CouponTemplateEo.newInstance();
        eo.setId(Long.valueOf(couponTemplateId));
        eo.setStatus(EnableStatusEnum.DISABLE.getKey());
        this.couponTemplateDas.updateSelective((BaseEo)eo);
    }

    @Override
    public void enable(long couponTemplateId) {
        CouponTemplateEo eo = CouponTemplateEo.newInstance();
        eo.setId(Long.valueOf(couponTemplateId));
        eo.setStatus(EnableStatusEnum.ENABLE.getKey());
        this.couponTemplateDas.updateSelective((BaseEo)eo);
    }

    @Override
    public CouponTemplateEo queryByActivityId(Long activityId) {
        CouponTemplateEo eo = CouponTemplateEo.newInstance();
        eo.setActivityId(activityId);
        return (CouponTemplateEo)this.couponTemplateDas.selectOne((BaseEo)eo);
    }

    @Override
    public List<CouponTemplateExtRespDto> queryByIds(List<Long> templateIds) {
        if (CollectionUtils.isEmpty(templateIds)) {
            return Collections.EMPTY_LIST;
        }
        CouponTemplateEo param = CouponTemplateEo.newInstance();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"id", templateIds));
        param.setSqlFilters((List)sqlFilters);
        List couponTemplateEos = this.couponTemplateDas.select((BaseEo)param);
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)couponTemplateEos, CouponTemplateExtRespDto.class);
        List<Long> activityIds = list.stream().map(CouponTemplateExtRespDto::getActivityId).collect(Collectors.toList());
        Map<Long, String> tagMap = this.queryActivityListByIds(activityIds);
        list.forEach(couponTemplate -> couponTemplate.setActivityTag((String)tagMap.get(couponTemplate.getActivityId())));
        return list;
    }

    @Override
    public Map<Long, String> queryActivityListByIds(List<Long> activityIds) {
        List<ActivityRespDto> activityRespDtoList;
        HashMap<Long, String> tagMap = new HashMap<Long, String>();
        ArrayList<Long> notcacheList = new ArrayList<Long>();
        activityIds.forEach(id -> {
            String tag = this.activityService.getActivityTag((Long)id);
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)tag)) {
                notcacheList.add((Long)id);
            } else {
                tagMap.put((Long)id, tag);
            }
        });
        if (!notcacheList.isEmpty() && (activityRespDtoList = this.activityService.queryActivityListByIds(notcacheList)) != null) {
            activityRespDtoList.forEach(activityRespDto -> {
                if (activityRespDto.getTag() == null) {
                    activityRespDto.setTag("");
                }
                tagMap.put(activityRespDto.getId(), activityRespDto.getTag());
                this.activityService.setActivityTagCache(activityRespDto.getId(), activityRespDto.getTag());
            });
        }
        return tagMap;
    }
}

