/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.exchange.account.apiimpl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerExtDetailRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.IExchangeBalanceAccountApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeAccountUseReq;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeBalanceAccountReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeBalanceRollBackReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeBalanceTurnoverReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.InitExchangeAccountReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ManualAdjustReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.response.ExchangeBalanceAccountRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.enums.TurnoverChangeTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.exchange.account.service.IExchangeBalanceAccountService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.exchange.account.service.IExchangeBalanceTurnoverService;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExchangeBalanceAccountApiImpl
implements IExchangeBalanceAccountApi {
    private static final Logger logger = LoggerFactory.getLogger(ExchangeBalanceAccountApiImpl.class);
    @Resource
    private IExchangeBalanceAccountService exchangeBalanceAccountService;
    @Autowired
    private IExchangeBalanceTurnoverService exchangeBalanceTurnoverService;
    @Autowired
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ILockService lockService;

    public RestResponse<Long> addExchangeBalanceAccount(ExchangeBalanceAccountReqDto addReqDto) {
        return new RestResponse((Object)this.exchangeBalanceAccountService.addExchangeBalanceAccount(addReqDto));
    }

    public RestResponse<Void> modifyExchangeBalanceAccount(ExchangeBalanceAccountReqDto modifyReqDto) {
        this.exchangeBalanceAccountService.modifyExchangeBalanceAccount(modifyReqDto);
        return RestResponse.VOID;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> initExchangeAccount(InitExchangeAccountReqDto initExchangeAccountReqDto) {
        Long accountId = null;
        Long activityId = initExchangeAccountReqDto.getActivityId();
        Long customerId = initExchangeAccountReqDto.getCustomerId();
        CustomerExtDetailRespDto customerRespDto = (CustomerExtDetailRespDto)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryById(customerId));
        if (customerRespDto == null) {
            throw new BizException("\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u521d\u59cb\u5316\u6362\u8d2d\u989d\u5ea6\u7d2f\u8ba1\u8d26\u6237\u5931\u8d25");
        }
        String lockKey = activityId + "_" + customerId;
        Mutex lock = this.lockService.lock("mk_exchange_balance_account", lockKey, 1500, 1500, TimeUnit.MILLISECONDS);
        try {
            ExchangeBalanceAccountRespDto exchangeBalanceAccountRespDto = this.exchangeBalanceAccountService.queryByActivityIdAndCustomerId(activityId, customerId);
            if (exchangeBalanceAccountRespDto != null) {
                logger.info("\u6362\u8d2d\u989d\u5ea6\u7d2f\u8ba1\u8d26\u6237\u5df2\u521d\u59cb\u5316");
                new RestResponse((Object)exchangeBalanceAccountRespDto.getId());
            }
            ExchangeBalanceAccountReqDto accountReqDto = new ExchangeBalanceAccountReqDto();
            accountReqDto.setActivityId(activityId);
            accountReqDto.setCustomerId(customerId);
            accountReqDto.setCustomerCode(customerRespDto.getCode());
            accountReqDto.setCustomerName(customerRespDto.getName());
            accountReqDto.setOrganizationId(customerRespDto.getMerchantId());
            accountReqDto.setAvailableBalance(BigDecimal.ZERO);
            accountReqDto.setUsedBalance(BigDecimal.ZERO);
            accountReqDto.setOrganizationId(customerRespDto.getMerchantId());
            accountId = this.exchangeBalanceAccountService.addExchangeBalanceAccount(accountReqDto);
            ExchangeBalanceTurnoverReqDto initAccountTurnoverReqDto = new ExchangeBalanceTurnoverReqDto();
            initAccountTurnoverReqDto.setBalanceAccountId(accountId);
            initAccountTurnoverReqDto.setActivityId(activityId);
            initAccountTurnoverReqDto.setCustomerId(customerId);
            initAccountTurnoverReqDto.setCustomerCode(customerRespDto.getCode());
            initAccountTurnoverReqDto.setCustomerName(customerRespDto.getName());
            initAccountTurnoverReqDto.setOrderNo("");
            initAccountTurnoverReqDto.setChangeType(TurnoverChangeTypeEnum.INIT.getType());
            this.exchangeBalanceTurnoverService.addExchangeBalanceTurnover(initAccountTurnoverReqDto);
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316\u6362\u8d2d\u989d\u5ea6\u7d2f\u8ba1\u8d26\u6237\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)e));
            e.printStackTrace();
            throw new BizException("\u521d\u59cb\u5316\u6362\u8d2d\u989d\u5ea6\u7d2f\u8ba1\u8d26\u6237\u5931\u8d25,\u539f\u56e0 " + e.getMessage());
        }
        finally {
            this.lockService.unlock(lock);
        }
        return new RestResponse((Object)accountId);
    }

    public RestResponse<Void> useExchangeBalanceAccount(ExchangeAccountUseReq exchangeAccountUseReq) {
        this.exchangeBalanceAccountService.useExchangeBalanceAccount(exchangeAccountUseReq);
        return new RestResponse();
    }

    public RestResponse<Void> rollbackExchangeAccount(ExchangeBalanceRollBackReqDto rollBackReqDto) {
        this.exchangeBalanceAccountService.rollbackExchangeAccount(rollBackReqDto);
        return new RestResponse();
    }

    public RestResponse<Void> manualAdjust(ManualAdjustReqDto manualAdjustReqDto) {
        this.exchangeBalanceAccountService.manualAdjust(manualAdjustReqDto);
        return RestResponse.VOID;
    }
}

