/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.exchange.account.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeAccountUseReq;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeBalanceAccountReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeBalanceRollBackReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ManualAdjustReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.response.ExchangeBalanceAccountRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.enums.ExchangeAdjustTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.enums.ExchangeStatementChangeTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.enums.TurnoverChangeTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.model.ExcRuleContentDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.model.ExchangeRule;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.exchange.account.service.IExchangeBalanceAccountService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.fullreduction.enums.UnitEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ConditionDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ConditionEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.StdConditionEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.exchange.account.das.ExchangeBalanceAccountDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.exchange.account.das.ExchangeBalanceStatementDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.exchange.account.das.ExchangeBalanceTurnoverDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.exchange.account.eo.ExchangeBalanceAccountEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.exchange.account.eo.ExchangeBalanceStatementEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.exchange.account.eo.ExchangeBalanceTurnoverEo;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExchangeBalanceAccountServiceImpl
implements IExchangeBalanceAccountService {
    private static final Logger logger = LoggerFactory.getLogger(ExchangeBalanceAccountServiceImpl.class);
    @Autowired
    private IActivityService activityService;
    @Resource
    private ExchangeBalanceAccountDas exchangeBalanceAccountDas;
    @Resource
    private ILockService lockService;
    @Autowired
    private ExchangeBalanceTurnoverDas exchangeBalanceTurnoverDas;
    @Autowired
    private ExchangeBalanceStatementDas exchangeBalanceStatementDas;
    @Autowired
    private ConditionDas conditionDas;
    private static final Long TEMPLATE_ID = 1196944771412880296L;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addExchangeBalanceAccount(ExchangeBalanceAccountReqDto addReqDto) {
        ExchangeBalanceAccountEo exchangeBalanceAccountEo = new ExchangeBalanceAccountEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)exchangeBalanceAccountEo);
        this.exchangeBalanceAccountDas.insert((BaseEo)exchangeBalanceAccountEo);
        return exchangeBalanceAccountEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyExchangeBalanceAccount(ExchangeBalanceAccountReqDto modifyReqDto) {
        ExchangeBalanceAccountEo exchangeBalanceAccountEo = new ExchangeBalanceAccountEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)exchangeBalanceAccountEo);
        this.exchangeBalanceAccountDas.updateSelective((BaseEo)exchangeBalanceAccountEo);
    }

    @Override
    public ExchangeBalanceAccountRespDto queryById(Long id) {
        ExchangeBalanceAccountEo exchangeBalanceAccountEo = (ExchangeBalanceAccountEo)this.exchangeBalanceAccountDas.selectByPrimaryKey(id);
        ExchangeBalanceAccountRespDto exchangeBalanceAccountRespDto = new ExchangeBalanceAccountRespDto();
        DtoHelper.eo2Dto((BaseEo)exchangeBalanceAccountEo, (BaseVo)exchangeBalanceAccountRespDto);
        return exchangeBalanceAccountRespDto;
    }

    @Override
    public ExchangeBalanceAccountRespDto queryByActivityIdAndCustomerId(Long activityId, Long customerId) {
        ExchangeBalanceAccountRespDto exchangeBalanceAccountRespDto = null;
        if (activityId == null || customerId == null) {
            return exchangeBalanceAccountRespDto;
        }
        ExchangeBalanceAccountEo eo = new ExchangeBalanceAccountEo();
        eo.setActivityId(activityId);
        eo.setCustomerId(customerId);
        eo = (ExchangeBalanceAccountEo)this.exchangeBalanceAccountDas.selectOne((BaseEo)eo);
        if (eo != null) {
            exchangeBalanceAccountRespDto = new ExchangeBalanceAccountRespDto();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)exchangeBalanceAccountRespDto);
        }
        return exchangeBalanceAccountRespDto;
    }

    @Override
    public PageInfo<ExchangeBalanceAccountRespDto> queryByPage(ExchangeBalanceAccountReqDto exchangeBalanceAccountReqDto) {
        ExchangeBalanceAccountEo exchangeBalanceAccountEo = new ExchangeBalanceAccountEo();
        DtoHelper.dto2Eo((BaseVo)exchangeBalanceAccountReqDto, (BaseEo)exchangeBalanceAccountEo);
        PageInfo eoPageInfo = this.exchangeBalanceAccountDas.selectPage((BaseEo)exchangeBalanceAccountEo, exchangeBalanceAccountReqDto.getPageNum(), exchangeBalanceAccountReqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ExchangeBalanceAccountRespDto.class);
        dtoPageInfo.setList(dtoList);
        if (exchangeBalanceAccountReqDto.isNeedDiscountUnit() && CollectionUtils.isNotEmpty(dtoList)) {
            Set activityIds = dtoList.stream().map(ExchangeBalanceAccountRespDto::getActivityId).collect(Collectors.toSet());
            LambdaQueryWrapper conditionWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)conditionWrapper.eq(StdConditionEo::getConditionTemplateId, (Object)TEMPLATE_ID)).eq(BaseEo::getDr, (Object)0)).in(StdConditionEo::getActivityId, activityIds);
            List conditionEos = this.conditionDas.getMapper().selectList((Wrapper)conditionWrapper);
            Map<Long, ExchangeRule> conditionParamMap = conditionEos.stream().collect(Collectors.toMap(StdConditionEo::getActivityId, this::converter, (e1, e2) -> e1));
            for (ExchangeBalanceAccountRespDto exchangeBalanceAccountRespDto : dtoList) {
                ExchangeRule exchangeRule = conditionParamMap.get(exchangeBalanceAccountRespDto.getActivityId());
                if (exchangeRule == null || !CollectionUtils.isNotEmpty((Collection)exchangeRule.getExcRuleContents())) continue;
                ExcRuleContentDto excRuleContentDto = (ExcRuleContentDto)exchangeRule.getExcRuleContents().get(0);
                exchangeBalanceAccountRespDto.setDiscountUnit(excRuleContentDto.getDiscountUnit());
                if (UnitEnum.MONEY.getType().equals(excRuleContentDto.getDiscountUnit())) {
                    exchangeBalanceAccountRespDto.setDiscountUnitName("\u91d1\u989d");
                    continue;
                }
                exchangeBalanceAccountRespDto.setDiscountUnitName("\u6570\u91cf");
            }
        }
        return dtoPageInfo;
    }

    private ExchangeRule converter(ConditionEo conditionEo) {
        JSONObject jsonObject = JSON.parseObject((String)conditionEo.getConditionParams());
        ExchangeRule exchangeRule = (ExchangeRule)JSON.parseObject((String)jsonObject.getString("ExchangeCondition.rule"), ExchangeRule.class);
        return exchangeRule;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void useExchangeBalanceAccount(ExchangeAccountUseReq exchangeAccountUseReq) {
        this.verifyParam(exchangeAccountUseReq);
        String lockKey = exchangeAccountUseReq.getActivityId() + "_" + exchangeAccountUseReq.getCustomerId();
        Mutex lock = this.lockService.lock("mk_exchange_balance_account", lockKey, 1500, 1500, TimeUnit.MILLISECONDS);
        try {
            ExchangeBalanceAccountRespDto accountRespDto = this.queryByActivityIdAndCustomerId(exchangeAccountUseReq.getActivityId(), exchangeAccountUseReq.getCustomerId());
            if (accountRespDto == null || accountRespDto.getId() == null) {
                throw new BizException("\u7d2f\u8ba1\u989d\u5ea6\u8d26\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            BigDecimal reallyAvaBalance = exchangeAccountUseReq.getChangeAvaBalance().subtract(exchangeAccountUseReq.getChangeUsedBalance());
            BigDecimal newBalance = accountRespDto.getAvailableBalance().add(reallyAvaBalance);
            if (BigDecimal.ZERO.compareTo(newBalance) > 0) {
                throw new BizException("\u6362\u8d2d\u7d2f\u8ba1\u989d\u5ea6\u4e0d\u8db3");
            }
            BigDecimal newUsedBalance = accountRespDto.getUsedBalance().add(exchangeAccountUseReq.getChangeUsedBalance());
            ExchangeBalanceAccountEo useAccountUpdateEo = new ExchangeBalanceAccountEo();
            useAccountUpdateEo.setId(accountRespDto.getId());
            useAccountUpdateEo.setAvailableBalance(newBalance);
            useAccountUpdateEo.setUsedBalance(newUsedBalance);
            this.exchangeBalanceAccountDas.updateSelective((BaseEo)useAccountUpdateEo);
            ExchangeBalanceTurnoverEo turnoverEo = new ExchangeBalanceTurnoverEo();
            turnoverEo.setBalanceAccountId(accountRespDto.getId());
            turnoverEo.setActivityId(exchangeAccountUseReq.getActivityId());
            turnoverEo.setCustomerId(exchangeAccountUseReq.getCustomerId());
            turnoverEo.setCustomerCode(accountRespDto.getCustomerCode());
            turnoverEo.setCustomerName(accountRespDto.getCustomerName());
            turnoverEo.setOrderNo(exchangeAccountUseReq.getOrderNo());
            turnoverEo.setStatus(Integer.valueOf(0));
            turnoverEo.setOrganizationId(accountRespDto.getOrganizationId());
            turnoverEo.setChangeType(TurnoverChangeTypeEnum.SUBMIT_ORDER.getType());
            turnoverEo.setOldBalance(accountRespDto.getAvailableBalance());
            turnoverEo.setChangeBalance(reallyAvaBalance);
            turnoverEo.setNewBalance(newBalance);
            turnoverEo.setOldUsedBalance(accountRespDto.getUsedBalance());
            turnoverEo.setChangeUsedBalance(exchangeAccountUseReq.getChangeUsedBalance());
            turnoverEo.setNewUsedBalance(newUsedBalance);
            this.exchangeBalanceTurnoverDas.insert((BaseEo)turnoverEo);
            this.submitOrderSaveStatment(exchangeAccountUseReq, accountRespDto, newBalance);
        }
        catch (Exception e) {
            logger.error("\u4f7f\u7528\u6362\u8d2d\u989d\u5ea6\u8d26\u6237\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)e));
            e.printStackTrace();
            throw new BizException("\u4f7f\u7528\u6362\u8d2d\u989d\u5ea6\u8d26\u6237\u5931\u8d25,\u539f\u56e0 " + e.getMessage());
        }
        finally {
            this.lockService.unlock(lock);
        }
    }

    private void submitOrderSaveStatment(ExchangeAccountUseReq exchangeAccountUseReq, ExchangeBalanceAccountRespDto accountRespDto, BigDecimal newBalance) {
        ArrayList statementEos = Lists.newArrayList();
        if (BigDecimal.ZERO.compareTo(exchangeAccountUseReq.getChangeAvaBalance()) < 0) {
            ExchangeBalanceStatementEo giveStatementEo = new ExchangeBalanceStatementEo();
            giveStatementEo.setBalanceAccountId(accountRespDto.getId());
            giveStatementEo.setActivityId(exchangeAccountUseReq.getActivityId());
            giveStatementEo.setCustomerId(exchangeAccountUseReq.getCustomerId());
            giveStatementEo.setCustomerCode(accountRespDto.getCustomerCode());
            giveStatementEo.setCustomerName(accountRespDto.getCustomerName());
            giveStatementEo.setOrderNo(exchangeAccountUseReq.getOrderNo());
            giveStatementEo.setOrganizationId(accountRespDto.getOrganizationId());
            giveStatementEo.setChangeType(ExchangeStatementChangeTypeEnum.ORDER_GIVE.getType());
            giveStatementEo.setOldBalance(accountRespDto.getAvailableBalance());
            giveStatementEo.setChangeBalance(exchangeAccountUseReq.getChangeAvaBalance());
            giveStatementEo.setNewBalance(accountRespDto.getAvailableBalance().add(exchangeAccountUseReq.getChangeAvaBalance()));
            statementEos.add(giveStatementEo);
        }
        if (BigDecimal.ZERO.compareTo(exchangeAccountUseReq.getChangeUsedBalance()) < 0) {
            ExchangeBalanceStatementEo deductionStatementEo = new ExchangeBalanceStatementEo();
            deductionStatementEo.setBalanceAccountId(accountRespDto.getId());
            deductionStatementEo.setActivityId(exchangeAccountUseReq.getActivityId());
            deductionStatementEo.setCustomerId(exchangeAccountUseReq.getCustomerId());
            deductionStatementEo.setCustomerCode(accountRespDto.getCustomerCode());
            deductionStatementEo.setCustomerName(accountRespDto.getCustomerName());
            deductionStatementEo.setOrderNo(exchangeAccountUseReq.getOrderNo());
            deductionStatementEo.setOrganizationId(accountRespDto.getOrganizationId());
            deductionStatementEo.setChangeType(ExchangeStatementChangeTypeEnum.ORDER_DEDUCTION.getType());
            deductionStatementEo.setOldBalance(accountRespDto.getAvailableBalance().add(exchangeAccountUseReq.getChangeAvaBalance()));
            deductionStatementEo.setChangeBalance(exchangeAccountUseReq.getChangeUsedBalance().negate());
            deductionStatementEo.setNewBalance(newBalance);
            statementEos.add(deductionStatementEo);
        }
        if (CollectionUtils.isNotEmpty((Collection)statementEos)) {
            this.exchangeBalanceStatementDas.insertBatch((List)statementEos);
        }
    }

    private void verifyParam(ExchangeAccountUseReq exchangeAccountUseReq) {
        if (exchangeAccountUseReq.getActivityId() == null || exchangeAccountUseReq.getCustomerId() == null) {
            throw new BizException("\u6362\u8d2d\u6d3b\u52a8ID\u6216\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ActivityRespDto activityRespDto = this.activityService.queryById(exchangeAccountUseReq.getActivityId());
        if (!Objects.equals(ActivityType.EXCHANGE_ACTIVITY.getId(), activityRespDto.getActivityTemplateId())) {
            throw new BizException("\u6362\u8d2d\u6d3b\u52a8\u624d\u80fd\u4f7f\u7528\u7d2f\u8ba1\u989d\u5ea6\uff0c\u6d3b\u52a8ID\u3010" + exchangeAccountUseReq.getActivityId() + "\u3011");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void rollbackExchangeAccount(ExchangeBalanceRollBackReqDto rollBackReqDto) {
        Mutex lock = this.lockService.lock("mk_exchange_balance_account", rollBackReqDto.getOrderNo(), 1500, 1500, TimeUnit.MILLISECONDS);
        try {
            ExchangeBalanceTurnoverEo turnoverEos = new ExchangeBalanceTurnoverEo();
            turnoverEos.setOrderNo(rollBackReqDto.getOrderNo());
            turnoverEos.setStatus(Integer.valueOf(0));
            List rollBackTurnoverEoList = this.exchangeBalanceTurnoverDas.select((BaseEo)turnoverEos);
            if (CollectionUtils.isEmpty((Collection)rollBackTurnoverEoList)) {
                logger.info("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u53ef\u56de\u6eda\u6362\u8d2d\u989d\u5ea6\u8bb0\u5f55,\u8ba2\u5355\u7f16\u53f7\uff1a{}", (Object)rollBackReqDto.getOrderNo());
                return;
            }
            Set accountIds = rollBackTurnoverEoList.stream().map(ExchangeBalanceTurnoverEo::getBalanceAccountId).collect(Collectors.toSet());
            ExchangeBalanceAccountEo queryEo = new ExchangeBalanceAccountEo();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"id", accountIds));
            queryEo.setSqlFilters(sqlFilters);
            List accountEoList = this.exchangeBalanceAccountDas.select((BaseEo)queryEo);
            Map<Long, ExchangeBalanceAccountEo> accountEoMap = accountEoList.stream().collect(Collectors.toMap(e -> e.getId(), e -> e, (e1, e2) -> e1));
            for (ExchangeBalanceTurnoverEo turnoverEo : rollBackTurnoverEoList) {
                ExchangeBalanceAccountEo eo = accountEoMap.get(turnoverEo.getBalanceAccountId());
                if (eo == null) {
                    logger.info("\u6362\u8d2d\u989d\u5ea6\u8d26\u6237\u4e3a\u7a7a\uff1a{}", (Object)turnoverEo.getBalanceAccountId());
                    return;
                }
                String accountLockKey = turnoverEo.getActivityId() + "_" + turnoverEo.getCustomerId();
                Mutex accountLock = this.lockService.lock("mk_exchange_balance_account", accountLockKey, 1500, 1500, TimeUnit.MILLISECONDS);
                try {
                    BigDecimal oldBalance = eo.getAvailableBalance();
                    BigDecimal oldUsedBalance = eo.getUsedBalance();
                    ExchangeBalanceAccountEo rollBackAccountEo = new ExchangeBalanceAccountEo();
                    rollBackAccountEo.setId(eo.getId());
                    rollBackAccountEo.setAvailableBalance(oldBalance.subtract(turnoverEo.getChangeBalance()));
                    rollBackAccountEo.setUsedBalance(oldUsedBalance.subtract(turnoverEo.getChangeUsedBalance()));
                    this.exchangeBalanceAccountDas.updateSelective((BaseEo)rollBackAccountEo);
                    ExchangeBalanceTurnoverEo updateTurnoverEo = new ExchangeBalanceTurnoverEo();
                    updateTurnoverEo.setId(turnoverEo.getId());
                    updateTurnoverEo.setStatus(Integer.valueOf(1));
                    this.exchangeBalanceTurnoverDas.updateSelective((BaseEo)updateTurnoverEo);
                    ExchangeBalanceTurnoverEo addTurnoverEo = new ExchangeBalanceTurnoverEo();
                    addTurnoverEo.setBalanceAccountId(eo.getId());
                    addTurnoverEo.setActivityId(eo.getActivityId());
                    addTurnoverEo.setCustomerId(eo.getCustomerId());
                    addTurnoverEo.setCustomerCode(eo.getCustomerCode());
                    addTurnoverEo.setCustomerName(eo.getCustomerName());
                    addTurnoverEo.setOrderNo(rollBackReqDto.getOrderNo());
                    addTurnoverEo.setStatus(Integer.valueOf(1));
                    addTurnoverEo.setOrganizationId(eo.getOrganizationId());
                    addTurnoverEo.setChangeType(rollBackReqDto.getTurnoverChangeTypeEnum().getType());
                    addTurnoverEo.setOldBalance(oldBalance);
                    addTurnoverEo.setChangeBalance(turnoverEo.getChangeBalance().negate());
                    addTurnoverEo.setNewBalance(rollBackAccountEo.getAvailableBalance());
                    addTurnoverEo.setOldUsedBalance(oldUsedBalance);
                    addTurnoverEo.setChangeUsedBalance(turnoverEo.getChangeUsedBalance().negate());
                    addTurnoverEo.setNewUsedBalance(rollBackAccountEo.getUsedBalance());
                    this.exchangeBalanceTurnoverDas.insert((BaseEo)addTurnoverEo);
                    this.rollbacoSaveStatement(rollBackReqDto, eo);
                }
                catch (Exception e3) {
                    logger.error("\u56de\u6eda\u8d26\u6237\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)e3));
                    e3.printStackTrace();
                    throw new BizException("\u56de\u6eda\u8d26\u6237\u5931\u8d25,\u539f\u56e0 " + e3.getMessage());
                }
                finally {
                    this.lockService.unlock(accountLock);
                }
            }
        }
        catch (Exception e4) {
            logger.error("\u56de\u6eda\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)e4));
            e4.printStackTrace();
            throw new BizException("\u56de\u6eda\u5931\u8d25,\u539f\u56e0 " + e4.getMessage());
        }
        finally {
            this.lockService.unlock(lock);
        }
    }

    private void rollbacoSaveStatement(ExchangeBalanceRollBackReqDto rollBackReqDto, ExchangeBalanceAccountEo eo) {
        ExchangeBalanceStatementEo queryStatementEo = new ExchangeBalanceStatementEo();
        queryStatementEo.setOrderNo(rollBackReqDto.getOrderNo());
        queryStatementEo.setActivityId(eo.getActivityId());
        queryStatementEo.setCustomerId(eo.getCustomerId());
        List statementEos = this.exchangeBalanceStatementDas.select((BaseEo)queryStatementEo);
        if (CollectionUtils.isNotEmpty((Collection)statementEos)) {
            ExchangeBalanceStatementEo giveHistoryStatementEo;
            Map<Integer, ExchangeBalanceStatementEo> statementEoMap = statementEos.stream().collect(Collectors.toMap(ExchangeBalanceStatementEo::getChangeType, e -> e, (e1, e2) -> e1));
            ExchangeBalanceStatementEo deductionHistoryStatementEo = statementEoMap.get(ExchangeStatementChangeTypeEnum.ORDER_DEDUCTION.getType());
            BigDecimal currAvaBalance = eo.getAvailableBalance();
            ArrayList insertStatementEos = Lists.newArrayList();
            if (deductionHistoryStatementEo != null) {
                ExchangeBalanceStatementEo deductionStatementEo = new ExchangeBalanceStatementEo();
                deductionStatementEo.setBalanceAccountId(deductionHistoryStatementEo.getBalanceAccountId());
                deductionStatementEo.setActivityId(deductionHistoryStatementEo.getActivityId());
                deductionStatementEo.setCustomerId(deductionHistoryStatementEo.getCustomerId());
                deductionStatementEo.setCustomerCode(deductionHistoryStatementEo.getCustomerCode());
                deductionStatementEo.setCustomerName(deductionHistoryStatementEo.getCustomerName());
                deductionStatementEo.setOrderNo(deductionHistoryStatementEo.getOrderNo());
                deductionStatementEo.setOrganizationId(deductionHistoryStatementEo.getOrganizationId());
                deductionStatementEo.setChangeType(ExchangeStatementChangeTypeEnum.ORDER_BACK.getType());
                deductionStatementEo.setOldBalance(currAvaBalance);
                deductionStatementEo.setChangeBalance(deductionHistoryStatementEo.getChangeBalance().negate());
                currAvaBalance = currAvaBalance.add(deductionHistoryStatementEo.getChangeBalance().negate());
                deductionStatementEo.setNewBalance(currAvaBalance);
                insertStatementEos.add(deductionStatementEo);
            }
            if ((giveHistoryStatementEo = statementEoMap.get(ExchangeStatementChangeTypeEnum.ORDER_GIVE.getType())) != null) {
                ExchangeBalanceStatementEo giveStatementEo = new ExchangeBalanceStatementEo();
                giveStatementEo.setBalanceAccountId(giveHistoryStatementEo.getBalanceAccountId());
                giveStatementEo.setActivityId(giveHistoryStatementEo.getActivityId());
                giveStatementEo.setCustomerId(giveHistoryStatementEo.getCustomerId());
                giveStatementEo.setCustomerCode(giveHistoryStatementEo.getCustomerCode());
                giveStatementEo.setCustomerName(giveHistoryStatementEo.getCustomerName());
                giveStatementEo.setOrderNo(giveHistoryStatementEo.getOrderNo());
                giveStatementEo.setOrganizationId(giveHistoryStatementEo.getOrganizationId());
                giveStatementEo.setChangeType(ExchangeStatementChangeTypeEnum.GIVE_BACK.getType());
                giveStatementEo.setOldBalance(currAvaBalance);
                giveStatementEo.setChangeBalance(giveHistoryStatementEo.getChangeBalance().negate());
                giveStatementEo.setNewBalance(currAvaBalance.subtract(giveHistoryStatementEo.getChangeBalance()));
                insertStatementEos.add(giveStatementEo);
            }
            if (CollectionUtils.isNotEmpty((Collection)insertStatementEos)) {
                this.exchangeBalanceStatementDas.insertBatch((List)insertStatementEos);
            }
        }
    }

    @Override
    public void manualAdjust(ManualAdjustReqDto manualAdjustReqDto) {
        int row;
        ExchangeBalanceAccountEo queryEo = new ExchangeBalanceAccountEo();
        queryEo.setId(manualAdjustReqDto.getId());
        ExchangeBalanceAccountEo exchangeBalanceAccountEo = (ExchangeBalanceAccountEo)this.exchangeBalanceAccountDas.selectOne((BaseEo)queryEo);
        if (exchangeBalanceAccountEo == null) {
            throw new BizException("\u6362\u8d2d\u989d\u5ea6\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        BigDecimal amount = manualAdjustReqDto.getAmount();
        if (ExchangeAdjustTypeEnum.SUB.getType().equals(manualAdjustReqDto.getAdjustType())) {
            amount = amount.negate();
        }
        if ((row = this.exchangeBalanceAccountDas.updateForManualAdjust(manualAdjustReqDto.getId(), amount, manualAdjustReqDto.getBeforAmount())) == 0) {
            throw new BizException("\u624b\u5de5\u8c03\u6574\u5931\u8d25");
        }
        ExchangeBalanceStatementEo manualAdjustStatementEo = new ExchangeBalanceStatementEo();
        manualAdjustStatementEo.setBalanceAccountId(exchangeBalanceAccountEo.getId());
        manualAdjustStatementEo.setActivityId(exchangeBalanceAccountEo.getActivityId());
        manualAdjustStatementEo.setCustomerId(exchangeBalanceAccountEo.getCustomerId());
        manualAdjustStatementEo.setCustomerCode(exchangeBalanceAccountEo.getCustomerCode());
        manualAdjustStatementEo.setCustomerName(exchangeBalanceAccountEo.getCustomerName());
        manualAdjustStatementEo.setOrganizationId(exchangeBalanceAccountEo.getOrganizationId());
        manualAdjustStatementEo.setChangeType(ExchangeStatementChangeTypeEnum.MANUAL_ADJUST.getType());
        manualAdjustStatementEo.setOldBalance(exchangeBalanceAccountEo.getAvailableBalance());
        manualAdjustStatementEo.setChangeBalance(amount);
        manualAdjustStatementEo.setNewBalance(exchangeBalanceAccountEo.getAvailableBalance().add(amount));
        manualAdjustStatementEo.setRemark(manualAdjustReqDto.getRemark());
        this.exchangeBalanceStatementDas.insert((BaseEo)manualAdjustStatementEo);
    }
}

