/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.biz.member.api.basis.dto.response.MemberInfoDetailRespDto;
import com.dtyunxi.yundt.cube.biz.member.api.basis.query.IMemberInfoExtQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemStorageApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BatchItemStorageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BatchItemStorageRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemStorageRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.ITaskQueryApi;
import com.dtyunxi.yundt.cube.center.scheduler.common.constants.TaskStatusEnum;
import com.dtyunxi.yundt.cube.center.user.api.dto.AppInstanceDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IApplicationQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityAuditReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.OrderStatusChangeOrderDetailDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.AuditStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.CheckPointEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ConditionValidTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ConstantsStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.IEngineApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.DepositInfoReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionInfoReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionPointInfoReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.DepositInfoRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.PromotionGenInfoRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.PromotionPointInfoRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionExtCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ActivityCoupon;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.utils.MapUtils;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IActivityExtService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IActivityJoinLogExtService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.query.IActivityExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.query.IConditionExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.utils.ContextUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityItemRuleService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityJoinNumService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.coupon.service.ICouponService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ActivityEngineClient;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.DateUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.conf.param.ActivityStockTypeParam;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityJoinLogEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.StdActivityJoinLogEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ActivityExtServiceImpl
implements IActivityExtService {
    private static final Logger logger = LoggerFactory.getLogger(ActivityExtServiceImpl.class);
    @Resource
    private ActivityDas activityDas;
    @Resource
    private ICouponService couponService;
    @Resource
    private IItemStorageApi itemStorageApi;
    @Resource
    private ITaskQueryApi taskQueryApi;
    @CubeResource
    private ActivityStockTypeParam activityStockTypeParam;
    @Resource
    private IConditionExtQueryService conditionQueryService;
    @Resource
    private IActivityItemRuleService activityItemRuleService;
    @Resource
    private IActivityJoinLogExtService activityJoinLogExtService;
    @Resource
    private ITaskApi taskApi;
    @Value(value="${scheduler.client.app_code}")
    private String appCode;
    @Resource
    private ActivityEngineClient engineClient;
    @Resource
    private IActivityExtQueryService activityExtQueryService;
    @Resource
    private IActivityService activityService;
    @Resource
    private IEngineApi engineApi;
    @Autowired
    private IMemberInfoExtQueryApi memberInfoExtQueryApi;
    @Resource
    private IApplicationQueryApi applicationQueryApi;
    @Resource
    private IActivityJoinNumService activityJoinNumService;

    @Override
    public void updateSelective(ActivityEo activityEo) {
        this.activityDas.updateSelective((BaseEo)activityEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableById(Long activityId) {
        ActivityEo activityEo = (ActivityEo)this.activityDas.selectByPrimaryKey(activityId);
        if (activityEo == null) {
            throw new ProBizException(ProExceptionCode.RECORD_NOT_EXIST);
        }
        if (!Objects.equals(ActivityStatusEnum.NEW.getKey(), activityEo.getActivityStatus())) {
            throw new ProBizException(ProExceptionCode.PARAMS_ERR.format(new String[]{"\u6d3b\u52a8\u5904\u4e8e\u65b0\u5efa\u72b6\u6001\u624d\u80fd\u8fdb\u884c\u542f\u7528\u64cd\u4f5c"}));
        }
        Date beginTime = activityEo.getBeginTime();
        Date endTime = activityEo.getEndTime();
        Date now = new Date();
        ActivityEo updateEo = new ActivityEo();
        updateEo.setId(activityId);
        if (endTime.before(now)) {
            updateEo.setActivityStatus(ActivityStatusEnum.FINISH.getKey());
            this.activityDas.updateSelective((BaseEo)updateEo);
        } else if (beginTime.before(now)) {
            updateEo.setActivityStatus(ActivityStatusEnum.ACTIVATE.getKey());
            this.activityDas.updateSelective((BaseEo)updateEo);
            this.createActivityTask(activityEo, "\u8425\u9500\u4e2d\u5fc3\uff1a\u6d3b\u52a8\u7ed3\u675f", "activityFinishTask", endTime);
        } else {
            updateEo.setActivityStatus(ActivityStatusEnum.READY.getKey());
            this.activityDas.updateSelective((BaseEo)updateEo);
            this.createActivityTask(activityEo, "\u8425\u9500\u4e2d\u5fc3\uff1a\u6d3b\u52a8\u5f00\u59cb", "activityActivateTask", beginTime);
            this.createActivityTask(activityEo, "\u8425\u9500\u4e2d\u5fc3\uff1a\u6d3b\u52a8\u7ed3\u675f", "activityFinishTask", endTime);
        }
        ActivityAuditReqDto auditReqDto = new ActivityAuditReqDto();
        Long auditPerson = ServiceContext.getContext().getRequestUserId();
        auditPerson = auditPerson == null ? 0L : auditPerson;
        auditReqDto.setAuditPerson(auditPerson);
        auditReqDto.setParentAuditPerson(auditPerson);
        auditReqDto.setAuditStatus(AuditStatusEnum.AUDIT_PASS.getKey());
        this.activityService.audit(activityId, auditReqDto);
    }

    @Override
    public void enableBatch(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ids.forEach(this::enableById);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableById(Long activityId) {
        ActivityEo activityEo = (ActivityEo)this.activityDas.selectByPrimaryKey(activityId);
        if (activityEo == null) {
            throw new ProBizException(ProExceptionCode.RECORD_NOT_EXIST);
        }
        if (!Objects.equals(ActivityStatusEnum.READY.getKey(), activityEo.getActivityStatus()) && !Objects.equals(ActivityStatusEnum.ACTIVATE.getKey(), activityEo.getActivityStatus())) {
            throw new ProBizException(ProExceptionCode.PARAMS_ERR.format(new String[]{"\u6d3b\u52a8\u5904\u4e8e\u65b0\u5efa\u3001\u5c31\u7eea\u548c\u6d3b\u52a8\u4e2d\u72b6\u6001\u624d\u80fd\u8fdb\u884c\u7981\u7528\u64cd\u4f5c"}));
        }
        this.disableActivity(activityId, ActivityStatusEnum.DISABLE);
        this.deleteActivityTask(activityId);
    }

    @Override
    public void disableBatch(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ids.forEach(this::disableById);
    }

    @Override
    public void deleteById(Long activityId) {
        ActivityEo activityEo = (ActivityEo)this.activityDas.selectByPrimaryKey(activityId);
        if (activityEo == null) {
            throw new ProBizException(ProExceptionCode.RECORD_NOT_EXIST);
        }
        if (Objects.equals(ActivityStatusEnum.ACTIVATE.getKey(), activityEo.getActivityStatus())) {
            throw new ProBizException(ProExceptionCode.PARAMS_ERR.format(new String[]{"\u8fdb\u884c\u4e2d\u7684\u6d3b\u52a8\u4e0d\u5141\u8bb8\u5220\u9664"}));
        }
        this.couponService.finish(activityId);
        this.activityDas.logicDeleteById(activityId);
        this.deleteActivityTask(activityId);
    }

    @Override
    public void deleteBatch(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ids.forEach(this::deleteById);
    }

    @Override
    public DepositInfoRespDto deposit(DepositInfoReqDto dto, boolean execute) {
        List<ActivityEo> activityEos = this.activityExtQueryService.activateAcList(dto.getActivityTemplateId());
        DepositInfoRespDto respDto = new DepositInfoRespDto();
        respDto.setMemberId(dto.getMemberId());
        respDto.setTradeCode(dto.getTradeCode());
        respDto.setCoupon("");
        BigDecimal defaultMount = BigDecimal.ZERO;
        respDto.setMoney(defaultMount);
        respDto.setPoint(0L);
        HashMap<ActivityEo, EngineParams> matchAc = new HashMap<ActivityEo, EngineParams>(3);
        for (ActivityEo activity : activityEos) {
            EngineParams params = dto.toParams();
            params.setActivityId(activity.getId().longValue());
            try {
                this.engineClient.defineCheckpoint(CheckPointEnum.REVIEW_ACTIVITY.toString()).execute(params);
                matchAc.put(activity, params);
            }
            catch (Exception e) {
                this.processException(e);
            }
        }
        Collection<ActivityEo> hitActivities = this.activityExtQueryService.mutex(matchAc.keySet());
        StringBuilder aIds = new StringBuilder();
        HashMap<String, Integer> coupons = new HashMap<String, Integer>(3);
        for (ActivityEo activity : hitActivities) {
            EngineParams params = (EngineParams)matchAc.get(activity);
            aIds.append(activity.getId()).append(",");
            BigDecimal amount = (BigDecimal)MapUtils.getObject((Map)params.getExtendsAttribute(), (Object)"rechargeGiftAmt", (Object)BigDecimal.ZERO);
            respDto.setMoney(respDto.getMoney().add(amount));
            BigDecimal points = (BigDecimal)MapUtils.getObject((Map)params.getExtendsAttribute(), (Object)"returnPoints", (Object)BigDecimal.ZERO);
            respDto.setPoint(respDto.getPoint() + points.longValue());
            Map tempCoupons = (Map)params.getExtendsAttribute().get("returnCoupon");
            if (CollectionUtils.isEmpty((Map)tempCoupons)) continue;
            for (Map.Entry entry : tempCoupons.entrySet()) {
                String couponId = (String)entry.getKey();
                Integer num = (Integer)coupons.get(couponId);
                if (null == num) {
                    num = 0;
                }
                num = num + (Integer)entry.getValue();
                coupons.put(couponId, num);
            }
        }
        if (StringUtils.isEmpty((CharSequence)aIds.toString())) {
            throw new ProBizException((ProExceptionCode)ProExceptionExtCode.ACTIVITY_NOT_ACTIVATE);
        }
        respDto.setActivityId(aIds.substring(0, aIds.lastIndexOf(",")));
        if (!CollectionUtils.isEmpty(coupons)) {
            respDto.setCoupon(JSON.toJSONString(coupons));
        }
        return respDto;
    }

    private void processException(Exception e) {
        if (e instanceof ProBizException) {
            ProBizException te = (ProBizException)e;
            logger.info("\u53c2\u4e0e\u6d3b\u52a8\u51fa\u73b0\u9519\u8bef\uff1a{},{}", (Object)te.getCode(), (Object)te.getMessage());
        } else {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public PromotionGenInfoRespDto promotion(PromotionInfoReqDto dto, Long activityTemplateId) {
        List<ActivityEo> activityEos = this.activityExtQueryService.activateAcList(activityTemplateId);
        PromotionGenInfoRespDto result = new PromotionGenInfoRespDto();
        result.setMemberId(dto.getMemberId());
        result.setTradeCode(dto.getTradeCode());
        List items = dto.getItems();
        StringBuilder aIds = new StringBuilder();
        HashMap<ActivityEo, EngineParams> matchAc = new HashMap<ActivityEo, EngineParams>(3);
        for (ActivityEo activity : activityEos) {
            EngineParams params = this.createEngineParams(items, activity, dto.getMemberId(), dto.getTradeCode());
            params.setGifts(dto.getGifts());
            params.setShopId(dto.getShopCode());
            params.setFreight(dto.getFreight());
            try {
                this.engineClient.defineCheckpoint(CheckPointEnum.REVIEW_ACTIVITY.toString()).execute(params);
                matchAc.put(activity, params);
            }
            catch (Exception e) {
                this.processException(e);
            }
        }
        Collection<ActivityEo> hitActivities = this.activityExtQueryService.mutex(matchAc.keySet());
        for (ActivityEo activity : hitActivities) {
            EngineParams params = (EngineParams)matchAc.get(activity);
            aIds.append(activity.getId()).append(",");
            result.setExtendsAttribute(params.getExtendsAttribute());
            result.setItems(params.getItems());
            result.setTotalDiscountAmount(params.getTotalDiscountAmount());
            result.setFreight(params.getFreight());
            result.setTotalDiscountFreight(params.getTotalDiscountFreight());
            Map extendMap = params.getExtendsAttribute();
            result.setReturnPoints(MapUtils.getBigDecimal((Map)extendMap, (Object)"returnPoints"));
            result.setReturnCoupon(MapUtils.getMap((Map)extendMap, (Object)"returnCoupon"));
            result.setReturnGift(MapUtils.getMap((Map)extendMap, (Object)"returnGift"));
        }
        result.setActivityId(aIds.substring(0, aIds.lastIndexOf(",")));
        return result;
    }

    private void handleOrderStatusCancelFail(OrderStatusChangeOrderDetailDto orderReqDto, EngineParams engineParams) {
        logger.info("\u6d3b\u52a8id={}\uff0c\u53d6\u6d88\u8ba2\u5355\u56de\u9000\u5e93\u5b58\u5904\u7406\uff0c\u8bfb\u53d6\u914d\u7f6e\u9879={}", (Object)engineParams.getActivityId(), this.activityStockTypeParam.getValue());
        if (ActivityStockTypeParam.ONLY.equals(this.activityStockTypeParam.getValue())) {
            return;
        }
        logger.info("\u6d3b\u52a8id={}\uff0c\u53d6\u6d88\u8ba2\u5355\u56de\u9000\u5e93\u5b58\u5904\u7406\uff0c\u8bfb\u53d6\u914d\u7f6e\u9879={},\u9700\u8981\u56de\u9000\u5230\u5546\u54c1", (Object)engineParams.getActivityId(), this.activityStockTypeParam.getValue());
        if ("2".equals(orderReqDto.getBizType()) || "3".equals(orderReqDto.getBizType())) {
            logger.info("\u8ba2\u5355\u53f7{}\u4e3a\u62fc\u56e2\u6d3b\u52a8\u6216\u8005\u79d2\u6740\u6d3b\u52a8", (Object)orderReqDto.getOrderCode());
            OrderStatusChangeOrderDetailDto.OrderActivityInfoReqDto orderActivityInfoReqDto = (OrderStatusChangeOrderDetailDto.OrderActivityInfoReqDto)orderReqDto.getActivitys().get(0);
            ActivityRespDto activityRespDto = this.activityService.getById(orderActivityInfoReqDto.getActivityId());
            logger.info("\u8ba2\u5355\u53f7{}\u5f53\u524d\u6d3b\u52a8\u72b6\u6001{}", (Object)orderReqDto.getOrderCode(), (Object)activityRespDto.getActivityStatus());
            if (!activityRespDto.getActivityStatus().equals(ActivityStatusEnum.ACTIVATE.getKey())) {
                logger.info("\u6d3b\u52a8={},\u5df2\u7ecf\u7ed3\u675f\uff0c\u8ba2\u5355\u53f7{}\uff0c\u56de\u6eda\u5230\u5546\u54c1\u5e93\u5b58", (Object)engineParams.getActivityId(), (Object)orderReqDto.getOrderCode());
                List<ActivityJoinLogEo> activityJoinLogEos = this.activityJoinLogExtService.getByOrderCode(orderReqDto.getOrderCode());
                List needReturnLogs = activityJoinLogEos.stream().filter(activityJoinLog -> !activityJoinLog.getStatus().equals(ConstantsStatusEnum.CANCEL)).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(needReturnLogs)) {
                    logger.info("\u6d3b\u52a8={},\u5df2\u7ecf\u7ed3\u675f\uff0c\u8ba2\u5355\u53f7{}\uff0c\u65e0\u4efb\u4f55\u56de\u6eda\u5546\u54c1\u4fe1\u606f", (Object)engineParams.getActivityId(), (Object)orderReqDto.getOrderCode());
                }
                List rollBackItemStorages = needReturnLogs.stream().map(joinLogEo -> {
                    ItemStorageReqDto itemStorageReqDto = new ItemStorageReqDto();
                    itemStorageReqDto.setBalance(Long.valueOf(joinLogEo.getItemNum().intValue()));
                    itemStorageReqDto.setOrderNo(orderReqDto.getOrderCode());
                    itemStorageReqDto.setShopId(Long.valueOf(joinLogEo.getShopId()));
                    itemStorageReqDto.setSkuId(Long.valueOf(joinLogEo.getSkuId()));
                    return itemStorageReqDto;
                }).collect(Collectors.toList());
                BatchItemStorageReqDto batchItemStorageReqDto = new BatchItemStorageReqDto();
                batchItemStorageReqDto.setOpt(BatchItemStorageReqDto.ADD);
                batchItemStorageReqDto.setItemStorageReqDtoList(rollBackItemStorages);
                RestResponse batchItemStorageRespDtoRestResponse = this.itemStorageApi.batchOperatingItemStorage(batchItemStorageReqDto);
                if (!"0".equals(batchItemStorageRespDtoRestResponse.getResultCode())) {
                    logger.error("\u6d3b\u52a8{}\u8ba2\u5355\u53f7{}\u64cd\u4f5c\u56de\u9000\u5e93\u5b58\u6709\u8bef", (Object)engineParams.getActivityId(), (Object)orderReqDto.getOrderCode());
                }
                List returnSuccessList = needReturnLogs;
                BatchItemStorageRespDto batchItemStorageRespDto = (BatchItemStorageRespDto)batchItemStorageRespDtoRestResponse.getData();
                if (!batchItemStorageRespDto.getIfAllSuccess().booleanValue()) {
                    logger.error("\u6d3b\u52a8{}\u8ba2\u5355\u53f7{}\u64cd\u4f5c\u56de\u9000\u5e93\u5b58\u6ca1\u6709\u5b8c\u5168\u6210\u529f", (Object)engineParams.getActivityId(), (Object)orderReqDto.getOrderCode());
                    returnSuccessList = needReturnLogs.stream().filter(joinLogEo -> this.ifExist(batchItemStorageRespDto.getSuccessList(), Long.valueOf(joinLogEo.getShopId()), Long.valueOf(joinLogEo.getSkuId()))).collect(Collectors.toList());
                }
                List<Long> returnIds = returnSuccessList.stream().map(activityJoinLogEo -> activityJoinLogEo.getId()).collect(Collectors.toList());
                this.activityJoinLogExtService.cancel(returnIds);
            } else {
                logger.error("\u6d3b\u52a8={}\uff0c\u8ba2\u5355={}\uff0c\u6d3b\u52a8\u5728\u8fdb\u884c\u4e2d\uff0c\u4e0d\u505a\u5904\u7406", (Object)engineParams.getActivityId(), (Object)orderReqDto.getOrderCode());
            }
        }
    }

    private void handleOrderStatusByFinishedActivity(OrderStatusChangeOrderDetailDto orderReqDto, EngineParams engineParams) {
        logger.info("B\u7aef\u5904\u7406\u8c03\u7528\u53d6\u6d88\u5f15\u64ce\u540e\u7f6e\u5904\u7406\uff0corderReqDto={}\uff0cengineParams={}", (Object)JSON.toJSONString((Object)orderReqDto), (Object)JSON.toJSONString((Object)engineParams));
        if (orderReqDto.getActivitys().size() == engineParams.getActivityIds().size()) {
            return;
        }
        List activityIds = CollectionUtils.isEmpty((Collection)engineParams.getActivityIds()) ? orderReqDto.getActivitys().stream().map(OrderStatusChangeOrderDetailDto.OrderActivityInfoReqDto::getActivityId).collect(Collectors.toList()) : orderReqDto.getActivitys().stream().map(OrderStatusChangeOrderDetailDto.OrderActivityInfoReqDto::getActivityId).filter(aLong -> !engineParams.getActivityIds().contains(aLong)).collect(Collectors.toList());
        logger.info("\u8ba2\u5355\u53f7={}\uff0c\u9700\u8981\u56de\u6eda\u7684\u6d3b\u52a8ids={}\uff0c\u53d6\u6d88\u8ba2\u5355\u56de\u9000\u5e93\u5b58\u5904\u7406\uff0c\u8bfb\u53d6\u914d\u7f6e\u9879={}", new Object[]{orderReqDto.getOrderCode(), activityIds, this.activityStockTypeParam.getValue()});
        if (ActivityStockTypeParam.ONLY.equals(this.activityStockTypeParam.getValue())) {
            return;
        }
        logger.info("\u8ba2\u5355\u53f7{}\u5b58\u5728\u975e\u4f18\u60e0\u5238\u6d3b\u52a8", (Object)orderReqDto.getOrderCode());
        for (Long activityId : activityIds) {
            ActivityRespDto activityRespDto = this.activityService.getById(activityId);
            logger.info("\u8ba2\u5355\u53f7{}\u5f53\u524d\u6d3b\u52a8\u72b6\u6001{}", (Object)orderReqDto.getOrderCode(), (Object)activityRespDto.getActivityStatus());
            if (!activityRespDto.getActivityStatus().equals(ActivityStatusEnum.ACTIVATE.getKey())) {
                logger.info("\u6d3b\u52a8={},\u5df2\u7ecf\u7ed3\u675f\uff0c\u8ba2\u5355\u53f7{}\uff0c\u56de\u6eda\u5230\u5546\u54c1\u5e93\u5b58", (Object)activityId, (Object)orderReqDto.getOrderCode());
                List<ActivityJoinLogEo> activityJoinLogEos = this.activityJoinLogExtService.getByOrderCodeAndActivityId(orderReqDto.getOrderCode(), activityId);
                List needReturnLogs = activityJoinLogEos.stream().filter(activityJoinLog -> {
                    List activityIdList = (List)engineParams.getActivitySkusMapping().get(activityJoinLog.getShopId() + "_" + activityJoinLog.getSkuId());
                    return !activityJoinLog.getStatus().equals(ConstantsStatusEnum.CANCEL) && !CollectionUtils.isEmpty((Collection)activityIdList) && ((String)activityIdList.get(0)).equals(activityId.toString());
                }).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(needReturnLogs)) {
                    logger.info("\u6d3b\u52a8={},\u5df2\u7ecf\u7ed3\u675f\uff0c\u8ba2\u5355\u53f7{}\uff0c\u65e0\u4efb\u4f55\u56de\u6eda\u5546\u54c1\u4fe1\u606f", (Object)activityId, (Object)orderReqDto.getOrderCode());
                }
                if (ActivityStockTypeParam.SHARE.equals(this.activityStockTypeParam.getValue())) {
                    if (!CollectionUtils.isEmpty(needReturnLogs)) {
                        List<Long> returnIds = needReturnLogs.stream().map(activityJoinLogEo -> activityJoinLogEo.getId()).collect(Collectors.toList());
                        this.activityJoinLogExtService.cancel(returnIds);
                    }
                    return;
                }
                List rollBackItemStorages = needReturnLogs.stream().map(joinLogEo -> {
                    ItemStorageReqDto itemStorageReqDto = new ItemStorageReqDto();
                    itemStorageReqDto.setBalance(Long.valueOf(joinLogEo.getItemNum().intValue()));
                    itemStorageReqDto.setOrderNo(orderReqDto.getOrderCode());
                    itemStorageReqDto.setShopId(Long.valueOf(joinLogEo.getShopId()));
                    itemStorageReqDto.setSkuId(Long.valueOf(joinLogEo.getSkuId()));
                    return itemStorageReqDto;
                }).collect(Collectors.toList());
                BatchItemStorageReqDto batchItemStorageReqDto = new BatchItemStorageReqDto();
                batchItemStorageReqDto.setOpt(BatchItemStorageReqDto.ADD);
                batchItemStorageReqDto.setItemStorageReqDtoList(rollBackItemStorages);
                RestResponse batchItemStorageRespDtoRestResponse = this.itemStorageApi.batchOperatingItemStorage(batchItemStorageReqDto);
                if (!"0".equals(batchItemStorageRespDtoRestResponse.getResultCode())) {
                    logger.error("\u6d3b\u52a8{}\u8ba2\u5355\u53f7{}\u64cd\u4f5c\u56de\u9000\u5e93\u5b58\u6709\u8bef", (Object)activityId, (Object)orderReqDto.getOrderCode());
                }
                List returnSuccessList = needReturnLogs;
                BatchItemStorageRespDto batchItemStorageRespDto = (BatchItemStorageRespDto)batchItemStorageRespDtoRestResponse.getData();
                if (!batchItemStorageRespDto.getIfAllSuccess().booleanValue()) {
                    logger.error("\u6d3b\u52a8{}\u8ba2\u5355\u53f7{}\u64cd\u4f5c\u56de\u9000\u5e93\u5b58\u6ca1\u6709\u5b8c\u5168\u6210\u529f", (Object)activityId, (Object)orderReqDto.getOrderCode());
                    returnSuccessList = needReturnLogs.stream().filter(joinLogEo -> this.ifExist(batchItemStorageRespDto.getSuccessList(), Long.valueOf(joinLogEo.getShopId()), Long.valueOf(joinLogEo.getSkuId()))).collect(Collectors.toList());
                }
                List<Long> returnIds = returnSuccessList.stream().map(activityJoinLogEo -> activityJoinLogEo.getId()).collect(Collectors.toList());
                this.activityJoinLogExtService.cancel(returnIds);
                continue;
            }
            logger.error("\u6d3b\u52a8={}\uff0c\u8ba2\u5355={}\uff0c\u6d3b\u52a8\u5728\u8fdb\u884c\u4e2d\uff0c\u4e0d\u505a\u5904\u7406", (Object)activityId, (Object)orderReqDto.getOrderCode());
        }
    }

    public boolean ifExist(List<ItemStorageRespDto> successList, Long shopId, Long skuId) {
        if (CollectionUtils.isEmpty(successList)) {
            return false;
        }
        for (ItemStorageRespDto itemStorageRespDto : successList) {
            if (!itemStorageRespDto.getShopId().equals(shopId) || !itemStorageRespDto.getSkuId().equals(skuId)) continue;
            return true;
        }
        return false;
    }

    private Long getMemberId(Long userId) {
        try {
            MemberInfoDetailRespDto memberInfo = (MemberInfoDetailRespDto)this.memberInfoExtQueryApi.queryMemberInfoDetailByUserId(userId).getData();
            return memberInfo.getId();
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new BizException("\u4f1a\u5458\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
    }

    @Override
    public void handleOrderStatusChangeMessage(OrderStatusChangeOrderDetailDto orderReqDto) {
        if ("CANCEL".equals(orderReqDto.getOrderTradeStatus()) || "CLOSE".equals(orderReqDto.getOrderTradeStatus())) {
            EngineParams engineParams = new EngineParams();
            if (Objects.isNull(orderReqDto.getCustomerId())) {
                engineParams.setUserId(this.getMemberId(orderReqDto.getUserId()));
            } else {
                engineParams.setUserId(orderReqDto.getCustomerId());
            }
            engineParams.setOrderCode(orderReqDto.getOrderCode());
            this.dealJoinActivityByType(engineParams, orderReqDto);
            if (Objects.isNull(orderReqDto.getCustomerId())) {
                try {
                    if ("2".equals(orderReqDto.getBizType()) || "3".equals(orderReqDto.getBizType())) {
                        this.engineApi.execute(CheckPointEnum.CANCEL_JOIN_ACTIVITY.toString(), engineParams);
                    }
                }
                catch (Exception e) {
                    logger.error("\u8ba2\u5355\u53f7{}\u53d6\u6d88\u62fc\u56e2\u6d3b\u52a8\u5931\u8d25:{}", (Object)orderReqDto.getOrderCode(), (Object)e);
                    this.handleOrderStatusCancelFail(orderReqDto, engineParams);
                }
                if (!CollectionUtils.isEmpty((Collection)engineParams.getActivityIds())) {
                    engineParams.getActivityIds().forEach(activityId -> this.activityJoinNumService.decrease((Long)activityId, engineParams.getUserId(), 1));
                }
            } else if (orderReqDto.getActivityFlag().booleanValue()) {
                engineParams.setValidType(ConditionValidTypeEnum.NO_THROW_EXCEPTION.getType());
                this.engineApi.execute(CheckPointEnum.CANCEL_JOIN_ACTIVITY.toString(), engineParams);
                this.handleOrderStatusByFinishedActivity(orderReqDto, engineParams);
            }
        }
    }

    @Override
    public void getAndSetInstanceInfo(Long instanceId) {
        if (instanceId == null) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)ContextUtil.getInstanceId()) || ContextUtil.getInstanceId().equals("-1")) {
            RestResponse appInstanceDtoRestResponse = this.applicationQueryApi.queryInsById(instanceId, "{}");
            if (!"0".equals(appInstanceDtoRestResponse.getResultCode())) {
                logger.error("\u67e5\u8be2\u5b9e\u4f8b\u6709\u8bef={}", (Object)instanceId);
                throw new BizException(appInstanceDtoRestResponse.getResultCode(), appInstanceDtoRestResponse.getResultMsg());
            }
            AppInstanceDto appInstanceDto = (AppInstanceDto)appInstanceDtoRestResponse.getData();
            logger.info("\u67e5\u8be2\u5230Instance=" + JSON.toJSONString((Object)appInstanceDto));
            ContextUtil.setAppInstance(appInstanceDto, instanceId);
        } else {
            logger.info("\u67e5\u8be2\u5230\u7684instanceId\u4e3a" + ContextUtil.getInstanceId());
        }
    }

    private void dealJoinActivityByType(EngineParams engineParams, OrderStatusChangeOrderDetailDto orderReqDto) {
        List list;
        List<ActivityJoinLogEo> activityJoinLogEos = this.activityJoinLogExtService.getByOrderCode(orderReqDto.getOrderCode());
        this.getAndSetInstanceInfo(activityJoinLogEos.get(0).getInstanceId());
        if (Objects.isNull(orderReqDto.getCustomerId())) {
            list = orderReqDto.getActivitys().stream().map(orderActivityInfoReqDto -> (long)orderActivityInfoReqDto.getActivityId()).collect(Collectors.toList());
        } else {
            List collect = orderReqDto.getActivitys().stream().filter(activity -> !OrderStatusChangeOrderDetailDto.COUPON_ACTIVITY.equals(activity.getType())).collect(Collectors.toList());
            orderReqDto.setActivitys(collect);
            list = collect.stream().map(OrderStatusChangeOrderDetailDto.OrderActivityInfoReqDto::getActivityId).collect(Collectors.toList());
            List newActivityJoinLogEos = activityJoinLogEos.stream().filter(join -> !join.getStatus().equals(ConstantsStatusEnum.CANCEL.getStatus())).collect(Collectors.toList());
            Map activityJoinMap = newActivityJoinLogEos.stream().sorted(Comparator.comparingLong(StdActivityJoinLogEo::getActivityId)).collect(Collectors.groupingBy(activity -> activity.getShopId() + "_" + activity.getSkuId(), Collectors.mapping(act -> act.getActivityId().toString(), Collectors.toList())));
            engineParams.setActivitySkusMapping(activityJoinMap);
        }
        if (CollectionUtils.isEmpty(list)) {
            logger.error("\u8ba2\u5355\u53f7{}\u53d6\u6d88\u65f6\u6d3b\u52a8\u96c6\u5408\u4e3a\u7a7a", (Object)orderReqDto.getOrderCode());
            return;
        }
        engineParams.setActivityId(((Long)list.get(0)).longValue());
        engineParams.setActivityIds(list);
        boolean activityFlag = false;
        for (OrderStatusChangeOrderDetailDto.OrderActivityInfoReqDto orderActivityInfoReqDto2 : orderReqDto.getActivitys()) {
            List activityItemIds;
            if (Integer.valueOf(OrderStatusChangeOrderDetailDto.COUPON_ACTIVITY).equals(orderActivityInfoReqDto2.getType())) {
                activityItemIds = orderActivityInfoReqDto2.getActivityItemIds();
                if (CollectionUtils.isEmpty((Collection)activityItemIds)) {
                    throw new BizException("\u4f18\u60e0\u5238id\u4e0d\u80fd\u4e3a\u7a7a");
                }
                List couponIds = activityItemIds.stream().map(activityItemId -> Long.valueOf(activityItemId)).collect(Collectors.toList());
                ActivityCoupon activityCoupon = new ActivityCoupon();
                activityCoupon.setCouponIds(couponIds);
                activityCoupon.setActivityId(orderActivityInfoReqDto2.getActivityId());
                engineParams.getActivityCouponList().add(activityCoupon);
            }
            if (Integer.valueOf(1).equals(orderActivityInfoReqDto2.getType()) && !CollectionUtils.isEmpty((Collection)(activityItemIds = orderActivityInfoReqDto2.getActivityItemIds()))) {
                engineParams.getExtendsAttribute().put("activity_group_id", Long.valueOf((String)activityItemIds.get(0)));
            }
            if (activityFlag || !OrderStatusChangeOrderDetailDto.SECKILL_ACTIVITY.equals(orderActivityInfoReqDto2.getType()) && !OrderStatusChangeOrderDetailDto.PROMOTION.equals(orderActivityInfoReqDto2.getType()) && !OrderStatusChangeOrderDetailDto.TIME_DISCOUNT.equals(orderActivityInfoReqDto2.getType())) continue;
            activityFlag = true;
        }
        orderReqDto.setActivityFlag(Boolean.valueOf(activityFlag));
    }

    @Override
    public PromotionPointInfoRespDto points(PromotionPointInfoReqDto dto) {
        List<ActivityEo> activityEos = this.activityExtQueryService.activateAcList(dto.getActivityTemplateId());
        PromotionPointInfoRespDto respDto = new PromotionPointInfoRespDto();
        respDto.setMemberId(dto.getMemberId());
        respDto.setTradeCode(dto.getTradeCode());
        StringBuilder aIds = new StringBuilder();
        HashMap<ActivityEo, EngineParams> matchAc = new HashMap<ActivityEo, EngineParams>(3);
        for (ActivityEo activityEo : activityEos) {
            try {
                EngineParams params = this.createEngineParams(dto.getItems(), activityEo, dto.getMemberId(), dto.getTradeCode());
                this.engineClient.defineCheckpoint(CheckPointEnum.REVIEW_ACTIVITY.toString()).execute(params);
                matchAc.put(activityEo, params);
            }
            catch (Exception e) {
                this.processException(e);
            }
        }
        Collection<ActivityEo> hitActivities = this.activityExtQueryService.mutex(matchAc.keySet());
        for (ActivityEo activity : hitActivities) {
            EngineParams param = (EngineParams)matchAc.get(activity);
            aIds.append(activity.getId()).append(",");
            respDto.setItems(param.getItems());
            Map extendMap = param.getExtendsAttribute();
            respDto.setReturnGift(MapUtils.getMap((Map)extendMap, (Object)"returnGift"));
            respDto.setReturnCoupon(MapUtils.getMap((Map)extendMap, (Object)"returnCoupon"));
        }
        respDto.setActivityId(aIds.substring(0, aIds.lastIndexOf(",")));
        return respDto;
    }

    private EngineParams createEngineParams(List<ItemVo> items, ActivityEo activity, long memberId, String tradeCode) {
        EngineParams params = new EngineParams();
        params.setActivityId(activity.getId().longValue());
        params.setUserId(memberId);
        params.setSerialNumber(tradeCode);
        params.setItems(items);
        return params;
    }

    private void disableActivity(Long activityId, ActivityStatusEnum status) {
        ActivityEo updateEo = new ActivityEo();
        updateEo.setId(activityId);
        updateEo.setActivityStatus(status.getKey());
        this.couponService.finish(activityId);
        this.activityDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void deleteActivityTask(Long activityId) {
        if (activityId == null) {
            return;
        }
        String startName = "\u8425\u9500\u4e2d\u5fc3\uff1a\u6d3b\u52a8\u5f00\u59cb(" + activityId + ")";
        String finishName = "\u8425\u9500\u4e2d\u5fc3\uff1a\u6d3b\u52a8\u7ed3\u675f(" + activityId + ")";
        ArrayList taskNames = Lists.newArrayList((Object[])new String[]{startName, finishName});
        ArrayList delTasks = Lists.newArrayList();
        taskNames.forEach(taskName -> {
            TaskQueryReqDto forQuery = new TaskQueryReqDto();
            forQuery.setTaskName(taskName);
            List taskList = ((PageInfo)this.taskQueryApi.queryByPage(JSON.toJSONString((Object)forQuery), Integer.valueOf(1), Integer.valueOf(10)).getData()).getList();
            if (!CollectionUtils.isEmpty((Collection)taskList)) {
                delTasks.addAll(taskList);
            }
        });
        if (!CollectionUtils.isEmpty((Collection)delTasks)) {
            delTasks.forEach(task -> {
                if (Objects.equals(task.getStatus(), TaskStatusEnum.ENABLE.getCode())) {
                    this.taskApi.disableById(task.getId(), "{}");
                }
                this.taskApi.removeById(task.getId(), "{}");
            });
        }
    }

    private void createActivityTask(ActivityEo activityEo, String bizName, String bizCode, Date date) {
        TaskAndBizCreateReqDto dto = new TaskAndBizCreateReqDto();
        dto.setAppCode(this.appCode);
        dto.setBizCode(bizCode);
        dto.setBizName(bizName);
        dto.setParams("" + activityEo.getId());
        dto.setScheduleExpression(DateUtil.date2Cron(date));
        dto.setShardType("SINGLE");
        dto.setTaskBatchId(null);
        dto.setTaskDesc("");
        dto.setTaskName(bizName + "(" + activityEo.getId() + ")");
        dto.setInstanceId(activityEo.getInstanceId());
        dto.setTenantId(activityEo.getTenantId());
        Long data = (Long)this.taskApi.addWithBiz(dto).getData();
        this.taskApi.enableById(data, "{}");
    }
}

