/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.apiimpl.query;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.biz.commons.constants.OssConstant;
import com.dtyunxi.cube.biz.commons.utils.ExcelUtil;
import com.dtyunxi.cube.biz.commons.utils.Object2FilterUtil;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponBatchRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponNoticeUseRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query.ICouponExtQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponChannelEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponValidityTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.query.IConditionExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.query.ICouponAnonymousQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.query.ICouponExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.utils.SerialCodeGenerateUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ConditionEo;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="couponExtQueryApi")
public abstract class CouponExtQueryApiImpl
implements ICouponExtQueryApi {
    private static Logger logger = LoggerFactory.getLogger(ICouponExtQueryApi.class);
    @Autowired
    private ICouponExtQueryService couponExtQueryService;
    @Autowired
    private IObjectStorageService objectStorageService;
    @Autowired
    private ICouponTemplateExtQueryService couponTemplateExtQueryService;
    @Autowired
    private ICouponAnonymousQueryService couponAnonymousQueryService;
    @Autowired
    private IConditionExtQueryService conditionExtQueryService;
    @Resource
    private ICommonsMqService commonsMqService;

    public RestResponse<PageInfo<CouponExtRespDto>> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        PageInfo<CouponExtRespDto> pageInfo = this.couponExtQueryService.queryByPage(filter, pageNum, pageSize);
        return new RestResponse(pageInfo);
    }

    public RestResponse<PageInfo<CouponExtRespDto>> queryAllInfoByPage(String filter, Integer pageNum, Integer pageSize) {
        logger.info("\u83b7\u53d6\u4f18\u60e0\u5238\u6a21\u677f\u5217\u8868:filter{}, pageNum:{}, pageSize:{}", new Object[]{filter, pageNum, pageSize});
        PageInfo<CouponExtRespDto> pageInfo = this.couponExtQueryService.queryByPage(filter, pageNum, pageSize);
        List list = pageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            logger.info("\u83b7\u53d6\u4f18\u60e0\u5238\u6a21\u677f\u5217\u8868\u8fd4\u56de\u7a7a\u6570\u636e");
            return new RestResponse(pageInfo);
        }
        List<Long> couponTemplateIds = list.stream().map(CouponExtRespDto::getCouponTemplateId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(couponTemplateIds)) {
            logger.error("\u627e\u4e0d\u5230\u4f18\u60e0\u5238\u6a21\u677f\u4fe1\u606f, CouponExtRespDto list: {}", (Object)JSON.toJSONString((Object)list));
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u627e\u4e0d\u5230\u4f18\u60e0\u5238\u6a21\u677f\u4fe1\u606f"}));
        }
        Map<Long, CouponTemplateExtRespDto> couponTemplateMap = this.couponTemplateExtQueryService.listByIds2Map(couponTemplateIds);
        List<Long> activityIds = list.stream().map(CouponExtRespDto::getActivityId).distinct().collect(Collectors.toList());
        Map<Long, List<ConditionEo>> conditionMap = this.conditionExtQueryService.listByActivityIds2Map(activityIds);
        list.forEach(couponExtRespDto -> {
            CouponTemplateExtRespDto couponTemplate = (CouponTemplateExtRespDto)couponTemplateMap.get(couponExtRespDto.getCouponTemplateId());
            couponExtRespDto.setCouponTemplate(couponTemplate);
            List conditionEoList = (List)conditionMap.get(couponExtRespDto.getActivityId());
            this.couponTemplateExtQueryService.packageCondition(couponTemplate, conditionEoList);
        });
        return new RestResponse(pageInfo);
    }

    public RestResponse<CouponExtRespDto> queryById(Long id) {
        CouponExtRespDto couponExtRespDto = this.couponExtQueryService.queryById(id);
        if (couponExtRespDto == null) {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u627e\u4e0d\u5230\u4f18\u60e0\u5238\u4fe1\u606fid:" + id}));
        }
        return new RestResponse((Object)couponExtRespDto);
    }

    public RestResponse<List<CouponExtRespDto>> queryByIds(List<Long> ids) {
        return new RestResponse(this.couponExtQueryService.listByIds(ids));
    }

    public RestResponse<List<CouponExtRespDto>> queryByCodes(List<String> codes) {
        return new RestResponse(this.couponExtQueryService.listByCodes(null, codes));
    }

    public RestResponse<CouponExtRespDto> queryByCode(String code) {
        Long userd = SerialCodeGenerateUtil.gennarateUserIdByCouponCode(code);
        CouponExtRespDto couponExtRespDto = this.couponExtQueryService.queryByCode(userd, code);
        return new RestResponse((Object)couponExtRespDto);
    }

    public RestResponse<String> export(String filter) {
        PageInfo<CouponExtRespDto> pageInfo = this.couponAnonymousQueryService.queryByPage(filter, null, null);
        List list = pageInfo.getList();
        List<Long> couponTemplateIds = list.stream().filter(couponExtRespDto -> couponExtRespDto.getValidityType().equals(CouponValidityTypeEnum.FIXED_DATE.getType())).map(CouponExtRespDto::getCouponTemplateId).distinct().collect(Collectors.toList());
        Map<Long, CouponTemplateExtRespDto> longCouponTemplateExtRespDtoMap = this.couponTemplateExtQueryService.listByIds2Map(couponTemplateIds);
        list.forEach(couponExtRespDto -> {
            CouponTemplateExtRespDto couponTemplateExtRespDto;
            if (couponExtRespDto.getValidityType().equals(CouponValidityTypeEnum.FIXED_DATE.getType()) && (couponTemplateExtRespDto = (CouponTemplateExtRespDto)longCouponTemplateExtRespDtoMap.get(couponExtRespDto.getCouponTemplateId())) != null) {
                couponExtRespDto.setEffectiveTime(couponTemplateExtRespDto.getEffectiveTime());
                couponExtRespDto.setInvalidTime(couponTemplateExtRespDto.getInvalidTime());
            }
        });
        String fileName = "Coupon_number_data_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss") + String.format("%02d", new Random().nextInt(100)) + ".xls";
        InputStream inputStream = ExcelUtil.createExcel((List)list);
        String downloadUrl = null;
        if (null != inputStream) {
            downloadUrl = this.objectStorageService.put(OssConstant.BUCKET_NAME, fileName, inputStream);
        }
        return new RestResponse(downloadUrl);
    }

    public RestResponse<List<String>> exportCoupon(CouponReqDto couponReqDto) {
        return null;
    }

    public RestResponse<List<CouponExtRespDto>> listByOuterOrderCode(Long memberId, String outerOrderCode) {
        return new RestResponse(this.couponExtQueryService.listByOuterOrderCode(memberId, outerOrderCode));
    }

    public RestResponse<Integer> getAvailableCouponNum(Long memberId, String couponStatus) {
        List<Object> couponExtRespDtos = this.couponExtQueryService.listByUserId(memberId, couponStatus);
        List<Long> couponTemplateIds = couponExtRespDtos.stream().filter(couponExtRespDto -> couponExtRespDto.getValidityType().equals(CouponValidityTypeEnum.FIXED_DATE.getType())).map(CouponExtRespDto::getCouponTemplateId).distinct().collect(Collectors.toList());
        Map<Long, CouponTemplateExtRespDto> couponTemplateMap = this.couponTemplateExtQueryService.listByIds2Map(couponTemplateIds);
        couponExtRespDtos = couponExtRespDtos.stream().filter(couponExtRespDto -> {
            CouponTemplateExtRespDto couponTemplateExtRespDto;
            return couponExtRespDto.getValidityType().equals(CouponValidityTypeEnum.FIXED_DATE.getType()) ? null != (couponTemplateExtRespDto = (CouponTemplateExtRespDto)couponTemplateMap.get(couponExtRespDto.getCouponTemplateId())) && couponTemplateExtRespDto.getInvalidTime().after(new Date()) : null != couponExtRespDto.getInvalidTime() && couponExtRespDto.getInvalidTime().after(new Date());
        }).collect(Collectors.toList());
        return new RestResponse((Object)couponExtRespDtos.size());
    }

    public RestResponse<Void> repeatUseMq(String filter) {
        PageInfo<CouponExtRespDto> pageInfo;
        List list;
        logger.info("\u91cd\u53d1\u6838\u9500MQ, filter={}", (Object)filter);
        CouponReqDto couponReqDto = (CouponReqDto)JSON.parseObject((String)filter, CouponReqDto.class);
        String centerFilter = Object2FilterUtil.object2Filter((Object)couponReqDto);
        int pageNum = 1;
        int pageSize = 1000;
        while (!CollectionUtils.isEmpty((Collection)(list = (pageInfo = this.couponExtQueryService.queryByPage(centerFilter, (Integer)pageNum, (Integer)pageSize)).getList()))) {
            list.forEach(couponExtRespDto -> {
                if (CouponChannelEnum.TAOBAO.getChannel().equals(couponExtRespDto.getChannel()) || CouponChannelEnum.PIN_TUAN.getChannel().equals(couponExtRespDto.getChannel()) || CouponTypeEnum.GROUP_PURCHASE.getType().equals(couponExtRespDto.getCouponType())) {
                    List ids = list.stream().map(CouponExtRespDto::getId).collect(Collectors.toList());
                    logger.info("\u624b\u6dd8\u53d1\u5238\u3001\u62fc\u56e2\u53d1\u5238\u3001\u56e2\u8d2d\u5238\u91cd\u65b0\u901a\u77e5\u7b2c\u4e09\u65b9, couponExtRespDto={}", (Object)JSON.toJSONString((Object)couponExtRespDto));
                    CouponNoticeUseRespDto couponTaobaoUseRespDto = new CouponNoticeUseRespDto(couponExtRespDto);
                    this.commonsMqService.sendSingleMessageAsync("BIZ-MARKETING-COUPON-NOTICE-USE", (Object)JSON.toJSONString((Object)couponTaobaoUseRespDto));
                }
            });
            ++pageNum;
        }
        return RestResponse.VOID;
    }

    public RestResponse<Integer> countCouponNum(CouponReqDto reqDto) {
        Preconditions.checkNotNull((Object)reqDto, (Object)"\u7edf\u8ba1\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        return new RestResponse((Object)this.couponExtQueryService.countCouponNum(reqDto));
    }

    public RestResponse<List<CouponRespDto>> queryUseCouponByTime(String startTime, String endTime) {
        return new RestResponse(this.couponExtQueryService.queryUseCouponByTime(startTime, endTime));
    }

    public RestResponse<List<CouponBatchRespDto>> listByTemplateId(Long couponTemplateId) {
        return new RestResponse(this.couponExtQueryService.listByTemplateId(couponTemplateId));
    }

    public RestResponse<List<Long>> queryPersonalizedCouponItemIds(Long couponId, String couponCode) {
        return new RestResponse(this.couponExtQueryService.queryPersonalizedCouponItemIds(couponId, couponCode));
    }

    public RestResponse<PageInfo<CouponExtRespDto>> queryUserCoupons(Long userId, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.couponExtQueryService.queryUserCoupons(userId, pageNum, pageSize));
    }
}

