/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.ProportionUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.coupon.service.ICouponService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class CouponUseAmountLimitCondition
extends ConditionTemplate {
    @Autowired
    private ICouponService couponService;

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine define, ConditionRespDto conditionRespDto, T context, Map<String, ?> configParams) {
        HashMap couponItems = new HashMap(context.getItems().size());
        if (CollectionUtils.isEmpty((Collection)context.getCouponIds())) {
            context.getItems().forEach(itemVo -> {
                LinkedList<String> items = (LinkedList<String>)couponItems.get(itemVo.getCouponId());
                if (CollectionUtils.isEmpty((Collection)items)) {
                    items = new LinkedList<String>();
                    couponItems.put(itemVo.getCouponId(), items);
                }
                items.add(itemVo.getItemId());
            });
            couponItems.keySet().forEach(couponId -> {
                List<ItemVo> matchItem = context.getItems().stream().filter(itemVo -> ((List)couponItems.get(couponId)).stream().anyMatch(itemId -> itemVo.getItemId().equals(itemId))).collect(Collectors.toList());
                context.setTotalDiscountAmount(context.getTotalDiscountAmount().add(this.match((Long)couponId, matchItem, context)));
            });
        } else {
            context.getCouponIds().forEach(couponId -> {
                List matchItem = context.getItems();
                context.setTotalDiscountAmount(context.getTotalDiscountAmount().add(this.match((Long)couponId, matchItem, context)));
            });
        }
        return true;
    }

    private BigDecimal match(Long couponId, List<ItemVo> matchItem, EngineParams context) {
        CouponRespDto coupon = this.couponService.getCouponDetail(couponId);
        if (null == coupon) {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u4f18\u60e0\u5238\u4e0d\u5b58\u5728"}));
        }
        if (System.currentTimeMillis() < coupon.getEffectiveTime().getTime()) {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u4f18\u60e0\u5238\u6682\u65f6\u4e0d\u53ef\u7528"}));
        }
        if (System.currentTimeMillis() > coupon.getInvalidTime().getTime()) {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u4f18\u60e0\u5238\u5df2\u8fc7\u671f"}));
        }
        double sumPrice = matchItem.parallelStream().mapToDouble(vo -> vo.getDiscountPrice().setScale(6, 2).doubleValue() * (double)vo.getNum()).sum();
        if (coupon.getAmount().compareTo(new BigDecimal(sumPrice)) > 0) {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u4f18\u60e0\u5238\uff1a" + coupon.getCouponCode() + "\u4e0d\u6ee1\u8db3\u91d1\u989d\u6761\u4ef6"}));
        }
        BigDecimal temp = null;
        if (coupon.getCouponType().equals(CouponType.CASH.getKey())) {
            temp = ProportionUtil.avgDisCounts(matchItem, coupon.getCouponValue(), context.getScale(), context.getRoundModel());
        } else {
            BigDecimal t = BigDecimal.valueOf(sumPrice);
            temp = ProportionUtil.avgDisCounts(matchItem, t.subtract(coupon.getCouponValue().multiply(t)), context.getScale(), context.getRoundModel());
        }
        return temp;
    }
}

