/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition;

import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageBranchQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BundleItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemStorageQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ShelfQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemStorageQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityItemRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityItemQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.BaseActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.group.GroupActivityItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.group.GroupActivityItemSkuDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.ConditionTemplate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractBaseTemplate
implements ConditionTemplate {
    public ConditionReqDto getConditionReqDto() {
        ConditionReqDto conditionReqDto = new ConditionReqDto();
        conditionReqDto.setConditionTemplateId(Long.valueOf(this.getConditionTemplateId()));
        conditionReqDto.setConditionParams("{}");
        return conditionReqDto;
    }

    @Override
    public <T extends BaseActivityDto> void parseCondition(List<ConditionRespDto> conditionRespDtos, T t) {
        conditionRespDtos.stream().filter(conditionRespDto -> conditionRespDto.getConditionTemplateId().equals(this.getConditionTemplateId())).findFirst().ifPresent(conditionRespDto -> this.parse((ConditionRespDto)conditionRespDto, t));
    }

    protected abstract <T extends BaseActivityDto> void parse(ConditionRespDto var1, T var2);

    protected List<GroupActivityItemDto> getGroupActivityItems(Long id) {
        IActivityItemQueryApi activityItemQueryApi = (IActivityItemQueryApi)SpringBeanUtil.getBean((String)"activityItemQueryApiImpl", IActivityItemQueryApi.class);
        ActivityItemQueryReqDto activityItemQueryReqDto = new ActivityItemQueryReqDto();
        activityItemQueryReqDto.setActivityId(id);
        List items = (List)activityItemQueryApi.queryAll(activityItemQueryReqDto).getData();
        Map<String, List<ActivityItemRespDto>> group = items.stream().collect(Collectors.groupingBy(activityItem -> activityItem.getShopId() + activityItem.getItemId().toString()));
        ArrayList itemIds = Lists.newArrayList();
        HashSet shopIds = Sets.newHashSet();
        ArrayList skuIds = Lists.newArrayList();
        ArrayList shelfReqDtos = Lists.newArrayList();
        items.forEach(activityItem -> {
            itemIds.add(activityItem.getItemId());
            skuIds.add(activityItem.getSkuId());
            shopIds.add(activityItem.getShopId());
            ShelfReqDto shelfReqDto = new ShelfReqDto();
            shelfReqDto.setSkuId(activityItem.getSkuId());
            shelfReqDto.setShopId(activityItem.getShopId());
            shelfReqDtos.add(shelfReqDto);
        });
        Map<Long, ItemRespDto> itemMap = this.queryItemByIds(itemIds);
        Map<Long, ShopBaseDto> shopMap = this.queryShopByIds(shopIds);
        Map<Long, ItemSkuRespDto> skuMap = this.queryItemSku(skuIds);
        Map<String, BigDecimal> priceMap = this.queryItemPrice(shelfReqDtos);
        Map<String, Long> stockMap = this.queryItemStock(shelfReqDtos);
        ArrayList groupActivityItemDtos = Lists.newArrayList();
        for (List<ActivityItemRespDto> itemDtos : group.values()) {
            Long itemId = itemDtos.get(0).getItemId();
            Long shopId = itemDtos.get(0).getShopId();
            if (!itemMap.containsKey(itemId)) continue;
            GroupActivityItemDto groupActivityItemDto = new GroupActivityItemDto();
            ItemRespDto itemRespDto = itemMap.get(itemId);
            groupActivityItemDto.setItemCode(itemRespDto.getCode());
            groupActivityItemDto.setItemName(itemRespDto.getName());
            groupActivityItemDto.setItemId(itemId);
            groupActivityItemDto.setShopId(shopId);
            if (shopMap.containsKey(shopId)) {
                groupActivityItemDto.setShopName(shopMap.get(shopId).getName());
            }
            Long totalStock = 0L;
            ArrayList skus = Lists.newArrayList();
            BigDecimal minPrice = BigDecimal.ZERO;
            for (ActivityItemRespDto skuDto : itemDtos) {
                Long stock;
                ItemSkuRespDto skuRespDto;
                GroupActivityItemSkuDto sku = new GroupActivityItemSkuDto();
                sku.setActivityStock(skuDto.getOriginalStock());
                sku.setGroupPrice(skuDto.getActivityPrice());
                sku.setItemId(skuDto.getItemId());
                sku.setSkuId(skuDto.getSkuId());
                String shopSkuKey = skuDto.getShopId() + skuDto.getSkuId().toString();
                BigDecimal price = priceMap.get(shopSkuKey);
                if (null != price && price.compareTo(minPrice) == -1) {
                    minPrice = price;
                }
                sku.setSellPrice(price);
                Long skuId = sku.getSkuId();
                if (skuMap.containsKey(skuId) && StringUtils.isNotBlank((String)(skuRespDto = skuMap.get(skuId)).getAttr())) {
                    Map skuAttrMap = (Map)ObjectHelper.Json2Bean((String)skuRespDto.getAttr(), Map.class);
                    String skuName = StringUtils.join(skuAttrMap.values(), (String)" ");
                    sku.setSkuName(skuName);
                }
                if (ItemTypeEnum.BUNDLE.getType().equals(itemRespDto.getType())) {
                    stock = this.queryBundleItemStock(itemId, skuId, shopId);
                } else {
                    stock = stockMap.get(shopId + skuId.toString());
                    if (null == stock) {
                        stock = 0L;
                    }
                }
                sku.setStock(stock);
                totalStock = totalStock + stock;
                skus.add(sku);
            }
            groupActivityItemDto.setSkus((List)skus);
            groupActivityItemDto.setTotalStock(totalStock);
            groupActivityItemDto.setSellPrice(minPrice);
            groupActivityItemDto.setId(this.generateId());
            groupActivityItemDtos.add(groupActivityItemDto);
        }
        return groupActivityItemDtos;
    }

    protected Long generateId() {
        return IdGenrator.nextId((long)10L, (long)7L);
    }

    protected Map<Long, ItemRespDto> queryItemByIds(List<Long> itemIds) {
        IItemQueryApi itemQueryApi = (IItemQueryApi)SpringBeanUtil.getBean(IItemQueryApi.class);
        List itemRespDtos = (List)itemQueryApi.queryByItemIds(org.apache.commons.lang3.StringUtils.join(itemIds, (String)",")).getData();
        if (CollectionUtils.isEmpty((Collection)itemRespDtos)) {
            return Collections.EMPTY_MAP;
        }
        return itemRespDtos.stream().collect(Collectors.toMap(ItemRespDto::getId, e -> e, (e1, e2) -> e1));
    }

    protected Map<Long, ShopBaseDto> queryShopByIds(Set<Long> shopIds) {
        IShopQueryApi shopQueryApi = (IShopQueryApi)SpringBeanUtil.getBean(IShopQueryApi.class);
        List shopBaseDtos = (List)shopQueryApi.queryBaseListByIds(shopIds).getData();
        if (CollectionUtils.isEmpty((Collection)shopBaseDtos)) {
            return Collections.EMPTY_MAP;
        }
        return shopBaseDtos.stream().collect(Collectors.toMap(ShopBaseDto::getId, e -> e, (e1, e2) -> e1));
    }

    protected Map<String, Long> queryItemStock(List<ShelfReqDto> shelfReqDtos) {
        IItemStorageQueryApi itemStorageQueryApi = (IItemStorageQueryApi)SpringBeanUtil.getBean(IItemStorageQueryApi.class);
        ItemStorageBranchQueryReqDto queryReqDto = new ItemStorageBranchQueryReqDto();
        queryReqDto.setShelfList(shelfReqDtos);
        List respDtos = (List)itemStorageQueryApi.queryBranchItemStorage(queryReqDto).getData();
        if (CollectionUtils.isEmpty((Collection)respDtos)) {
            return Collections.EMPTY_MAP;
        }
        return respDtos.stream().collect(Collectors.toMap(dto -> dto.getShopId() + dto.getSkuId().toString(), ItemStorageQueryRespDto::getAvaNum, (e1, e2) -> e1));
    }

    protected Map<Long, ItemSkuRespDto> queryItemSku(List<Long> skuIds) {
        IItemQueryApi itemQueryApi = (IItemQueryApi)SpringBeanUtil.getBean(IItemQueryApi.class);
        List skuList = (List)itemQueryApi.queryItemSkus(skuIds).getData();
        if (CollectionUtils.isEmpty((Collection)skuList)) {
            return Collections.EMPTY_MAP;
        }
        return skuList.stream().collect(Collectors.toMap(ItemSkuRespDto::getId, e -> e, (e1, e2) -> e1));
    }

    protected Map<String, BigDecimal> queryItemPrice(List<ShelfReqDto> shelfReqDtos) {
        List skuIds = shelfReqDtos.stream().map(ShelfReqDto::getSkuId).distinct().collect(Collectors.toList());
        List shopIds = shelfReqDtos.stream().map(ShelfReqDto::getShopId).distinct().collect(Collectors.toList());
        IItemQueryApi itemQueryApi = (IItemQueryApi)SpringBeanUtil.getBean(IItemQueryApi.class);
        ShelfQueryReqDto queryReqDto = new ShelfQueryReqDto();
        queryReqDto.setSkuIds(skuIds);
        queryReqDto.setShopIds(shopIds);
        queryReqDto.setBusType(ItemBusTypeEnum.ORDINARY.getType());
        List shelfQueryRespDtos = (List)itemQueryApi.queryShelfList(queryReqDto).getData();
        if (CollectionUtils.isEmpty((Collection)shelfQueryRespDtos)) {
            return Collections.EMPTY_MAP;
        }
        return shelfQueryRespDtos.stream().collect(Collectors.toMap(dto -> dto.getShopId() + dto.getSkuId().toString(), ShelfQueryRespDto::getPrice, (e1, e2) -> e1));
    }

    protected Long queryBundleItemStock(Long itemId, Long skuId, Long shopId) {
        IItemQueryApi itemQueryApi = (IItemQueryApi)SpringBeanUtil.getBean(IItemQueryApi.class);
        List bundleItemRespDtos = (List)itemQueryApi.queryBundleItem(itemId).getData();
        if (CollectionUtils.isEmpty((Collection)bundleItemRespDtos)) {
            return 0L;
        }
        ArrayList shelfReqDtos = Lists.newArrayList();
        bundleItemRespDtos.forEach(bundleItemRespDto -> {
            if (bundleItemRespDto.getSkuId().equals(skuId)) {
                ShelfReqDto shelfReqDto = new ShelfReqDto();
                shelfReqDto.setShopId(shopId);
                shelfReqDto.setSkuId(bundleItemRespDto.getSubSkuId());
                shelfReqDtos.add(shelfReqDto);
            }
        });
        Map<String, Long> stockMap = this.queryItemStock(shelfReqDtos);
        return this.getBundleMinStock(bundleItemRespDtos, stockMap, shopId);
    }

    protected Long queryBundleItemStock(Long itemId, Long shopId) {
        IItemQueryApi itemQueryApi = (IItemQueryApi)SpringBeanUtil.getBean(IItemQueryApi.class);
        List bundleItemRespDtos = (List)itemQueryApi.queryBundleItem(itemId).getData();
        if (CollectionUtils.isEmpty((Collection)bundleItemRespDtos)) {
            return 0L;
        }
        Long total = 0L;
        Map<Long, List<BundleItemRespDto>> group = bundleItemRespDtos.stream().collect(Collectors.groupingBy(BundleItemRespDto::getSkuId));
        for (Map.Entry<Long, List<BundleItemRespDto>> entry : group.entrySet()) {
            ArrayList shelfReqDtos = Lists.newArrayList();
            entry.getValue().forEach(bundleItemRespDto -> {
                ShelfReqDto shelfReqDto = new ShelfReqDto();
                shelfReqDto.setShopId(shopId);
                shelfReqDto.setSkuId(bundleItemRespDto.getSubSkuId());
                shelfReqDtos.add(shelfReqDto);
            });
            Map<String, Long> stockMap = this.queryItemStock(shelfReqDtos);
            Long skuMin = this.getBundleMinStock(entry.getValue(), stockMap, shopId);
            total = total + skuMin;
        }
        return total;
    }

    private Long getBundleMinStock(List<BundleItemRespDto> bundleItemRespDtos, Map<String, Long> stockMap, Long shopId) {
        Long minStock = null;
        for (BundleItemRespDto bundleItemRespDto : bundleItemRespDtos) {
            Long stock = stockMap.get(shopId + bundleItemRespDto.getSubSkuId().toString());
            if (null == stock) continue;
            stock = stock / (long)bundleItemRespDto.getNum().intValue();
            if (null == minStock) {
                minStock = stock;
                continue;
            }
            if (stock >= minStock) continue;
            minStock = stock;
        }
        return minStock == null ? 0L : minStock;
    }
}

