/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.EnableStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.BaseActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.PromotionActivityItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.returngift.GItem;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.returngift.ReturnGiftActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.returngift.ReturnGiftRuleContent;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.ActivityItemTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.IReturnGiftActivity;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.ActivityFactory;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl.AbstractActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl.MarketingModuleHelper;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ReturnGiftActivityImpl
extends AbstractActivityService
implements IReturnGiftActivity {
    @Autowired
    private IContext context;
    @Resource(name="activityQueryApiImpl")
    private IActivityQueryApi activityQueryApi;
    @Autowired
    private MarketingModuleHelper marketingModuleHelper;

    @Override
    public Long add(ReturnGiftActivityDto activityReqDto) {
        this.validate(activityReqDto);
        String prifix = null;
        prifix = ActivityType.FULL_RETURNING_ACTIVITY.equals((Object)activityReqDto.getActivityType()) ? "MF" : "MZ";
        activityReqDto.setActivityCode(this.marketingModuleHelper.generateCode(prifix));
        return this.addActivity(activityReqDto);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validate(ReturnGiftActivityDto activityReqDto) {
        if (activityReqDto.getActivityType() == null) {
            throw new BizException("\u6d3b\u52a8\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        if (CollectionUtils.isEmpty((Collection)activityReqDto.getActivityItems())) {
            throw new BizException("\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (activityReqDto.getPromotionType() == 3) {
            List gItemList = activityReqDto.getPromotionContents().stream().map(ReturnGiftRuleContent::getGiftItems).flatMap(Collection::stream).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(gItemList)) return;
            if (activityReqDto.getSelectType() != 1) throw new BizException("\u8d60\u54c1\u548c\u6d3b\u52a8\u5546\u54c1\u6240\u5c5e\u5e97\u94fa\u5fc5\u987b\u4fdd\u6301\u4e00\u81f4");
            HashSet shopIds = Sets.newHashSet();
            activityReqDto.getPromotionContents().forEach(content -> {
                if (content.getThreshold() == null) {
                    throw new BizException("\u4fc3\u9500\u6761\u4ef6\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                }
                HashSet giftShopIds = Sets.newHashSet();
                for (GItem gItem : content.getGiftItems()) {
                    if (gItem.getNum() == null) {
                        throw new BizException("\u6bcf\u6b21\u8d60\u9001\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    giftShopIds.add(gItem.getShopId());
                }
                if (giftShopIds.size() != 1) {
                    throw new BizException("\u8d60\u54c1\u548c\u6d3b\u52a8\u5546\u54c1\u6240\u5c5e\u5e97\u94fa\u5fc5\u987b\u4fdd\u6301\u4e00\u81f4");
                }
                shopIds.addAll(giftShopIds);
            });
            if (shopIds.size() != 1) {
                throw new BizException("\u8d60\u54c1\u548c\u6d3b\u52a8\u5546\u54c1\u6240\u5c5e\u5e97\u94fa\u5fc5\u987b\u4fdd\u6301\u4e00\u81f4");
            }
            Set itemShopIds = activityReqDto.getActivityItems().stream().map(PromotionActivityItemDto::getShopId).collect(Collectors.toSet());
            if (itemShopIds.size() == 1 && shopIds.containsAll(itemShopIds)) return;
            throw new BizException("\u8d60\u54c1\u548c\u6d3b\u52a8\u5546\u54c1\u6240\u5c5e\u5e97\u94fa\u5fc5\u987b\u4fdd\u6301\u4e00\u81f4");
        }
        activityReqDto.setActivityCode(this.marketingModuleHelper.generateCode("MF"));
    }

    @Override
    public ReturnGiftActivityDto getDetail(Long id) {
        ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityFatDetail(id.longValue()).getData();
        if (activityRespDto == null) {
            return null;
        }
        ReturnGiftActivityDto returnGiftActivityDto = new ReturnGiftActivityDto();
        CubeBeanUtils.copyProperties((Object)returnGiftActivityDto, (Object)activityRespDto, (String[])new String[0]);
        returnGiftActivityDto.setActivityType(ActivityType.getByType((Long)activityRespDto.getActivityTemplateId()));
        List<ConditionTemplate> templateList = ActivityFactory.getActivityTemplate(returnGiftActivityDto.getActivityType());
        templateList.forEach(conditionTemplate -> conditionTemplate.parseCondition(activityRespDto.getConditionDtos(), returnGiftActivityDto));
        return returnGiftActivityDto;
    }

    @Override
    protected <T extends BaseActivityDto> List<ActivityItemReqDto> getActivityItems(T activityReqDto) {
        ReturnGiftActivityDto activityDto = (ReturnGiftActivityDto)activityReqDto;
        ArrayList activityItemReqDtos = Lists.newArrayList();
        if (activityDto.getSelectType() == 1) {
            activityDto.getActivityItems().stream().forEach(itemDto -> {
                ActivityItemReqDto activityItemReqDto = new ActivityItemReqDto();
                activityItemReqDto.setActivityPrice(BigDecimal.ZERO);
                activityItemReqDto.setItemId(itemDto.getItemId());
                activityItemReqDto.setItemName(itemDto.getItemName());
                activityItemReqDto.setItemType(ActivityItemTypeEnum.ITEM.getKey());
                activityItemReqDto.setStatus(EnableStatusEnum.ENABLE);
                activityItemReqDto.setOriginalStock(Long.valueOf(null != itemDto.getTotalStock() ? itemDto.getTotalStock() : 0L));
                activityItemReqDto.setRemainingStock(Long.valueOf(null != itemDto.getTotalStock() ? itemDto.getTotalStock() : 0L));
                activityItemReqDto.setInstanceId(this.context.instanceId());
                activityItemReqDto.setTenantId(this.context.tenantId());
                activityItemReqDto.setShopId(itemDto.getShopId());
                activityItemReqDtos.add(activityItemReqDto);
            });
        }
        return activityItemReqDtos;
    }
}

