/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponDynamicDateDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponValidityTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponAnonymousService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponExtService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateStockService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.utils.SerialCodeGenerateUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.BeanCopyUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.das.CouponAnonymousDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponAnonymousEo;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CouponAnonymousServiceImpl
implements ICouponAnonymousService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CouponAnonymousDas couponAnonymousDas;
    @Autowired
    private ICouponTemplateStockService couponTemplateStockService;
    @Autowired
    @Lazy
    private ICouponExtService couponExtService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void asyncBatchSave(CouponTemplateExtRespDto couponTemplateExtRespDto, String batchNo, Integer quantity) {
        ArrayList<CouponAnonymousEo> couponAnonymousEoList;
        boolean deductionResult;
        int result;
        Long couponTemplateId;
        block10: {
            couponTemplateId = couponTemplateExtRespDto.getId();
            this.logger.info("\u5f02\u6b65\u751f\u6210\u533f\u540d\u4f18\u60e0\u5238, couponTemplateId={}, batchNo={}, quantity={}", new Object[]{couponTemplateId, batchNo, quantity});
            result = 0;
            deductionResult = false;
            couponAnonymousEoList = new ArrayList<CouponAnonymousEo>();
            deductionResult = this.couponTemplateStockService.deductionAvailableStock(couponTemplateId, quantity);
            if (deductionResult) break block10;
            this.logger.warn("\u5f02\u6b65\u751f\u6210\u533f\u540d\u4f18\u60e0\u5238\u5e93\u5b58\u4e0d\u8db3, couponTemplateId={}, batchNo={}, quantity={}", new Object[]{couponTemplateId, batchNo, quantity});
            if (!deductionResult || result != 0) return;
            this.logger.warn("\u5f02\u6b65\u751f\u6210\u533f\u540d\u4f18\u60e0\u5238, \u6279\u91cf\u5165\u5e93\u5931\u8d25, \u56de\u6edaredis\u5e93\u5b58, couponTemplateId={}, batchNo={}, quantity={}", new Object[]{couponTemplateId, batchNo, quantity});
            this.couponTemplateStockService.addAvailableStock(couponTemplateId, quantity);
            return;
        }
        try {
            for (int i = 1; i <= quantity; ++i) {
                CouponAnonymousEo couponAnonymousEo = BeanCopyUtil.copyProperties(CouponAnonymousEo.class, couponTemplateExtRespDto, new String[0]);
                couponAnonymousEo.setId(null);
                couponAnonymousEo.setCouponTemplateCode(couponTemplateExtRespDto.getCouponCode());
                couponAnonymousEo.setBatchNo(batchNo);
                couponAnonymousEo.setCouponStatus(CouponStatusEnum.CREATE.getStatus());
                couponAnonymousEo.setCouponCode(SerialCodeGenerateUtil.generateCouponCode());
                couponAnonymousEo.setCouponTemplateId(couponTemplateId);
                couponAnonymousEo.setUserId(SerialCodeGenerateUtil.gennarateUserIdByCouponCode(couponAnonymousEo.getCouponCode()));
                if (CouponValidityTypeEnum.DYNAMIC_DATE.getType().equals(couponTemplateExtRespDto.getValidityType())) {
                    CouponDynamicDateDto dynamicDate = (CouponDynamicDateDto)JSON.parseObject((String)couponTemplateExtRespDto.getDynamicDate(), CouponDynamicDateDto.class);
                    Integer afterDate = dynamicDate.getAfterDate() - 1;
                    Integer valiDay = dynamicDate.getDay() - 1;
                    Date effectiveTime = com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.DateUtil.getStartTimeOfDay(new Date());
                    if (afterDate > 0) {
                        effectiveTime = DateUtil.addDays((Date)effectiveTime, (int)afterDate);
                    }
                    Date invalidTime = com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.DateUtil.getEndTimeOfDay(effectiveTime);
                    if (valiDay > 0) {
                        invalidTime = com.dtyunxi.util.DateUtil.addDay((Date)invalidTime, (int)valiDay);
                    }
                    this.logger.info("effectiveTime:{}", (Object)effectiveTime);
                    couponAnonymousEo.setEffectiveTime(effectiveTime);
                    this.logger.info("invalidTime:{}", (Object)invalidTime);
                    couponAnonymousEo.setInvalidTime(invalidTime);
                } else {
                    couponAnonymousEo.setEffectiveTime(null);
                    couponAnonymousEo.setInvalidTime(null);
                }
                couponAnonymousEoList.add(couponAnonymousEo);
            }
            result = this.couponAnonymousDas.insertBatch(couponAnonymousEoList);
            this.couponExtService.asyncBatchSave(couponAnonymousEoList);
            if (!deductionResult || result != 0) return;
        }
        catch (Exception e) {
            try {
                result = 0;
                this.logger.error("\u5f02\u6b65\u751f\u6210\u533f\u540d\u4f18\u60e0\u5238error, message={}", (Object)e.getMessage(), (Object)e);
                if (!deductionResult || result != 0) return;
            }
            catch (Throwable throwable) {
                if (!deductionResult || result != 0) throw throwable;
                this.logger.warn("\u5f02\u6b65\u751f\u6210\u533f\u540d\u4f18\u60e0\u5238, \u6279\u91cf\u5165\u5e93\u5931\u8d25, \u56de\u6edaredis\u5e93\u5b58, couponTemplateId={}, batchNo={}, quantity={}", new Object[]{couponTemplateId, batchNo, quantity});
                this.couponTemplateStockService.addAvailableStock(couponTemplateId, quantity);
                throw throwable;
            }
            this.logger.warn("\u5f02\u6b65\u751f\u6210\u533f\u540d\u4f18\u60e0\u5238, \u6279\u91cf\u5165\u5e93\u5931\u8d25, \u56de\u6edaredis\u5e93\u5b58, couponTemplateId={}, batchNo={}, quantity={}", new Object[]{couponTemplateId, batchNo, quantity});
            this.couponTemplateStockService.addAvailableStock(couponTemplateId, quantity);
            return;
        }
        this.logger.warn("\u5f02\u6b65\u751f\u6210\u533f\u540d\u4f18\u60e0\u5238, \u6279\u91cf\u5165\u5e93\u5931\u8d25, \u56de\u6edaredis\u5e93\u5b58, couponTemplateId={}, batchNo={}, quantity={}", new Object[]{couponTemplateId, batchNo, quantity});
        this.couponTemplateStockService.addAvailableStock(couponTemplateId, quantity);
        return;
    }

    @Override
    public void invalid(Long id) {
        CouponAnonymousEo update = new CouponAnonymousEo();
        update.setId(id);
        update.setCouponStatus(CouponStatusEnum.INVALID.getStatus());
        this.couponAnonymousDas.updateSelective((BaseEo)update);
    }
}

