/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.exchange.condition;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ExchangeActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.response.ExchangeBalanceAccountRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.model.ExcItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.model.ExcRuleContentDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.model.ExchangeRule;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.DiscountAmount;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.Param;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.exchange.account.service.IExchangeBalanceAccountService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.fullreduction.enums.DiscountRule;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.fullreduction.enums.UnitEnum;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ExchangeCondition
extends ConditionTemplate {
    private static Logger logger = LoggerFactory.getLogger(ExchangeCondition.class);
    private static final String PARAMS_NAME = "ExchangeCondition.rule";
    @Autowired
    private IExchangeBalanceAccountService exchangeBalanceAccountService;
    @Autowired
    private IActivityService activityService;

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine define, ConditionRespDto conditionRespDto, T params, Map<String, ?> activityParams) {
        logger.info("\u6362\u8d2d\u6d3b\u52a8execute:{}", (Object)JSON.toJSONString(params));
        Param param = define.getParam(PARAMS_NAME);
        if (null == param) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u6362\u8d2d\u6d3b\u52a8\u6761\u4ef6\u672a\u914d\u7f6e"}));
        }
        ExchangeRule exchangeRule = (ExchangeRule)ConditionTemplate.converter(activityParams.get(PARAMS_NAME), param, define.getLoadClass());
        if (exchangeRule.getPromotionCondition().equals(DiscountRule.STAIR.getType())) {
            exchangeRule.getExcRuleContents().sort(Comparator.comparing(ExcRuleContentDto::getThreshold, (a, b) -> b.compareTo((BigDecimal)a)));
        } else if (exchangeRule.getPromotionCondition().equals(DiscountRule.EACH_FULL.getType())) {
            // empty if block
        }
        this.calculate(params.getItems(), exchangeRule, params, conditionRespDto.getActivityId());
        return true;
    }

    public <T extends EngineParams> boolean calculate(List<ItemVo> items, ExchangeRule exchangeRule, T params, Long activityId) {
        ActivityRespDto activityRespDto = this.activityService.queryById(params.getActivityId());
        boolean inited = false;
        Integer ifBlanceAccount = 0;
        BigDecimal accountAvailableBalance = BigDecimal.ZERO;
        if (params.isUseExchangeAccount() && activityRespDto != null && Integer.valueOf(1).equals(activityRespDto.getIfBalanceAccount())) {
            ifBlanceAccount = activityRespDto.getIfBalanceAccount();
            ExchangeBalanceAccountRespDto accountRespDto = this.exchangeBalanceAccountService.queryByActivityIdAndCustomerId(params.getActivityId(), params.getUserId());
            if (accountRespDto != null) {
                inited = true;
                accountAvailableBalance = accountRespDto.getAvailableBalance();
            }
        }
        boolean meet = false;
        ExchangeActivityRespDto exchangeActivityRespDto = new ExchangeActivityRespDto();
        exchangeActivityRespDto.setActivityId(activityId);
        BigDecimal totalAmount = this.sum(items, UnitEnum.MONEY);
        BigDecimal totalItemNum = this.sum(items, UnitEnum.PIECE);
        BigDecimal nextDiscount = null;
        BigDecimal nextThreshold = null;
        Integer nextDiscountUnit = null;
        Integer nextDiscountScale = null;
        ExcRuleContentDto meetRuleContent = null;
        for (int i = 0; i < exchangeRule.getExcRuleContents().size(); ++i) {
            ExcRuleContentDto excRuleContent = (ExcRuleContentDto)exchangeRule.getExcRuleContents().get(i);
            logger.info("\u6362\u8d2d\u6d3b\u52a8\u89c4\u5219\uff1a{}", (Object)JSON.toJSONString((Object)excRuleContent));
            if (CollectionUtils.isNotEmpty((Collection)excRuleContent.getExchangeItems())) {
                meetRuleContent = excRuleContent;
            }
            BigDecimal targetValue = excRuleContent.getUnit().equals(UnitEnum.MONEY.getType()) ? totalAmount : totalItemNum;
            BigDecimal discountTargetValue = DiscountRule.EACH_FULL.getType().equals(exchangeRule.getPromotionCondition()) ? (UnitEnum.PIECE.getType().equals(excRuleContent.getUnit()) ? (Integer.valueOf(1).equals(excRuleContent.getDiscountScale()) ? totalItemNum.divide(excRuleContent.getThreshold(), 0, 1) : totalAmount) : (Integer.valueOf(1).equals(excRuleContent.getDiscountScale()) ? totalAmount.divide(excRuleContent.getThreshold(), 0, 1) : totalAmount)) : (UnitEnum.MONEY.getType().equals(excRuleContent.getDiscountUnit()) ? totalAmount : totalItemNum);
            exchangeActivityRespDto.setUnit(excRuleContent.getUnit());
            exchangeActivityRespDto.setTargetValue(targetValue);
            if (targetValue.compareTo(excRuleContent.getThreshold()) > -1) {
                BigDecimal threshold = excRuleContent.getThreshold();
                BigDecimal discount = this.calculateDiscount(exchangeRule.getPromotionCondition(), excRuleContent, discountTargetValue, 2);
                if (DiscountRule.EACH_FULL.getType().equals(exchangeRule.getPromotionCondition())) {
                    nextDiscountUnit = excRuleContent.getDiscountUnit();
                    nextDiscount = this.calculateDiscount(exchangeRule.getPromotionCondition(), excRuleContent, discountTargetValue, 1);
                    logger.info("\u6ee1\u8db3\u8ba1\u7b97\u4e0b\u4e00\u9636\u68af\u8d60\u9001\u989d\u5ea6\uff1a{}", (Object)JSON.toJSONString((Object)nextDiscount));
                    nextThreshold = targetValue.divide(excRuleContent.getThreshold(), 0, 1).add(BigDecimal.ONE).multiply(excRuleContent.getThreshold());
                    threshold = targetValue.divide(excRuleContent.getThreshold(), 0, 1).multiply(excRuleContent.getThreshold());
                    nextDiscountScale = excRuleContent.getDiscountScale();
                }
                exchangeActivityRespDto.setDiscountUnit(excRuleContent.getDiscountUnit());
                exchangeActivityRespDto.setDiscount(discount);
                exchangeActivityRespDto.setThreshold(threshold);
                meetRuleContent = excRuleContent;
                meet = true;
                break;
            }
            nextDiscountUnit = excRuleContent.getDiscountUnit();
            nextDiscount = this.calculateDiscount(exchangeRule.getPromotionCondition(), excRuleContent, discountTargetValue, 1);
            logger.info("\u4e0d\u6ee1\u8db3\u8ba1\u7b97\u4e0b\u4e00\u9636\u68af\u8d60\u9001\u989d\u5ea6\uff1a{}", (Object)JSON.toJSONString((Object)nextDiscount));
            nextThreshold = excRuleContent.getThreshold();
            nextDiscountScale = excRuleContent.getDiscountScale();
        }
        if (BigDecimal.ZERO.compareTo(accountAvailableBalance) < 0) {
            meet = true;
        }
        exchangeActivityRespDto.setPromotionCondition(exchangeRule.getPromotionCondition());
        exchangeActivityRespDto.setThresholdType(exchangeRule.getThresholdType());
        exchangeActivityRespDto.setNextDiscountUnit(nextDiscountUnit);
        exchangeActivityRespDto.setNextDiscount(nextDiscount);
        exchangeActivityRespDto.setNextThreshold(nextThreshold);
        exchangeActivityRespDto.setNexDiscountScale(nextDiscountScale);
        exchangeActivityRespDto.setAccountAvailableBalance(accountAvailableBalance);
        exchangeActivityRespDto.setInited(inited);
        exchangeActivityRespDto.setIfBalanceAccount(ifBlanceAccount);
        Map<String, BigDecimal> discountAmountMap = this.setExchangePrice(meetRuleContent, params, exchangeRule.getThresholdType(), meet);
        logger.info("\u8bbe\u7f6e\u6362\u8d2d\u5546\u54c1\u4ef7\u683c\u7ed3\u675f\uff1a{}", (Object)JSON.toJSONString(params));
        Integer isClearExchangeItem = this.clearExchangeItem(exchangeActivityRespDto, params, meet);
        exchangeActivityRespDto.setClearExchangeItem(isClearExchangeItem);
        if (Integer.valueOf(0).equals(isClearExchangeItem)) {
            this.setDiscountTotalAmount(params, discountAmountMap);
        }
        params.getExchangeActivityRespDtos().add(exchangeActivityRespDto);
        return meet;
    }

    private <T extends EngineParams> void setDiscountTotalAmount(T params, Map<String, BigDecimal> discountAmountMap) {
        BigDecimal discountAmountNum = BigDecimal.ZERO;
        for (ItemVo item : params.getItems()) {
            String key;
            if (!Integer.valueOf(1).equals(item.getExchange()) || !Objects.equals(params.getActivityId(), item.getExchangeActivityId()) || !discountAmountMap.containsKey(key = params.getActivityId() + "#" + item.getItemId())) continue;
            BigDecimal skuDiscountAmount = discountAmountMap.get(key);
            DiscountAmount discountAmount = new DiscountAmount();
            discountAmount.setActivityId(Long.valueOf(params.getActivityId()));
            discountAmount.setAmount(skuDiscountAmount);
            item.getActivityDiscountAmount().add(discountAmount);
            params.setTotalDiscountAmount(params.getTotalDiscountAmount().add(skuDiscountAmount));
            discountAmountNum = discountAmountNum.add(skuDiscountAmount);
        }
        params.getActivityDiscountMap().put(String.valueOf(params.getActivityId()), discountAmountNum);
    }

    private BigDecimal calculateDiscount(Integer promotionCondition, ExcRuleContentDto excRuleContent, BigDecimal discountTargetValue, Integer nextDiscount) {
        logger.info("\u8ba1\u7b97\u8d60\u9001\u989d\u5ea6\uff1a{},\u89c4\u5219\uff1a{}\uff0c\u76ee\u6807\u91d1\u989d\uff1a{}\uff0c\u662f\u5426\u662f\u8ba1\u7b97\u4e0b\u4e00\u9636\u68af\u91d1\u989d\uff1a{}", new Object[]{JSON.toJSONString((Object)promotionCondition), JSON.toJSONString((Object)excRuleContent), JSON.toJSONString((Object)discountTargetValue), JSON.toJSONString((Object)nextDiscount)});
        BigDecimal discount = BigDecimal.ZERO;
        if (DiscountRule.STAIR.getType().equals(promotionCondition)) {
            discount = Integer.valueOf(1).equals(excRuleContent.getDiscountScale()) ? excRuleContent.getDiscount() : discountTargetValue.multiply(excRuleContent.getDiscount()).divide(BigDecimal.valueOf(100L), 2, 4);
        } else if (Integer.valueOf(1).equals(excRuleContent.getDiscountScale())) {
            discount = excRuleContent.getDiscount();
            if (Integer.valueOf(2).equals(nextDiscount)) {
                discount = discountTargetValue.multiply(excRuleContent.getDiscount());
            }
        } else {
            discount = discountTargetValue.multiply(excRuleContent.getDiscount()).divide(BigDecimal.valueOf(100L), 2, 4);
        }
        return discount;
    }

    private <T extends EngineParams> Integer clearExchangeItem(ExchangeActivityRespDto exchangeActivityRespDto, T params, boolean meet) {
        logger.info("clearExchangeItem\u5165\u53c2\uff0cexchangeActivityRespDto\u5bf9\u8c61\uff1a{},\u6362\u8d2d\u5546\u54c1\u4fe1\u606f\uff1a{}, \u662f\u5426\u5339\u914d\uff1a{}", new Object[]{JSON.toJSONString((Object)exchangeActivityRespDto), JSON.toJSONString((Object)params.getItems()), meet});
        Integer isClear = 1;
        if (meet) {
            BigDecimal exchangeItemTarget = BigDecimal.ZERO;
            exchangeItemTarget = Integer.valueOf(1).equals(exchangeActivityRespDto.getNextDiscountUnit()) ? params.getItems().stream().filter(itemVo -> Integer.valueOf(1).equals(itemVo.getExchange()) && Objects.equals(params.getActivityId(), itemVo.getExchangeActivityId())).map(e -> Optional.ofNullable(e.getExchangePrice()).orElse(BigDecimal.ZERO).multiply(BigDecimal.valueOf(e.getNum()))).reduce(BigDecimal.ZERO, BigDecimal::add) : params.getItems().stream().filter(itemVo -> Integer.valueOf(1).equals(itemVo.getExchange()) && Objects.equals(params.getActivityId(), itemVo.getExchangeActivityId())).map(ItemVo::getNum).filter(Objects::nonNull).map(BigDecimal::valueOf).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            logger.info("\u5df2\u6362\u8d2d\u5546\u54c1\u989d\u5ea6\uff1a{}", (Object)exchangeItemTarget);
            BigDecimal totalAvailableBalance = exchangeActivityRespDto.getAccountAvailableBalance().add(Optional.ofNullable(exchangeActivityRespDto.getDiscount()).orElse(BigDecimal.ZERO));
            if (exchangeItemTarget.compareTo(totalAvailableBalance) <= 0) {
                isClear = 0;
            }
        }
        logger.info("\u662f\u5426\u6e05\u9664\u6362\u8d2d\u5546\u54c1\uff1a{}", (Object)isClear);
        if (Integer.valueOf(1).equals(isClear)) {
            for (ItemVo e2 : params.getItems()) {
                if (!Integer.valueOf(1).equals(e2.getExchange()) || !Objects.equals(params.getActivityId(), e2.getExchangeActivityId())) continue;
                e2.setPrice(BigDecimal.ZERO);
                e2.setExchangePrice(BigDecimal.ZERO);
                e2.setDiscountPrice(BigDecimal.ZERO);
                e2.setClearExchangeItem(Integer.valueOf(1));
            }
        }
        logger.info("\u6e05\u9664\u6362\u8d2d\u5546\u54c1\u540e\u6362\u8d2d\u4ef7\u683c\uff1a{}", (Object)JSON.toJSONString((Object)params.getItems()));
        return isClear;
    }

    private <T extends EngineParams> Map<String, BigDecimal> setExchangePrice(ExcRuleContentDto excRuleContent, T params, Integer thresholdType, boolean meet) {
        logger.info("\u8bbe\u7f6e\u6362\u8d2d\u5546\u54c1\u4ef7\u683c,\u662f\u5426\u6e05\u9664\u5546\u54c1,\u89c4\u5219\u53c2\u6570\uff1a{},\u5546\u54c1\u53c2\u6570\uff1a{}, \u6362\u8d2d\u65b9\u5f0f\uff1a{}, \u662f\u5426\u6ee1\u8db3\uff1a{}", new Object[]{JSON.toJSONString((Object)excRuleContent), JSON.toJSONString((Object)params.getItems()), thresholdType, meet});
        if (excRuleContent == null) {
            return Maps.newHashMap();
        }
        HashMap discountAmountMap = Maps.newHashMap();
        Map<String, ExcItemDto> exchangeItemMap = excRuleContent.getExchangeItems().stream().collect(Collectors.toMap(e -> e.getSkuId().toString(), e -> e, (e1, e2) -> e1));
        for (ItemVo e3 : params.getItems()) {
            if (Integer.valueOf(1).equals(e3.getExchange()) && Objects.equals(params.getActivityId(), e3.getExchangeActivityId())) {
                BigDecimal oldPrice = e3.getPrice();
                BigDecimal exchangePrice = e3.getPrice();
                BigDecimal origExchangePrice = e3.getPrice();
                if (exchangeItemMap.containsKey(e3.getSkuId())) {
                    origExchangePrice = exchangePrice = exchangeItemMap.get(e3.getSkuId()).getExchangePrice();
                    if (Integer.valueOf(0).equals(thresholdType)) {
                        exchangePrice = BigDecimal.ZERO;
                    }
                }
                e3.setPrice(exchangePrice);
                e3.setDiscountPrice(exchangePrice);
                e3.setExchangePrice(origExchangePrice);
                BigDecimal skuDiscountAmount = BigDecimal.valueOf(e3.getNum()).multiply(oldPrice.subtract(exchangePrice));
                discountAmountMap.put(params.getActivityId() + "#" + e3.getItemId(), skuDiscountAmount);
            }
            logger.info("\u8bbe\u7f6e\u6362\u8d2d\u5546\u54c1\u4ef7\u683c\uff1a{}", (Object)JSON.toJSONString((Object)e3));
        }
        return discountAmountMap;
    }

    private BigDecimal sum(List<ItemVo> itemVos, UnitEnum unitEnum) {
        BigDecimal sum = BigDecimal.ZERO;
        if (UnitEnum.MONEY.equals((Object)unitEnum)) {
            sum = itemVos.stream().filter(itemVo -> itemVo.getExchange() != 1).map(itemVo -> itemVo.getPrice().multiply(BigDecimal.valueOf(itemVo.getNum()))).reduce(BigDecimal.ZERO, BigDecimal::add);
        } else if (UnitEnum.PIECE.equals((Object)unitEnum)) {
            sum = BigDecimal.valueOf(itemVos.stream().filter(itemVo -> itemVo.getExchange() != 1).mapToInt(ItemVo::getNum).sum());
        }
        return sum;
    }
}

