/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanCopyUtil {
    private static final Logger logger = LoggerFactory.getLogger(BeanCopyUtil.class);

    public static <T> T copyProperties(Class<T> target, Object source, String ... ignoreProperties) {
        if (null == source) {
            return null;
        }
        if (BaseEo.class.isAssignableFrom(target) && source instanceof BaseVo) {
            try {
                Method m = target.getMethod("newInstance", new Class[0]);
                Object targetObj = m.invoke(null, new Object[0]);
                DtoHelper.dto2Eo((BaseVo)((BaseVo)source), (BaseEo)((BaseEo)targetObj));
                return (T)targetObj;
            }
            catch (IllegalAccessException e) {
                logger.error("\u7c7b:{}.newInstance()\u65b9\u6cd5\u4e0d\u53ef\u8bbf\u95ee\uff0c\u521d\u59cb\u5316\u5931\u8d25.", (Object)target.getName());
            }
            catch (InvocationTargetException e) {
                logger.error("\u7c7b:{}\uff0c\u521d\u59cb\u5316\u5931\u8d25.", (Object)target.getName(), (Object)e);
            }
            catch (NoSuchMethodException e) {
                logger.error("\u7c7b:{}.newInstance()\u4e0d\u5b58\u5728\uff0c\u521d\u59cb\u5316\u5931\u8d25.", (Object)target.getName(), (Object)e);
            }
        } else if (BaseVo.class.isAssignableFrom(target) && source instanceof BaseEo) {
            try {
                T t = target.newInstance();
                DtoHelper.eo2Dto((BaseEo)((BaseEo)source), (BaseVo)((BaseVo)t));
                return t;
            }
            catch (InstantiationException e) {
                logger.error("\u7c7b:{}\uff0c\u65e0\u6cd5\u521d\u59cb\u5316\u3002\u8bf7\u786e\u4fdd\u5b58\u5728\u65e0\u53c2\u6784\u9020\u51fd\u6570", (Object)target.getName());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else {
            try {
                T t = target.newInstance();
                CubeBeanUtils.copyProperties(t, (Object)source, (String[])ignoreProperties);
                return t;
            }
            catch (InstantiationException e) {
                logger.error("\u5bf9\u5e94\u7c7b:{}\uff0c\u65e0\u6cd5\u8fdb\u884c\u53cd\u5c04\u521d\u59cb\u5316\u3002\u8bf7\u786e\u4fdd\u5b58\u5728\u65e0\u53c2\u6784\u9020\u51fd\u6570");
            }
            catch (IllegalAccessException e) {
                logger.error("\u5bf9\u5e94\u7c7b:{}\uff0c\u65e0\u6cd5\u8fdb\u884c\u53cd\u5c04\u521d\u59cb\u5316\u3002\u8bf7\u786e\u4fdd\u65e0\u53c2\u6784\u9020\u51fd\u6570\u53ef\u8bbf\u95ee");
            }
        }
        throw new BizException(ProExceptionCode.SYSTEM_ERR.getCode(), ProExceptionCode.SYSTEM_ERR.getMessage());
    }

    public static <T> List<T> copyCollections(Collection<?> source, Class<T> target, String ... ignoreProperties) {
        LinkedList result = Lists.newLinkedList();
        if (CollectionUtils.isEmpty(source)) {
            return result;
        }
        source.forEach(t -> result.add(BeanCopyUtil.copyProperties(target, t, ignoreProperties)));
        return result;
    }
}

