/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponCategoryEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query.ICouponExtQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ActivityCoupon;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.utils.CalcUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class CouponDiscountCondition
extends ConditionTemplate {
    @Autowired
    private ICouponExtQueryApi iCouponExtQueryApi;

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine define, ConditionRespDto conditionRespDto, T params, Map<String, ?> activityParams) {
        ActivityCoupon activityCoupon = params.getCouponByActivityId(Long.valueOf(params.getActivityId()));
        if (activityCoupon != null) {
            List couponIds = activityCoupon.getCouponIds();
            RestResponse restResponse = this.iCouponExtQueryApi.queryByIds(couponIds);
            List itemVos = activityCoupon.getItems();
            if (CollectionUtils.isEmpty((Collection)itemVos)) {
                itemVos = params.getItems();
            }
            List list = (List)restResponse.getData();
            BigDecimal tempDiscountAmount = params.getTotalDiscountAmount();
            for (CouponExtRespDto couponExtRespDto : list) {
                BigDecimal cutAmount;
                if (CouponCategoryEnum.QUOTA_CASH.getCategory().equals(couponExtRespDto.getCouponTemplate().getCouponCategory())) {
                    cutAmount = CalcUtil.calculateDiscount(params.getActivityId(), itemVos, couponExtRespDto.getCouponTemplate().getCouponValue(), null, String.valueOf(couponExtRespDto.getCouponTemplate().getCouponRange()));
                    params.setTotalDiscountAmount(cutAmount.add(params.getTotalDiscountAmount()));
                }
                if (!CouponCategoryEnum.DISCOUNT.getCategory().equals(couponExtRespDto.getCouponTemplate().getCouponCategory())) continue;
                cutAmount = CalcUtil.calculateDiscount(params.getActivityId(), itemVos, null, couponExtRespDto.getCouponTemplate().getCouponValue(), String.valueOf(couponExtRespDto.getCouponTemplate().getCouponRange()));
                params.setTotalDiscountAmount(cutAmount.add(params.getTotalDiscountAmount()));
            }
            BigDecimal totalDiscountAmount = params.getTotalDiscountAmount();
            BigDecimal activityDiscount = totalDiscountAmount.subtract(tempDiscountAmount);
            params.getActivityDiscountMap().put(String.valueOf(params.getActivityId()), activityDiscount);
        }
        return true;
    }
}

