/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponErrorEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateDirectionalTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateErrorEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponValidityTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ActivityCoupon;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.query.ICouponExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CouponValidationCondition
extends ConditionTemplate {
    private static final Logger logger = LoggerFactory.getLogger(CouponValidationCondition.class);
    @Autowired
    private ICouponTemplateExtQueryService couponTemplateExtQueryService;
    @Autowired
    private ICouponExtQueryService couponExtQueryService;

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine define, ConditionRespDto conditionRespDto, T context, Map<String, ?> activityParams) {
        Long useMemberId = context.getUserId();
        List<CouponExtRespDto> couponExtRespDtos = this.couponExtQueryService.listByIds(context.getCouponIds());
        if (CollectionUtils.isEmpty(couponExtRespDtos)) {
            ActivityCoupon activityCoupon = context.getCouponByActivityId(Long.valueOf(context.getActivityId()));
            if (activityCoupon == null) {
                throw new ProBizException(CouponErrorEnum.COUPON_NOT_EXIST.getMsg());
            }
            List couponIds = activityCoupon.getCouponIds();
            List<CouponExtRespDto> couponExtByActivityIdResp = this.couponExtQueryService.listByIds(couponIds);
            if (CollectionUtils.isEmpty(couponExtByActivityIdResp)) {
                throw new ProBizException(CouponErrorEnum.COUPON_NOT_EXIST.getMsg());
            }
        }
        couponExtRespDtos.forEach(couponExtRespDto -> {
            CouponTemplateExtRespDto couponTemplateExtRespDto = this.couponTemplateExtQueryService.queryById(couponExtRespDto.getCouponTemplateId());
            if (null == couponTemplateExtRespDto) {
                throw new ProBizException(CouponTemplateErrorEnum.COUPON_TEMPLATE_EXIST.getMsg());
            }
            if (couponTemplateExtRespDto.getCouponTemplateStatus().equals(CouponTemplateStatusEnum.INVALID.getStatus())) {
                throw new ProBizException(CouponErrorEnum.COUPON_INVALID.getMsg());
            }
            if (!couponTemplateExtRespDto.getId().equals(couponExtRespDto.getCouponTemplateId())) {
                logger.error("\u4f18\u60e0\u5238: {} \u4e0e\u6a21\u677f\u4e0d\u5339\u914d\uff0c\u6a21\u677f\u7f16\u53f7\u4e3a\uff1a{}", (Object)couponExtRespDto.getCouponCode(), (Object)couponTemplateExtRespDto.getCouponCode());
                throw new ProBizException(CouponErrorEnum.COUPON_PARAMES_ERROR.getMsg());
            }
            if (null != useMemberId && CouponTemplateDirectionalTypeEnum.IS_DIRECTIONAL.getType().equals(couponTemplateExtRespDto.getIsDirectional()) && !couponExtRespDto.getUserId().equals(useMemberId)) {
                logger.error("\u6838\u9500\u5238\u5931\u8d25\uff0c\u5f53\u524d\u5238\u4e3a\u5b9a\u5411\u5238\uff0c\u6240\u5c5e\u7528\u6237memberId\uff1a{}\uff0c\u5f53\u524d\u4f7f\u7528\u7528\u6237memberId:{}", (Object)couponExtRespDto.getUserId(), (Object)useMemberId);
                throw new ProBizException(CouponErrorEnum.COUPON_IS_DIRECT.getMsg());
            }
            Date effectiveTime = couponExtRespDto.getEffectiveTime();
            Date invalidTime = couponExtRespDto.getInvalidTime();
            if (CouponValidityTypeEnum.FIXED_DATE.getType().equals(couponTemplateExtRespDto.getValidityType())) {
                effectiveTime = couponTemplateExtRespDto.getEffectiveTime();
                invalidTime = couponTemplateExtRespDto.getInvalidTime();
            }
            if (null == effectiveTime || effectiveTime.after(new Date())) {
                throw new ProBizException(CouponErrorEnum.COUPON_NOT_EFFECTIVE.getMsg());
            }
            if (null == invalidTime || invalidTime.before(new Date())) {
                throw new ProBizException(CouponErrorEnum.COUPON_INVALID.getMsg());
            }
            if (!couponExtRespDto.getCouponStatus().equals(CouponStatusEnum.CREATE.getStatus())) {
                logger.error("\u4f18\u60e0\u5238\u6838\u9500\u5931\u8d25\uff0c\u4f18\u60e0\u5238\u7f16\u53f7\uff1a{}\u7684\u72b6\u6001\u4e0d\u6b63\u786e\uff1a{}", (Object)couponExtRespDto.getCouponCode(), (Object)couponExtRespDto.getCouponStatus());
                throw new ProBizException(CouponErrorEnum.COUPON_STATUS_ERROR.getMsg());
            }
        });
        return true;
    }
}

