/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.RuleQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.RuleReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.RuleRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.EnableStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IRuleService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.BatchOperationUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.BeanCopyUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.RuleConditionTemplateMappingDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.RuleDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.RuleConditionTemplateMappingEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.RuleEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RuleServiceImpl
implements IRuleService {
    @Autowired
    private RuleDas ruleDas;
    @Autowired
    private RuleConditionTemplateMappingDas ruleConditionTemplateMappingDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addRule(RuleReqDto dto) {
        if (CollectionUtils.isEmpty((Collection)dto.getConditionTemplateIds())) {
            throw new ProBizException(ProExceptionCode.PARAMS_ERR.format(new String[]{"\u6761\u4ef6\u6a21\u7248\u4e0d\u80fd\u4e3a\u7a7a"}));
        }
        RuleEo eo = BeanCopyUtil.copyProperties(RuleEo.class, dto, new String[0]);
        eo.setRuleStatus(dto.getRuleStatusEnum().getKey());
        this.ruleDas.insert((BaseEo)eo);
        this.ruleConditionTemplateMappingDas.batchInsert(eo, dto.getConditionTemplateIds());
        return eo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyRule(long ruleId, RuleReqDto dto) {
        RuleEo eo = BeanCopyUtil.copyProperties(RuleEo.class, dto, new String[0]);
        eo.setId(Long.valueOf(ruleId));
        eo.setRuleStatus(dto.getRuleStatusEnum().getKey());
        if (CollectionUtils.isNotEmpty((Collection)dto.getConditionTemplateIds())) {
            RuleConditionTemplateMappingEo mappingEo = RuleConditionTemplateMappingEo.newInstance();
            mappingEo.setRuleId(Long.valueOf(ruleId));
            this.ruleConditionTemplateMappingDas.delete((BaseEo)mappingEo);
            this.ruleConditionTemplateMappingDas.batchInsert(eo, dto.getConditionTemplateIds());
        }
        this.ruleDas.updateSelective((BaseEo)eo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteRule(long ruleId) {
        this.ruleDas.logicDeleteById(Long.valueOf(ruleId));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableRule(long ruleId) {
        RuleEo eo = RuleEo.newInstance();
        eo.setId(Long.valueOf(ruleId));
        eo.setRuleStatus(EnableStatusEnum.ENABLE.getKey());
        this.ruleDas.updateSelective((BaseEo)eo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableRule(long ruleId) {
        RuleEo eo = RuleEo.newInstance();
        eo.setId(Long.valueOf(ruleId));
        eo.setRuleStatus(EnableStatusEnum.DISABLE.getKey());
        this.ruleDas.updateSelective((BaseEo)eo);
    }

    @Override
    public Collection<RuleRespDto> queryByIds(Set<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        LinkedList result = Lists.newLinkedList();
        BatchOperationUtil.batchQuery(Lists.newArrayList(ids), d -> {
            RuleEo eo = RuleEo.newInstance();
            eo.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("id", (Collection<?>)d).get());
            List eos = this.ruleDas.select((BaseEo)eo);
            result.addAll(BeanCopyUtil.copyCollections(eos, RuleRespDto.class, new String[0]));
        });
        return result;
    }

    @Override
    public RuleRespDto queryRuleDetail(Long id) {
        this.checkBase(ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        RuleEo ruleEo = this.checkById(id, ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        RuleRespDto ruleRespDto = new RuleRespDto();
        CubeBeanUtils.copyProperties((Object)ruleRespDto, (Object)ruleEo, (String[])new String[0]);
        return ruleRespDto;
    }

    @Override
    public List<RuleRespDto> queryRuleList(RuleQueryReqDto ruleQueryReqDto) {
        this.checkBase(ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        RuleEo ruleEo = RuleEo.newInstance();
        CubeBeanUtils.copyProperties((Object)ruleEo, (Object)ruleQueryReqDto, (String[])new String[0]);
        ruleEo.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        ruleEo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        if (null != ruleQueryReqDto.getRuleStatusEnum()) {
            ruleEo.setRuleStatus(ruleQueryReqDto.getRuleStatusEnum().getKey());
        }
        this.setQueryTimeConditions(ruleEo, ruleQueryReqDto.getCreateStartTime(), ruleQueryReqDto.getCreateEndTime());
        List eoList = this.ruleDas.select((BaseEo)ruleEo);
        ArrayList<RuleRespDto> ruleRespDtoList = new ArrayList<RuleRespDto>();
        CubeBeanUtils.copyCollection(ruleRespDtoList, (Collection)eoList, RuleRespDto.class);
        return ruleRespDtoList;
    }

    @Override
    public PageInfo<RuleRespDto> queryRulePage(RuleQueryReqDto ruleQueryReqDto, Integer pageNum, Integer pageSize) {
        this.checkBase(ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        RuleEo ruleEo = RuleEo.newInstance();
        CubeBeanUtils.copyProperties((Object)ruleEo, (Object)ruleQueryReqDto, (String[])new String[0]);
        ruleEo.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        ruleEo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        this.setQueryTimeConditions(ruleEo, ruleQueryReqDto.getCreateStartTime(), ruleQueryReqDto.getCreateEndTime());
        PageInfo eoPageInfo = this.ruleDas.selectPage((BaseEo)ruleEo, pageNum, pageSize);
        ArrayList ruleRespDtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), ruleRespDtoList, RuleRespDto.class);
        eoPageInfo.setList(ruleRespDtoList);
        return eoPageInfo;
    }

    private void checkBase(Long instanceId, Long tenantId) {
    }

    private RuleEo checkById(Long id, Long instanceId, Long tenantId) {
        RuleEo ruleEo = (RuleEo)this.ruleDas.selectByPrimaryKey(id);
        return ruleEo;
    }

    private void setQueryTimeConditions(RuleEo ruleEo, String startTime, String endTime) {
        ArrayList<SqlFilter> sqlFilterList = ruleEo.getSqlFilters();
        if (StringUtils.isNotEmpty((CharSequence)startTime)) {
            if (sqlFilterList == null) {
                sqlFilterList = new ArrayList<SqlFilter>();
            }
            sqlFilterList.add(SqlFilter.gt((String)"create_time", (Object)startTime));
        }
        if (StringUtils.isNotEmpty((CharSequence)endTime)) {
            if (sqlFilterList == null) {
                sqlFilterList = new ArrayList();
            }
            sqlFilterList.add(SqlFilter.lt((String)"create_time", (Object)endTime));
        }
        ruleEo.setSqlFilters(sqlFilterList);
    }
}

