/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.coupon.apiimpl.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponQueryRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query.ICouponQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.coupon.service.ICouponService;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.constraints.Min;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="couponQueryApiImpl")
public class CouponQueryApiImpl
implements ICouponQueryApi {
    private static final Logger logger = LoggerFactory.getLogger(CouponQueryApiImpl.class);
    @Resource
    private ICouponService couponService;

    public RestResponse<Integer> countByConditions(@Min(value=1L, message="\u8bf7\u4f20\u5165\u5408\u6cd5\u7684\u7528\u6237ID") @Min(value=1L, message="\u8bf7\u4f20\u5165\u5408\u6cd5\u7684\u7528\u6237ID") long userId, @Min(value=1L, message="\u8bf7\u4f20\u5165\u5408\u6cd5\u7684\u4f18\u60e0\u5238ID") @Min(value=1L, message="\u8bf7\u4f20\u5165\u5408\u6cd5\u7684\u4f18\u60e0\u5238ID") long couponTemplateId) {
        int count = this.couponService.countByConditions(userId, couponTemplateId);
        return new RestResponse((Object)count);
    }

    public RestResponse<CouponRespDto> queryCouponDetail(@Min(value=1L, message="\u8bf7\u4f20\u5165\u5408\u6cd5\u7684\u4f18\u60e0\u5238ID") @Min(value=1L, message="\u8bf7\u4f20\u5165\u5408\u6cd5\u7684\u4f18\u60e0\u5238ID") long id) {
        return new RestResponse((Object)this.couponService.getCouponDetail(id));
    }

    public RestResponse<PageInfo<CouponQueryRespDto>> queryCouponPage(CouponQueryReqDto reqDto, int pageNum, int pageSize) {
        return new RestResponse(this.couponService.queryByPage(reqDto, pageNum, pageSize));
    }

    public RestResponse<List<CouponRespDto>> queryUserCouponList(Long userId, CouponQueryReqDto couponQueryReqDto) {
        return new RestResponse(this.couponService.queryUserCouponList(userId, couponQueryReqDto));
    }

    public RestResponse<List<CouponRespDto>> queryUserListByCoupon(Long couponTemplateId) {
        return new RestResponse(this.couponService.queryUserListByCoupon(couponTemplateId));
    }

    public RestResponse<List<CouponRespDto>> queryValidCoupon(long userId, List<Long> itemIds, List<Long> couponIds, double amount) {
        List<CouponRespDto> list = this.couponService.queryValidCoupon(userId, itemIds, couponIds, amount);
        return new RestResponse(list);
    }
}

