/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.scheduler;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ITcbjInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjCombinationActBacktrackReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.BizActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.scheduler.ActivityActivateTask;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="activityFinishTask")
@Scope(value="prototype")
public class ActivityFinishTask
extends SingleTupleScheduleEvent {
    private static Logger logger = LoggerFactory.getLogger(ActivityActivateTask.class);
    @Resource
    private IActivityService activityService;
    @Resource
    private ITcbjInventoryApi tcbjInventoryApi;

    public void before(TaskMsg taskMsg) {
        System.out.println("\u6267\u884c\u4efb\u52a1\u524d..");
    }

    public boolean execute(TaskMsg taskMsg) {
        String content = taskMsg.getContent();
        if (StringUtils.isBlank((CharSequence)content)) {
            logger.error("\u6d3b\u52a8id\u4e3a\u7a7a");
            return false;
        }
        long id = Long.parseLong(content);
        try {
            logger.info("\u6267\u884c\u7ed3\u675f\u6d3b\u52a8\u5b9a\u65f6\u4efb\u52a1\uff0cactivityId={}", (Object)id);
            ActivityRespDto activityRespDto = this.activityService.queryById(id);
            if (!ActivityStatusEnum.ACTIVATE.getKey().equals(activityRespDto.getActivityStatus()) && !ActivityStatusEnum.PAUSE.getKey().equals(activityRespDto.getActivityStatus())) {
                logger.error("\u6d3b\u52a8\u72b6\u6001\u4e0d\u6b63\u786e:{}", (Object)id);
            }
            this.activityService.finish(id);
            if (Objects.equals(BizActivityType.COMBINATION_ACTIVITY.getId(), activityRespDto.getActivityTemplateId())) {
                this.backtrackInventory(activityRespDto);
            }
        }
        catch (Exception e) {
            logger.error("\u6d3b\u52a8\u7ed3\u675f\u5931\u8d25", (Throwable)e);
        }
        return true;
    }

    private void backtrackInventory(ActivityRespDto activityRespDto) {
        TcbjCombinationActBacktrackReqDto combinationActBacktrackReqDto = new TcbjCombinationActBacktrackReqDto();
        combinationActBacktrackReqDto.setActivityId(activityRespDto.getId());
        combinationActBacktrackReqDto.setActivityCode(activityRespDto.getActivityCode());
        combinationActBacktrackReqDto.setActivityType(ActivityType.COMBINATION_ACTIVITY.name());
        logger.info("\u6d3b\u52a8\u81ea\u52a8\u7ed3\u675f\uff0c\u4f18\u60e0\u5957\u88c5\u53d6\u6d88\u9884\u5360\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)combinationActBacktrackReqDto));
        RestResponseHelper.extractData((RestResponse)this.tcbjInventoryApi.backtrackInventory(combinationActBacktrackReqDto));
    }

    public void after(TaskMsg taskMsg) {
        System.out.println("\u6267\u884c\u4efb\u52a1\u540e..");
    }
}

