/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityOverlapRuleRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.BizActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IActivityOverlapRuleService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityOverlapRuleDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityOverlapRuleEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.StActivityOverlapRuleEo;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class ActivityOverlapRuleServiceImpl
implements IActivityOverlapRuleService {
    @Resource
    private ActivityOverlapRuleDas activityOverlapRuleDas;

    @Override
    @Cacheable(key="'activity_overlap_rule_' +  #activityTemplateId", value={"activityOverlapRule"}, unless="#result == null")
    public List<ActivityOverlapRuleRespDto> queryByAcTpId(Long activityTemplateId) {
        ActivityOverlapRuleEo param = new ActivityOverlapRuleEo();
        param.setSourceTemplateId(activityTemplateId);
        param.setConfigurable(Integer.valueOf(1));
        param.setOrderBy("sort");
        List sourceEos = this.activityOverlapRuleDas.select((BaseEo)param);
        List<Long> templateIds = sourceEos.stream().map(StActivityOverlapRuleEo::getTargetTemplateId).collect(Collectors.toList());
        ArrayList<ActivityOverlapRuleRespDto> respDtos = new ArrayList<ActivityOverlapRuleRespDto>();
        templateIds.forEach(templateId -> {
            BizActivityType type = BizActivityType.getByType((Long)templateId);
            if (null != type) {
                ActivityOverlapRuleRespDto respDto = new ActivityOverlapRuleRespDto(Long.valueOf(type.getId()), type.getName());
                respDtos.add(respDto);
            }
        });
        if (CollectionUtils.isEmpty(respDtos)) {
            return null;
        }
        return respDtos;
    }
}

