/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.Param;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.enums.DiscountType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.enums.PromotionCategory;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.enums.Stair;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.service.IPromotionCategoryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.vo.ConditionBaseVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class AbstractConditionTemplate<P extends ConditionBaseVo>
extends ConditionTemplate
implements IPromotionCategoryService<P> {
    protected <T> T getParam(String valueName, TemplateDefine define, Map<String, ?> configParams) {
        return this.getParam(valueName, define, configParams, "\u6761\u4ef6\u672a\u914d\u7f6e");
    }

    protected <T> T getParam(String valueName, TemplateDefine define, Map<String, ?> configParams, String msg) {
        Param param = define.getParam(valueName);
        if (null == param) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{msg}));
        }
        return ConditionTemplate.converter(configParams.get(valueName), param, define.getLoadClass());
    }

    <T extends EngineParams> boolean switchPromotionCategory(PromotionCategory promotionCategory, Stair stair, T context, BigDecimal itemTotalAmt, Integer itemTotalNum, DiscountType discountType, P conditionConfig) {
        boolean result = false;
        switch (promotionCategory) {
            case EQUAL: {
                result = this.equal(context, itemTotalAmt, itemTotalNum, discountType, conditionConfig);
                break;
            }
            case FULL: {
                result = this.full(context, itemTotalAmt, itemTotalNum, discountType, conditionConfig);
                break;
            }
            case EACH_FULL: {
                result = this.eachFull(context, itemTotalAmt, itemTotalNum, discountType, conditionConfig);
                break;
            }
            case STAIR: {
                if (stair.isHit() || !(result = this.stair(context, itemTotalAmt, itemTotalNum, discountType, conditionConfig))) break;
                stair.setHit(true);
                break;
            }
            default: {
                throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u65e0\u6b64\u4fc3\u9500\u6761\u4ef6"}));
            }
        }
        return result;
    }

    <M extends ConditionBaseVo> List<M> sort(List<M> conditionList) {
        Comparator<ConditionBaseVo> com = Comparator.comparing(ConditionBaseVo::getLimitAmount);
        return conditionList.stream().sorted(com.reversed()).collect(Collectors.toList());
    }

    BigDecimal getItemTotalAmt(List<ItemVo> itemVos) {
        double totalAmt = itemVos.stream().mapToDouble(itemVo -> itemVo.getPrice().setScale(6, 2).doubleValue() * (double)itemVo.getNum()).sum();
        return BigDecimal.valueOf(totalAmt);
    }

    Integer getItemTotalNum(List<ItemVo> itemVos) {
        return itemVos.stream().mapToInt(ItemVo::getNum).sum();
    }

    Map<Long, Integer> list2Map(List<Long> keys, Integer value) {
        return keys.stream().collect(Collectors.toMap(k -> k, v -> value));
    }

    abstract <T extends EngineParams> void handleDiscount(T var1, BigDecimal var2, DiscountType var3, P var4);

    @Override
    public <T extends EngineParams> boolean eachFull(T context, BigDecimal itemTotalAmt, Integer itemTotalNum, DiscountType discountType, P conditionConfig) {
        throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u4e0d\u80fd\u542b\u6709\"\u6bcf\u6ee1\"\u6761\u4ef6"}));
    }

    @Override
    public <T extends EngineParams> boolean stair(T context, BigDecimal itemTotalAmt, Integer itemTotalNum, DiscountType discountType, P conditionConfig) {
        if (Objects.equals(((ConditionBaseVo)((Object)conditionConfig)).getPriceType(), 2)) {
            if (BigDecimal.valueOf(itemTotalNum.intValue()).compareTo(((ConditionBaseVo)((Object)conditionConfig)).getLimitAmount()) >= 0) {
                this.handleDiscount(context, itemTotalAmt, discountType, conditionConfig);
                return true;
            }
        } else if (itemTotalAmt.compareTo(((ConditionBaseVo)((Object)conditionConfig)).getLimitAmount()) >= 0) {
            this.handleDiscount(context, itemTotalAmt, discountType, conditionConfig);
            return true;
        }
        return false;
    }

    @Override
    public <T extends EngineParams> boolean full(T context, BigDecimal itemTotalAmt, Integer itemTotalNum, DiscountType discountType, P conditionConfig) {
        if (Objects.equals(((ConditionBaseVo)((Object)conditionConfig)).getPriceType(), 2)) {
            if (BigDecimal.valueOf(itemTotalNum.intValue()).compareTo(((ConditionBaseVo)((Object)conditionConfig)).getLimitAmount()) >= 0) {
                this.handleDiscount(context, itemTotalAmt, discountType, conditionConfig);
                return true;
            }
        } else if (itemTotalAmt.compareTo(((ConditionBaseVo)((Object)conditionConfig)).getLimitAmount()) >= 0) {
            this.handleDiscount(context, itemTotalAmt, discountType, conditionConfig);
            return true;
        }
        return false;
    }

    @Override
    public <T extends EngineParams> boolean equal(T context, BigDecimal itemTotalAmt, Integer itemTotalNum, DiscountType discountType, P conditionConfig) {
        if (Objects.equals(((ConditionBaseVo)((Object)conditionConfig)).getPriceType(), 2)) {
            if (BigDecimal.valueOf(itemTotalNum.intValue()).compareTo(((ConditionBaseVo)((Object)conditionConfig)).getLimitAmount()) == 0) {
                this.handleDiscount(context, itemTotalAmt, discountType, conditionConfig);
                return true;
            }
        } else if (itemTotalAmt.compareTo(((ConditionBaseVo)((Object)conditionConfig)).getLimitAmount()) == 0) {
            this.handleDiscount(context, itemTotalAmt, discountType, conditionConfig);
            return true;
        }
        return false;
    }
}

