/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.AbstractConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.enums.DiscountType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.enums.PromotionCategory;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.enums.Stair;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.vo.AdditionalBuyConditionVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.MapUtils;

public class AdditionalBuyCondition
extends AbstractConditionTemplate<AdditionalBuyConditionVo> {
    private static final String CONDITION = "AdditionalBuyCondition.condition";
    private static final String TYPE = "AdditionalBuyCondition.type";

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine templateDefine, ConditionRespDto conditionRespDto, T context, Map<String, ?> configParams) {
        List conditionVos = this.sort((List)this.getParam(CONDITION, templateDefine, configParams, "\u52a0\u4ef7\u8d2d\u914d\u7f6e\u672a\u914d\u7f6e"));
        Integer discountTypeInt = (Integer)this.getParam(TYPE, templateDefine, configParams, "\u4fc3\u9500\u7c7b\u522b\u672a\u914d\u7f6e");
        DiscountType discountType = DiscountType.getByType(discountTypeInt);
        BigDecimal itemTotalAmt = this.getItemTotalAmt(context.getItems());
        Integer itemTotalNum = this.getItemTotalNum(context.getItems());
        Stair stair = Stair.newStair();
        boolean result = false;
        for (AdditionalBuyConditionVo conditionVo : conditionVos) {
            PromotionCategory promotionCategory = PromotionCategory.getByType(conditionVo.getCondition());
            result |= this.switchPromotionCategory(promotionCategory, stair, context, itemTotalAmt, itemTotalNum, discountType, conditionVo);
        }
        if (!result) {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u4e0d\u6ee1\u8db3\u53c2\u4e0e\u6d3b\u52a8\u6761\u4ef6"}));
        }
        return result;
    }

    @Override
    public <T extends EngineParams> void handleDiscount(T context, BigDecimal itemTotalAmt, DiscountType discountType, AdditionalBuyConditionVo conditionConfig) {
        ItemVo gift;
        Integer buyNum = conditionConfig.getBuyNum();
        BigDecimal addPrice = conditionConfig.getAddPrice();
        String itemId = conditionConfig.getItemId();
        Optional<ItemVo> optional = context.getItems().stream().filter(a -> Objects.equals(a.getItemId(), itemId)).findFirst();
        if (optional.isPresent()) {
            ItemVo itemVo = optional.get();
            gift = new ItemVo();
            CubeBeanUtils.copyProperties((Object)gift, (Object)itemVo, (String[])new String[]{"couponId"});
            gift.setDiscountPrice(addPrice);
            gift.setExtendsAttribute(itemVo.getExtendsAttribute());
            if (itemVo.getNum() > buyNum) {
                itemVo.setNum(itemVo.getNum() - buyNum);
                gift.setNum(buyNum.intValue());
            } else {
                itemVo.setNum(0);
            }
        } else {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u5546\u54c1\u6ca1\u6709\u53c2\u52a0\u52a0\u4ef7\u8d2d\u6d3b\u52a8"}));
        }
        Map extendsAttribute = context.getExtendsAttribute();
        List sourceItemVos = (List)MapUtils.getObject((Map)extendsAttribute, (Object)"additionalBuy", (Object)Lists.newArrayList());
        sourceItemVos.add(gift);
        context.addExtAttribute("additionalBuy", (Object)sourceItemVos);
    }

    @Override
    public <T extends EngineParams> boolean stair(T context, BigDecimal itemTotalAmt, Integer itemTotalNum, DiscountType discountType, AdditionalBuyConditionVo conditionConfig) {
        boolean isExist;
        if (itemTotalAmt.compareTo(conditionConfig.getLimitAmount()) >= 0 && (isExist = context.getItems().stream().anyMatch(itemVo -> Objects.equals(itemVo.getItemId(), conditionConfig.getItemId())))) {
            this.handleDiscount(context, itemTotalAmt, discountType, conditionConfig);
            return true;
        }
        return false;
    }

    @Override
    public <T extends EngineParams> boolean full(T context, BigDecimal itemTotalAmt, Integer itemTotalNum, DiscountType discountType, AdditionalBuyConditionVo conditionConfig) {
        return this.stair(context, itemTotalAmt, itemTotalNum, discountType, conditionConfig);
    }

    @Override
    public <T extends EngineParams> boolean eachFull(T context, BigDecimal itemTotalAmt, Integer itemTotalNum, DiscountType discountType, AdditionalBuyConditionVo conditionConfig) {
        throw new ProBizException("\u52a0\u4ef7\u8d2d\u4e0d\u80fd\u542b\u6709\"\u6bcf\u6ee1\"\u6761\u4ef6");
    }

    @Override
    public <T extends EngineParams> boolean equal(T context, BigDecimal itemTotalAmt, Integer itemTotalNum, DiscountType discountType, AdditionalBuyConditionVo conditionConfig) {
        throw new ProBizException("\u52a0\u4ef7\u8d2d\u4e0d\u80fd\u542b\u6709\"\u7b49\u4e8e\"\u6761\u4ef6");
    }
}

