/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.seckill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.BaseActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.exchange.ExchangeActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.seckill.SeckillActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.seckill.model.ItemPurchaseLimit;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.AbstractBaseTemplate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class PurchaseLimitCondition
extends AbstractBaseTemplate {
    @Override
    public long getConditionTemplateId() {
        return 1196944771412880289L;
    }

    @Override
    public long getRuleId() {
        return 0L;
    }

    @Override
    public boolean support(ActivityType type) {
        return ActivityType.SECKILL_ACTIVITY.equals((Object)type) || ActivityType.EXCHANGE_ACTIVITY.equals((Object)type);
    }

    @Override
    public <T extends BaseActivityDto> ConditionReqDto convertToCondition(T t) {
        ConditionReqDto condition = this.getConditionReqDto();
        ArrayList itemPurchaseLimits = Lists.newArrayList();
        if (t instanceof SeckillActivityDto) {
            SeckillActivityDto seckillActivityDto = (SeckillActivityDto)t;
            seckillActivityDto.getActivityItems().forEach(itemDto -> {
                ItemPurchaseLimit itemPurchaseLimit = new ItemPurchaseLimit();
                itemPurchaseLimit.setItemId(itemDto.getItemId());
                itemPurchaseLimit.setShopId(itemDto.getShopId());
                itemPurchaseLimit.setLimitLevel(Integer.valueOf(0));
                itemPurchaseLimit.setLimitQuantitySingle(itemDto.getPurchaseQuantityLimitSingle());
                itemPurchaseLimits.add(itemPurchaseLimit);
            });
        } else if (t instanceof ExchangeActivityDto) {
            ExchangeActivityDto exchangeActivityDto = (ExchangeActivityDto)t;
            exchangeActivityDto.getPromotionContents().forEach(content -> content.getExchangeItems().forEach(itemDto -> itemDto.getExcSkuDtos().forEach(excSkuDto -> {
                ItemPurchaseLimit itemPurchaseLimit = new ItemPurchaseLimit();
                itemPurchaseLimit.setItemId(itemDto.getItemId());
                itemPurchaseLimit.setShopId(itemDto.getShopId());
                itemPurchaseLimit.setLimitLevel(Integer.valueOf(1));
                itemPurchaseLimit.setLimitQuantitySingle(Integer.valueOf(excSkuDto.getExchangeNum().intValue()));
                itemPurchaseLimit.setItemLimit(exchangeActivityDto.getItemLimit());
                itemPurchaseLimit.setSkuId(excSkuDto.getSkuId());
                itemPurchaseLimit.setItemLimit(exchangeActivityDto.getItemLimit());
                itemPurchaseLimits.add(itemPurchaseLimit);
            })));
        }
        HashMap conditionParam = Maps.newHashMap();
        conditionParam.put("PurchaseLimitCondition.items", itemPurchaseLimits);
        condition.setConditionParams(JSON.toJSONString((Object)conditionParam));
        return condition;
    }

    @Override
    protected <T extends BaseActivityDto> void parse(ConditionRespDto conditionRespDto, T t) {
        JSONObject jsonObject = JSON.parseObject((String)conditionRespDto.getConditionParams());
        List itemPurchaseLimits = JSONArray.parseArray((String)jsonObject.getString("PurchaseLimitCondition.items"), ItemPurchaseLimit.class);
        if (CollectionUtils.isEmpty((Collection)itemPurchaseLimits)) {
            return;
        }
        Map<String, Integer> limitMap = itemPurchaseLimits.stream().collect(Collectors.toMap(key -> key.getItemId().toString() + key.getShopId(), ItemPurchaseLimit::getLimitQuantitySingle, (e1, e2) -> e1));
        if (t instanceof SeckillActivityDto) {
            SeckillActivityDto seckillActivityDto = (SeckillActivityDto)t;
            seckillActivityDto.getActivityItems().forEach(itemDto -> itemDto.setPurchaseQuantityLimitSingle((Integer)limitMap.get(itemDto.getItemId().toString() + itemDto.getShopId())));
        } else if (t instanceof ExchangeActivityDto) {
            Integer itemLimit = ((ItemPurchaseLimit)itemPurchaseLimits.get(0)).getItemLimit();
            ExchangeActivityDto exchangeActivityDto = (ExchangeActivityDto)t;
            exchangeActivityDto.getActivityItems().forEach(itemDto -> itemDto.setPurchaseQuantityLimitSingle((Integer)limitMap.get(itemDto.getItemId().toString() + itemDto.getShopId())));
            exchangeActivityDto.setItemLimit(itemLimit);
        }
    }
}

