/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.mq;

import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.huieryun.opensearch.api.ISearchIndexService;
import com.dtyunxi.huieryun.opensearch.vo.SearchConditionVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.constants.SingleItemConstants;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="change_single_item_activity_status_tag")
public class SingleItemActivityStatusChangeProcessor
implements IMessageProcessor<Long> {
    private static Logger logger = LoggerFactory.getLogger(SingleItemActivityStatusChangeProcessor.class);
    @Resource
    private IActivityService activityService;
    @Value(value="${cube.global.profile:}")
    private String globalProfile;
    @Resource
    private ISearchIndexService searchIndexService;

    public MessageResponse process(Long activityId) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        logger.info("[\u4e0d\u652f\u6301\u5355\u72ec\u8d2d\u4e70\u5546\u54c1],\u4fee\u6539\u6d3b\u52a8\u72b6\u6001\u4fe1\u606f\uff1a{}", (Object)activityId);
        if (activityId == null) {
            return MessageResponse.SUCCESS;
        }
        ActivityRespDto activityRespDto = this.activityService.getById(activityId);
        if (!SingleItemConstants.SUPPORT_ACTIVITY_TYPE.contains(activityRespDto.getActivityTemplateId())) {
            return MessageResponse.SUCCESS;
        }
        try {
            logger.info("[\u4e0d\u652f\u6301\u5355\u72ec\u8d2d\u4e70\u5546\u54c1\u540c\u6b65\u6d3b\u52a8\u72b6\u6001]:{}", (Object)activityId);
            SearchConditionVo searchConditionVo = new SearchConditionVo("single_buy_item_" + this.globalProfile, "exchange_item");
            searchConditionVo.addEqualFilter("activityId", String.valueOf(activityId));
            HashMap map = Maps.newHashMap();
            map.put("activityStatus", activityRespDto.getActivityStatus());
            this.searchIndexService.updateDataByCondition(searchConditionVo, (Map)map);
        }
        catch (Exception e) {
            logger.error("[\u4e0d\u652f\u6301\u5355\u72ec\u8d2d\u4e70\u5546\u54c1]\uff0c\u4fee\u6539\u6d3b\u52a8\u72b6\u6001\u62a5\u9519\uff1a{}", (Throwable)e);
            return MessageResponse.SUCCESS;
        }
        return MessageResponse.SUCCESS;
    }
}

