/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.coupon.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityCreateReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.EnableStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponStatus;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.UseSuperimposedType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponCreateReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponItemReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponQueryRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBusinessRuntimeException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityJoinLogService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.coupon.service.ICouponService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.mq.provider.MQProviderHelper;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.BeanCopyUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActionDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityItemDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityTemplateDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ConditionDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.das.CouponDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.das.CouponItemMappingDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.das.CouponTemplateDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActionEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityItemEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ConditionEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponItemMappingEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponTemplateEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.vo.CouponUseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CouponServiceImpl
implements ICouponService {
    private Logger logger = LoggerFactory.getLogger(CouponServiceImpl.class);
    @Autowired
    private ICacheService cacheService;
    @Resource
    private ActivityDas activityDas;
    @Resource
    private ActivityTemplateDas activityTemplateDas;
    @Resource
    private CouponTemplateDas couponTemplateDas;
    @Resource
    private ActivityItemDas activityItemDas;
    @Resource
    private ConditionDas conditionDas;
    @Resource
    private ActionDas actionDas;
    @Resource
    private CouponDas couponDas;
    @Autowired
    private IActivityJoinLogService activityJoinLogService;
    @Autowired
    private CouponItemMappingDas couponItemMappingDas;
    @Resource
    private IActivityService activityService;
    private String splitStr = "\\||&|\\(|\\)|=";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long addCoupon(CouponCreateReqDto couponCreateReqDto) {
        ActivityCreateReqDto activityCreateReqDto = new ActivityCreateReqDto();
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityName(couponCreateReqDto.getCouponName());
        activityDto.setActivityStatusEnum(couponCreateReqDto.getActivityStatusEnum());
        activityDto.setActivityTemplateId(couponCreateReqDto.getActivityTemplateId());
        activityDto.setAuditStatusEnum(couponCreateReqDto.getAuditStatusEnum());
        activityDto.setBeginTime(couponCreateReqDto.getBeginTime());
        activityDto.setEndTime(couponCreateReqDto.getEndTime());
        activityDto.setExecExpression(couponCreateReqDto.getExecExpression());
        activityDto.setExtension(couponCreateReqDto.getExtension());
        activityDto.setNoticeTime(couponCreateReqDto.getNoticeTime());
        activityDto.setRemark(couponCreateReqDto.getRemark());
        activityDto.setInstanceId(couponCreateReqDto.getInstanceId());
        activityDto.setTenantId(couponCreateReqDto.getTenantId());
        activityDto.setSellerId(couponCreateReqDto.getSellerId());
        activityDto.setShopId(couponCreateReqDto.getShopId());
        activityCreateReqDto.setActivityDto(activityDto);
        activityCreateReqDto.setActions(couponCreateReqDto.getActions());
        activityCreateReqDto.setConditions(couponCreateReqDto.getConditions());
        activityCreateReqDto.setUserIds(couponCreateReqDto.getUserIds());
        long activityId = this.activityService.createActivityByOneStep(activityCreateReqDto);
        long couponTemplateId = this.couponTemplateProcess(couponCreateReqDto, activityId);
        this.itemProcess(couponCreateReqDto.getActivityItems(), couponTemplateId);
        return activityId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyCoupon(Long id, CouponCreateReqDto couponCreateReqDto) {
        CouponTemplateEo couponTemplateEo = (CouponTemplateEo)this.couponTemplateDas.selectByPrimaryKey(id);
        if (couponTemplateEo == null) {
            throw new ProBizException(ProExceptionCode.RECORD_NOT_EXIST.format(new String[]{"\u8be5id\u5bf9\u5e94\u7684\u4f18\u60e0\u5238\u6a21\u677f\u8bb0\u5f55\u4e0d\u5b58\u5728"}).format(new String[]{"" + id}));
        }
        if (!couponTemplateEo.getInstanceId().equals(ServiceContext.getContext().getRequestInstanceId()) || !couponTemplateEo.getTenantId().equals(ServiceContext.getContext().getRequestTenantId())) {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u8be5id\u5bf9\u5e94\u8bb0\u5f55\u7684instanceId\u6216tenantId\u4e0d\u5339\u914d"}));
        }
        ActivityEo activityEo = (ActivityEo)this.activityDas.selectByPrimaryKey(couponTemplateEo.getActivityId());
        if (activityEo == null) {
            throw new ProBizException(ProExceptionCode.RECORD_NOT_EXIST.format(new String[]{"\u8be5\u6d3b\u52a8id\u5bf9\u5e94\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728"}).format(new String[]{"" + couponTemplateEo.getActivityId()}));
        }
        DtoHelper.dto2Eo((BaseVo)couponCreateReqDto, (BaseEo)activityEo);
        activityEo.setActivityName(couponCreateReqDto.getCouponName());
        if (couponCreateReqDto.getActivityStatusEnum() != null) {
            activityEo.setActivityStatus(couponCreateReqDto.getActivityStatusEnum().getKey());
        }
        if (couponCreateReqDto.getAuditStatusEnum() != null) {
            activityEo.setAuditStatus(couponCreateReqDto.getAuditStatusEnum().getKey());
        }
        activityEo.setInstanceId(couponCreateReqDto.getInstanceId());
        activityEo.setTenantId(couponCreateReqDto.getTenantId());
        ActivityCreateReqDto activityDto = new ActivityCreateReqDto();
        ActivityDto acDto = new ActivityDto();
        DtoHelper.eo2Dto((BaseEo)activityEo, (BaseVo)acDto);
        acDto.setId(couponTemplateEo.getActivityId());
        activityDto.setActivityDto(acDto);
        activityDto.setActions(couponCreateReqDto.getActions());
        activityDto.setConditions(couponCreateReqDto.getConditions());
        activityDto.setUserIds(couponCreateReqDto.getUserIds());
        this.activityService.modifyActivityByOneStep(couponTemplateEo.getActivityId(), activityDto);
        couponTemplateEo.setCouponCode(couponCreateReqDto.getCouponCode());
        couponTemplateEo.setInstanceId(couponCreateReqDto.getInstanceId());
        couponTemplateEo.setTenantId(couponCreateReqDto.getTenantId());
        List couponTemplateEoList = this.couponTemplateDas.select((BaseEo)couponTemplateEo);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)couponTemplateEoList)) {
            throw new ProBizException(ProExceptionCode.RECORD_NOT_EXIST.format(new String[]{"\u8be5\u4f18\u60e0\u5238\u7f16\u7801\u5bf9\u5e94\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728"}).format(new String[]{"\u4f18\u60e0\u5238\u7f16\u7801\uff1a" + couponCreateReqDto.getCouponCode()}));
        }
        for (CouponTemplateEo eo : couponTemplateEoList) {
            DtoHelper.dto2Eo((BaseVo)couponCreateReqDto, (BaseEo)eo);
            eo.setInvalidTime(couponCreateReqDto.getCouponUseEndTime());
            eo.setEffectiveTime(couponCreateReqDto.getCouponUseBeginTime());
            if (couponCreateReqDto.getAuditStatusEnum() != null) {
                eo.setCouponTemplateStatus(couponCreateReqDto.getAuditStatusEnum().getKey());
            }
            this.couponTemplateDas.updateSelective((BaseEo)eo);
            CouponItemMappingEo couponItemMappingEo = CouponItemMappingEo.newInstance();
            couponItemMappingEo.setCouponTemplateId(id);
            this.couponItemMappingDas.logicDelete((BaseEo)couponItemMappingEo);
            this.itemProcess(couponCreateReqDto.getActivityItems(), eo.getId());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteCoupon(Long id) {
        CouponEo couponEo;
        ArrayList<Long> templateIdList;
        CouponTemplateEo couponTemplateEo;
        ActivityEo activityEo = (ActivityEo)this.activityDas.selectByPrimaryKey(id);
        if (activityEo == null || !ServiceContext.getContext().getRequestInstanceId().equals(activityEo.getInstanceId()) || !ServiceContext.getContext().getRequestTenantId().equals(activityEo.getTenantId())) {
            throw new ProBusinessRuntimeException(ProExceptionCode.RECORD_NOT_EXIST);
        }
        if (ActivityStatusEnum.NEW.getKey().equals(activityEo.getActivityStatus()) || ActivityStatusEnum.READY.getKey().equals(activityEo.getActivityStatus())) {
            this.activityDas.logicDeleteById(id);
            couponTemplateEo = new CouponTemplateEo();
            couponTemplateEo.setActivityId(id);
            List templateList = this.couponTemplateDas.select((BaseEo)couponTemplateEo);
            templateIdList = new ArrayList<Long>();
            couponEo = new CouponEo();
            for (CouponTemplateEo template : templateList) {
                templateIdList.add(template.getId());
            }
        } else {
            throw new ProBusinessRuntimeException(ProExceptionCode.ACTIVITY_TEMPLATE_CODE_NOT_EXISTS);
        }
        this.couponTemplateDas.logicDelete((BaseEo)couponTemplateEo);
        ConditionEo conditionEo = new ConditionEo();
        conditionEo.setActivityId(id);
        this.conditionDas.logicDelete((BaseEo)conditionEo);
        ActionEo actionEo = new ActionEo();
        actionEo.setActivityId(id);
        this.actionDas.logicDelete((BaseEo)actionEo);
        ActivityItemEo activityItemEo = new ActivityItemEo();
        activityItemEo.setActivityId(id);
        this.activityItemDas.logicDelete((BaseEo)activityItemEo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"coupon_template_id", templateIdList));
        sqlFilters.add(SqlFilter.eq((String)"activity_id", (Object)id));
        this.couponDas.logicDelete((BaseEo)couponEo);
    }

    @Override
    public CouponRespDto getCoupon(String couponCode) {
        CouponEo eo = CouponEo.newInstance();
        eo.setCouponCode(couponCode);
        List select = this.couponDas.select((BaseEo)eo);
        if (CollectionUtils.isEmpty((Collection)select)) {
            return BeanCopyUtil.copyProperties(CouponRespDto.class, select.get(0), new String[0]);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableCoupon(long id, CouponStatus status) {
        CouponEo eo = CouponEo.newInstance();
        eo.setId(Long.valueOf(id));
        eo.setCouponStatus(status.getKey());
        this.couponDas.updateSelective((BaseEo)eo);
    }

    @Override
    public void enableCoupon(long id, String status) {
        CouponEo eo = CouponEo.newInstance();
        eo.setId(Long.valueOf(id));
        eo.setCouponStatus(status);
        this.couponDas.updateSelective((BaseEo)eo);
    }

    private Long couponTemplateProcess(CouponCreateReqDto couponCreateReqDto, Long activityId) {
        CouponTemplateEo couponTemplateEo = CouponTemplateEo.newInstance();
        couponTemplateEo.setCouponCode(couponCreateReqDto.getCouponCode());
        couponTemplateEo.setRemainingQuantity(couponCreateReqDto.getTotalIssueQuantity());
        couponTemplateEo.setInstanceId(couponCreateReqDto.getInstanceId());
        couponTemplateEo.setTenantId(couponCreateReqDto.getTenantId());
        if (this.couponTemplateDas.count((BaseEo)couponTemplateEo) > 0) {
            throw new ProBusinessRuntimeException(ProExceptionCode.COUPON_CODE_EXISTS);
        }
        DtoHelper.dto2Eo((BaseVo)couponCreateReqDto, (BaseEo)couponTemplateEo);
        couponTemplateEo.setAmount(couponCreateReqDto.getAmount());
        couponTemplateEo.setActivityId(activityId);
        couponTemplateEo.setInvalidTime(couponCreateReqDto.getCouponUseEndTime());
        couponTemplateEo.setEffectiveTime(couponCreateReqDto.getCouponUseBeginTime());
        couponTemplateEo.setCouponTemplateStatus(couponCreateReqDto.getCouponDefineStatus());
        couponTemplateEo.setStatus(EnableStatusEnum.ENABLE.getKey());
        this.couponTemplateDas.insert((BaseEo)couponTemplateEo);
        if ("Y".equals(couponCreateReqDto.getIsGenerate())) {
            // empty if block
        }
        return couponTemplateEo.getId();
    }

    private void itemProcess(List<CouponItemReqDto> activityItemDtoList, long couponTemplateId) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(activityItemDtoList)) {
            return;
        }
        ArrayList activityItemEoList = new ArrayList();
        activityItemDtoList.forEach(itemDto -> {
            CouponItemMappingEo couponItemMappingEo = BeanCopyUtil.copyProperties(CouponItemMappingEo.class, itemDto, new String[0]);
            couponItemMappingEo.setCouponTemplateId(Long.valueOf(couponTemplateId));
            activityItemEoList.add(couponItemMappingEo);
        });
        this.couponItemMappingDas.insertBatch(activityItemEoList);
    }

    @Override
    public List<CouponRespDto> queryUserCouponList(Long userId, CouponQueryReqDto couponQueryReqDto) {
        CouponEo couponEo = BeanCopyUtil.copyProperties(CouponEo.class, couponQueryReqDto, new String[0]);
        couponEo.setUserId(userId);
        SqlFilterBuilder sqlFilterBuilder = SqlFilterBuilder.newInstance();
        if (couponQueryReqDto.getEffectiveTimeBeginTime() != null && couponQueryReqDto.getEffectiveTimeEndTime() != null) {
            sqlFilterBuilder = sqlFilterBuilder.buildBetweenSqlFilter("effective_time", couponQueryReqDto.getEffectiveTimeBeginTime(), couponQueryReqDto.getEffectiveTimeEndTime());
        }
        if (couponQueryReqDto.getInvalidTimeBeginTime() != null && couponQueryReqDto.getInvalidTimeEndTime() != null) {
            sqlFilterBuilder = sqlFilterBuilder.buildBetweenSqlFilter("invalid_time", couponQueryReqDto.getInvalidTimeBeginTime(), couponQueryReqDto.getInvalidTimeEndTime());
        }
        if (couponQueryReqDto.getCreateBeginTime() != null && couponQueryReqDto.getCreateEndTime() != null) {
            sqlFilterBuilder = sqlFilterBuilder.buildBetweenSqlFilter("create_time", couponQueryReqDto.getCreateBeginTime(), couponQueryReqDto.getCreateEndTime());
        }
        couponEo.setSqlFilters(sqlFilterBuilder.get());
        couponEo.setOrderByDesc("couponValue");
        List couponEoList = this.couponDas.select((BaseEo)couponEo);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)couponEoList)) {
            return Lists.newLinkedList();
        }
        ArrayList<CouponRespDto> couponRespDtoList = new ArrayList<CouponRespDto>();
        DtoHelper.eoList2DtoList((Collection)couponEoList, couponRespDtoList, CouponRespDto.class);
        return couponRespDtoList;
    }

    @Override
    public List<CouponRespDto> queryUserListByCoupon(Long couponTemplateId) {
        CouponEo couponEo = CouponEo.newInstance();
        couponEo.setCouponTemplateId(couponTemplateId);
        List couponEoList = this.couponDas.select((BaseEo)couponEo);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)couponEoList)) {
            throw new ProBusinessRuntimeException(ProExceptionCode.RECORD_NOT_EXIST);
        }
        ArrayList<CouponRespDto> couponRespDtoList = new ArrayList<CouponRespDto>();
        DtoHelper.eoList2DtoList((Collection)couponEoList, couponRespDtoList, CouponRespDto.class);
        return couponRespDtoList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deductCouponSuccess(long userId, String orderCode, String status, List<Long> couponIds, long joinUserId) {
        CouponEo eo = CouponEo.newInstance();
        eo.setCouponStatus(Optional.ofNullable(status).orElse(CouponStatus.HAS_CONSUMED.getKey()));
        eo.setOrderCode(orderCode);
        eo.setUseTime(new Date());
        eo.setSqlFilters(SqlFilterBuilder.newInstance().buildEqualsSqlFilter("user_id", userId).buildInSqlFilter("id", couponIds).get());
        this.couponDas.updateSelectiveSqlFilter((BaseEo)eo);
        this.activityJoinLogService.enable(joinUserId, 0L, couponIds, orderCode);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deductCouponFailure(long userId, String orderCode, String status, List<Long> couponIds, long joinUserId) {
        CouponEo eo = CouponEo.newInstance();
        eo.setCouponStatus(Optional.ofNullable(status).orElse(CouponStatus.NOT_CONSUMED.getKey()));
        eo.setSqlFilters(SqlFilterBuilder.newInstance().buildEqualsSqlFilter("user_id", userId).buildInSqlFilter("id", couponIds).get());
        this.couponDas.updateSelectiveSqlFilter((BaseEo)eo);
        this.activityJoinLogService.disable(joinUserId, 0L, couponIds);
    }

    private Long activityProcess(CouponCreateReqDto couponCreateReqDto) {
        if (couponCreateReqDto.getInstanceId() == null || couponCreateReqDto.getTenantId() == null) {
            throw new ProBusinessRuntimeException(ProExceptionCode.PARAMETER_ERROR);
        }
        if (this.activityTemplateDas.selectByPrimaryKey(couponCreateReqDto.getActivityTemplateId()) == null) {
            throw new ProBusinessRuntimeException(ProExceptionCode.ACTIVITY_TEMPLATE_CODE_NOT_EXISTS);
        }
        ActivityEo activityEo = new ActivityEo();
        activityEo.setActivityName(couponCreateReqDto.getCouponName());
        activityEo.setInstanceId(couponCreateReqDto.getInstanceId());
        activityEo.setTenantId(couponCreateReqDto.getTenantId());
        if (this.activityDas.count((BaseEo)activityEo) > 0) {
            throw new ProBusinessRuntimeException(ProExceptionCode.ACTIVITY_NAME_EXISTS);
        }
        activityEo.setActivityTemplateId(couponCreateReqDto.getActivityTemplateId());
        activityEo.setBeginTime(couponCreateReqDto.getBeginTime());
        activityEo.setEndTime(couponCreateReqDto.getEndTime());
        activityEo.setExecExpression(couponCreateReqDto.getExecExpression());
        activityEo.setNoticeTime(couponCreateReqDto.getNoticeTime());
        activityEo.setRemark(couponCreateReqDto.getRemark());
        activityEo.setActivityStatus(couponCreateReqDto.getActivityStatusEnum().getKey());
        activityEo.setAuditStatus(couponCreateReqDto.getAuditStatusEnum().getKey());
        activityEo.setExtension(couponCreateReqDto.getExtension());
        this.activityDas.insert((BaseEo)activityEo);
        return activityEo.getId();
    }

    @Override
    public List<CouponRespDto> queryValidCoupon(Long userId, List<Long> itemIds, List<Long> couponIds, Double amount) {
        List couponUseVoTempList = null;
        couponUseVoTempList = itemIds == null ? this.couponDas.selectValidCouponsByUserIdAndAmount(userId, amount, couponIds) : (amount == null ? this.couponDas.selectValidCouponsByUserIdAndItems(userId, itemIds, couponIds) : this.couponDas.selectValidCouponsByUserIdAndItemsAndAmount(userId, itemIds, amount, couponIds));
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)couponUseVoTempList)) {
            List couponUseVoList = couponUseVoTempList;
            Set couponDefineIdSet = couponUseVoList.stream().map(CouponUseVo::getCouponDefineId).collect(Collectors.toSet());
            List couponTemplateEoList = couponDefineIdSet.stream().map(couponDefineId -> {
                for (CouponUseVo activityCouponUseVo : couponUseVoList) {
                    if (!activityCouponUseVo.getCouponDefineId().equals(couponDefineId)) continue;
                    CouponTemplateEo couponTemplateEo = new CouponTemplateEo();
                    couponTemplateEo.setId(couponDefineId);
                    couponTemplateEo.setUseSuperimposedType(activityCouponUseVo.getUseSuperimposedType());
                    return couponTemplateEo;
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            ArrayList<CouponTemplateEo> canUseCouponDefineList = new ArrayList<CouponTemplateEo>();
            for (CouponTemplateEo couponTemplateEo : couponTemplateEoList) {
                if (!UseSuperimposedType.NO.getKey().equals(couponTemplateEo.getUseSuperimposedType())) {
                    canUseCouponDefineList.add(couponTemplateEo);
                    continue;
                }
                if (couponTemplateEoList.size() != 1) continue;
                canUseCouponDefineList.add(couponTemplateEo);
            }
            List convertCouponList = couponIds.stream().map(couponId -> {
                for (CouponUseVo activityCouponUseVo : couponUseVoList) {
                    if (!couponId.equals(activityCouponUseVo.getId())) continue;
                    return activityCouponUseVo;
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            List canUseCouponList = convertCouponList.stream().filter(couponUseVo -> {
                boolean has = false;
                for (CouponTemplateEo couponDefineEo : canUseCouponDefineList) {
                    if (!couponDefineEo.getId().equals(couponUseVo.getCouponDefineId())) continue;
                    has = true;
                }
                if (has) {
                    for (CouponUseVo activityCouponUseVoTemp : couponUseVoList) {
                        if (!activityCouponUseVoTemp.getId().equals(couponUseVo.getId())) continue;
                        return true;
                    }
                }
                return false;
            }).filter(couponUseVo -> {
                if (UseSuperimposedType.YES_DIF_SAME.getKey().equals(couponUseVo.getUseSuperimposedType())) {
                    int count = 0;
                    for (CouponUseVo activityCouponUseVoTemp : convertCouponList) {
                        if (!activityCouponUseVoTemp.getCouponDefineId().equals(couponUseVo.getCouponDefineId()) || ++count <= 1) continue;
                        return false;
                    }
                }
                return true;
            }).collect(Collectors.toList());
            return canUseCouponList.stream().map(couponUseVo -> BeanCopyUtil.copyProperties(CouponRespDto.class, couponUseVo, new String[0])).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public List<Long> receiveCoupons(List<Long> couponTemplateIds, Long userId) {
        List<Long> couponIds = this.deductionQuantity(couponTemplateIds, userId, null, null);
        MQProviderHelper.publishCouponStock(couponIds);
        return couponIds;
    }

    @Override
    public List<Long> receiveCoupons(List<Long> couponTemplateIds, Long userId, Date couponEffectiveTime, Date couponInvalidTime) {
        List<Long> couponIds = this.deductionQuantity(couponTemplateIds, userId, couponEffectiveTime, couponInvalidTime);
        MQProviderHelper.publishCouponStock(couponIds);
        return couponIds;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int deductCoupon(EngineParams params) {
        Set couponIds = params.getItems().stream().map(itemVo -> {
            long couponId = itemVo.getCouponId();
            return couponId;
        }).collect(Collectors.toSet());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)params.getCouponIds())) {
            couponIds.addAll(params.getCouponIds());
        }
        couponIds.removeIf(id -> id.compareTo(0L) <= 0);
        CouponEo queryByIdsEo = CouponEo.newInstance();
        queryByIdsEo.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("id", Lists.newArrayList(couponIds)).get());
        List select = this.couponDas.select((BaseEo)queryByIdsEo);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)select)) {
            throw new ProBizException(ProExceptionCode.PARAMS_ERR.format(new String[]{"\u4f18\u60e0\u5238\u4fe1\u606f\u9519\u8bef"}));
        }
        if (couponIds.size() != select.size()) {
            Long aLong = couponIds.stream().filter(id -> select.parallelStream().noneMatch(s -> s.getId().equals(id))).findAny().orElse(0L);
            throw new ProBizException(ProExceptionCode.PARAMS_ERR.format(new String[]{"\u4f18\u60e0\u5238\u3010{}\u3011\u4e0d\u5b58\u5728", aLong.toString()}));
        }
        Date currentDate = new Date();
        for (CouponEo t : select) {
            if (CouponStatus.NOT_CONSUMED.getKey().equals(t.getCouponStatus())) continue;
            throw new ProBizException(ProExceptionCode.PARAMS_ERR.format(new String[]{"\u4f18\u60e0\u5238\u3010{}\u3011\u72b6\u6001\u9519\u8bef\uff0c\u4e0d\u53ef\u8fdb\u884c\u6d88\u8d39", t.getId() + ""}));
        }
        this.activityJoinLogService.joinInActivity(params);
        int result = this.couponDas.updateCouponStatusByUserIdAndCouponIds(Long.valueOf(params.getUserId()), (List)Lists.newLinkedList(couponIds), CouponStatus.FREEZE.getKey());
        if (result != couponIds.size()) {
            throw new ProBizException(ProExceptionCode.PARAMS_ERR.format(new String[]{"\u4f18\u60e0\u5238\u5f52\u5c5e\u5f02\u5e38"}));
        }
        return result;
    }

    @Override
    public int countByConditions(long userId, long couponTemplateId) {
        CouponEo couponEo = CouponEo.newInstance();
        couponEo.setUserId(Long.valueOf(userId));
        couponEo.setCouponTemplateId(Long.valueOf(couponTemplateId));
        return this.couponDas.count((BaseEo)couponEo);
    }

    @Override
    public CouponRespDto getCouponDetail(long id) {
        CouponEo couponEo = (CouponEo)this.couponDas.selectByPrimaryKey(Long.valueOf(id));
        if (null != couponEo) {
            CouponRespDto couponRespDto = new CouponRespDto();
            BeanUtils.copyProperties((Object)couponEo, (Object)couponRespDto);
            return couponRespDto;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deduction(List<Long> couponIds) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(couponIds)) {
            return;
        }
        CouponEo query = CouponEo.newInstance();
        query.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("id", couponIds).get());
        List select = this.couponDas.select((BaseEo)query);
        for (CouponEo couponEo : select) {
            if (null == couponEo || !CouponStatus.NEW.getKey().equals(couponEo.getCouponStatus())) continue;
            boolean result = this.couponTemplateDas.updateQuantity(couponEo.getCouponTemplateId().longValue());
            if (!result) {
                this.logger.error("\u53ef\u80fd\u5b58\u5728\u4f18\u60e0\u5238\uff1a{} \u88ab\u8fc7\u91cf\u9886\u53d6.", (Object)couponEo);
                break;
            }
            this.enableCoupon((long)couponEo.getId(), CouponStatus.NOT_CONSUMED);
        }
    }

    @Override
    public void activate(long activityId) {
        CouponTemplateEo forQuery = CouponTemplateEo.newInstance();
        forQuery.setActivityId(Long.valueOf(activityId));
        List select = this.couponTemplateDas.select((BaseEo)forQuery);
        select.forEach(eo -> {
            CouponTemplateEo couponTemplate = new CouponTemplateEo();
            couponTemplate.setId(eo.getId());
            couponTemplate.setCouponTemplateStatus(CouponTemplateStatusEnum.ACTIVATE.getStatus());
            this.couponTemplateDas.updateSelective((BaseEo)couponTemplate);
            Long remainingQuantity = eo.getRemainingQuantity();
            this.cacheService.setCache(this.generateRemainingQuantityCacheKey(eo.getId()), (Object)remainingQuantity);
        });
    }

    @Override
    public PageInfo<CouponQueryRespDto> queryByPage(CouponQueryReqDto reqDto, int pageNum, int pageSize) {
        CouponEo query = BeanCopyUtil.copyProperties(CouponEo.class, reqDto, new String[0]);
        query.setSqlFilters(SqlFilterBuilder.newInstance().buildBetweenSqlFilter("effective_time", reqDto.getEffectiveTimeBeginTime(), reqDto.getEffectiveTimeEndTime()).buildBetweenSqlFilter("invalid_time", reqDto.getInvalidTimeBeginTime(), reqDto.getInvalidTimeEndTime()).buildBetweenSqlFilter("create_time", reqDto.getCreateBeginTime(), reqDto.getCreateEndTime()).get());
        PageInfo couponEoPageInfo = this.couponDas.selectPage((BaseEo)query, Integer.valueOf(pageNum), Integer.valueOf(pageSize));
        List data = couponEoPageInfo.getList();
        couponEoPageInfo.setList(BeanCopyUtil.copyCollections(data, CouponQueryRespDto.class, new String[0]));
        return couponEoPageInfo;
    }

    @Override
    public void finish(long activityId) {
        CouponTemplateEo forQuery = CouponTemplateEo.newInstance();
        forQuery.setActivityId(Long.valueOf(activityId));
        List select = this.couponTemplateDas.select((BaseEo)forQuery);
        select.forEach(eo -> this.cacheService.delCache(this.generateRemainingQuantityCacheKey(eo.getId())));
    }

    @Transactional(rollbackFor={Exception.class})
    public List<Long> deductionQuantity(List<Long> couponTemplateIds, Long userId, Date couponEffectiveTime, Date couponInvalidTime) {
        ArrayList<Long> loadQuantityToCache = null;
        for (Long l : couponTemplateIds) {
            Long remainingQuantity = (Long)this.cacheService.getCache(this.generateRemainingQuantityCacheKey(l), Long.class);
            if (remainingQuantity != null) continue;
            if (loadQuantityToCache == null) {
                loadQuantityToCache = new ArrayList<Long>();
            }
            loadQuantityToCache.add(l);
        }
        if (!CollectionUtils.isEmpty(loadQuantityToCache)) {
            List couponTemplateEoList = this.couponTemplateDas.selectQuantitysByIds(loadQuantityToCache);
            for (CouponTemplateEo couponTemplateEo2 : couponTemplateEoList) {
                this.cacheService.setnx(this.generateRemainingQuantityCacheKey(couponTemplateEo2.getId()), String.valueOf(couponTemplateEo2.getRemainingQuantity()));
            }
        }
        ArrayList<Long> toCreateCouponTemplateIds = new ArrayList<Long>();
        for (Long couponTemplateId : couponTemplateIds) {
            Long quantity = this.cacheService.incrBy(this.generateRemainingQuantityCacheKey(couponTemplateId), -1L);
            if (quantity < 0L) {
                this.cacheService.incrBy(this.generateRemainingQuantityCacheKey(couponTemplateId), 1L);
                throw new ProBusinessRuntimeException(ProExceptionCode.STOCK_EMPTY);
            }
            toCreateCouponTemplateIds.add(couponTemplateId);
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(toCreateCouponTemplateIds)) {
            try {
                CouponTemplateEo couponTemplateEo2 = CouponTemplateEo.newInstance();
                couponTemplateEo2.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("id", toCreateCouponTemplateIds).get());
                List couponTemplateEoList = this.couponTemplateDas.select((BaseEo)couponTemplateEo2);
                List couponEos = couponTemplateEoList.stream().map(couponTemplateEo -> this.createCouponEo(userId, (CouponTemplateEo)couponTemplateEo, couponEffectiveTime, couponInvalidTime)).collect(Collectors.toList());
                if (org.apache.commons.collections.CollectionUtils.isEmpty(couponEos)) {
                    throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u9886\u53d6\u7684\u4f18\u60e0\u5238\u4e0d\u5b58\u5728"}));
                }
                this.couponDas.insertBatch(couponEos);
                List<Long> couponIds = couponEos.parallelStream().map(BaseEo::getId).collect(Collectors.toList());
                return couponIds;
            }
            catch (Exception exception) {
                Iterator iterator = toCreateCouponTemplateIds.iterator();
                while (iterator.hasNext()) {
                    long id = (Long)iterator.next();
                    this.cacheService.incrBy(this.generateRemainingQuantityCacheKey(id), 1L);
                }
                throw exception;
            }
        }
        return Lists.newLinkedList();
    }

    private CouponEo createCouponEo(Long userId, CouponTemplateEo couponTemplateEo, Date couponEffectiveTime, Date couponInvalidTime) {
        CouponEo couponEo = BeanCopyUtil.copyProperties(CouponEo.class, couponTemplateEo, new String[0]);
        couponEo.setCouponType(couponTemplateEo.getCouponType());
        couponEo.setChannel(couponTemplateEo.getChannel());
        couponEo.setUseSuperimposedType(couponTemplateEo.getUseSuperimposedType());
        couponEo.setCouponValue(couponTemplateEo.getCouponValue());
        if (couponEffectiveTime != null) {
            couponEo.setEffectiveTime(couponEffectiveTime);
        } else {
            couponEo.setEffectiveTime(couponTemplateEo.getEffectiveTime());
        }
        if (couponInvalidTime != null) {
            couponEo.setInvalidTime(couponInvalidTime);
        } else {
            couponEo.setInvalidTime(couponTemplateEo.getInvalidTime());
        }
        couponEo.setCouponStatus(CouponStatus.NEW.getKey());
        couponEo.setCouponType(couponTemplateEo.getCouponType());
        couponEo.setActivityId(couponTemplateEo.getActivityId());
        couponEo.setCouponTemplateId(couponTemplateEo.getId());
        couponEo.setItemRange(couponTemplateEo.getItemRange());
        couponEo.setSellerId(couponTemplateEo.getSellerId());
        couponEo.setShopId(couponTemplateEo.getShopId());
        couponEo.setUserId(userId);
        couponEo.setCreateTime(new Date());
        couponEo.setId(null);
        return couponEo;
    }

    private String generateRemainingQuantityCacheKey(Long couponTemplateId) {
        return "coupon_template_store_" + String.valueOf(couponTemplateId);
    }
}

