/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.crowdordering.condition;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityItemRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityItemService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountActivityDiscountCondition
extends ConditionTemplate {
    private static final Logger logger = LoggerFactory.getLogger(CountActivityDiscountCondition.class);
    @Resource
    IActivityItemService activityItemService;

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine define, ConditionRespDto conditionRespDto, T params, Map<String, ?> configParams) {
        for (ItemVo itemVo : params.getItems()) {
            ActivityItemQueryReqDto activityItemQueryReqDto = new ActivityItemQueryReqDto();
            activityItemQueryReqDto.setSkuId(Long.valueOf(itemVo.getSkuId()));
            activityItemQueryReqDto.setActivityId(Long.valueOf(params.getActivityId()));
            List<ActivityItemRespDto> activityItemRespDtos = this.activityItemService.queryActivityItem(activityItemQueryReqDto);
            if (CollectionUtils.isNotEmpty(activityItemRespDtos)) {
                ActivityItemRespDto activityItemRespDto = activityItemRespDtos.get(0);
                itemVo.setDiscountPrice(activityItemRespDto.getActivityPrice());
                itemVo.setDiscountTotalPrice(activityItemRespDto.getActivityPrice().multiply(new BigDecimal(itemVo.getNum())));
                BigDecimal skuDiscountAmount = new BigDecimal(itemVo.getNum()).multiply(itemVo.getPrice().subtract(activityItemRespDto.getActivityPrice()));
                itemVo.setPrice(activityItemRespDto.getActivityPrice());
                if (BigDecimal.ZERO.compareTo(skuDiscountAmount) >= 0) continue;
                params.setTotalDiscountAmount(params.getTotalDiscountAmount().add(skuDiscountAmount));
                continue;
            }
            throw new BizException("\u8be5\u6d3b\u52a8\u65e0\u6b64\u5546\u54c1");
        }
        return true;
    }
}

