/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.seckill.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.EnableStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.ActivityItemTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.seckill.dto.request.JoinSeckillReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.seckill.dto.request.SeckillStockQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.seckill.dto.request.SeckillStockReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.seckill.dto.response.JoinSeckillRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.seckill.enums.SeckillErrorEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityItemRuleService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.seckill.ISeckillService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityJoinLogDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityJoinLogEo;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SeckillServiceImpl
implements ISeckillService {
    private static final Logger logger = LoggerFactory.getLogger(SeckillServiceImpl.class);
    @Resource
    private IActivityItemRuleService activityItemRuleService;
    @Resource
    private ActivityJoinLogDas activityJoinLogDas;

    @Override
    public JoinSeckillRespDto joinSeckill(JoinSeckillReqDto joinSeckillReqDto) {
        ActivityJoinLogEo activityJoinLogEo = ActivityJoinLogEo.newInstance();
        ItemVo itemVo = joinSeckillReqDto.getItem();
        activityJoinLogEo.setItemId(itemVo.getItemId());
        activityJoinLogEo.setItemNum(Integer.valueOf(itemVo.getNum()));
        activityJoinLogEo.setSkuId(itemVo.getSkuId());
        activityJoinLogEo.setSourcePrice(itemVo.getPrice());
        activityJoinLogEo.setActivityId(joinSeckillReqDto.getActivityId());
        activityJoinLogEo.setStatus(EnableStatusEnum.DISABLE.getKey());
        activityJoinLogEo.setOrderCode(joinSeckillReqDto.getOrderCode());
        activityJoinLogEo.setUserId(Long.valueOf(joinSeckillReqDto.getUserId()));
        activityJoinLogEo.setCreateTime(new Date());
        activityJoinLogEo.setInstanceId(joinSeckillReqDto.getInstanceId());
        activityJoinLogEo.setTenantId(joinSeckillReqDto.getTenantId());
        activityJoinLogEo.setExtension(JSON.toJSONString((Object)itemVo.getExtendsAttribute()));
        this.activityJoinLogDas.insert((BaseEo)activityJoinLogEo);
        return new JoinSeckillRespDto();
    }

    @Override
    public void subSeckillStock(SeckillStockReqDto seckillStockReqDto) {
        boolean isSub = this.activityItemRuleService.increase(seckillStockReqDto.getActivityId(), seckillStockReqDto.getSkuId(), seckillStockReqDto.getShopId(), -seckillStockReqDto.getNum().intValue(), ActivityItemTypeEnum.ITEM, "\u6263\u51cf\u79d2\u6740\u5e93\u5b58");
        if (!isSub) {
            throw new ProBizException(SeckillErrorEnum.STOCK_NOT_ENOUGH.getMsg());
        }
    }

    @Override
    public Long querySeckillStock(SeckillStockQueryReqDto seckillStockQueryReqDto) {
        return this.activityItemRuleService.get(seckillStockQueryReqDto.getActivityId(), seckillStockQueryReqDto.getSkuId(), seckillStockQueryReqDto.getShopId(), ActivityItemTypeEnum.ITEM);
    }
}

