/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition;

import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IBizOrganizationQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.Param;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.util.CollectionUtils;

public class ShopCondition
extends ConditionTemplate {
    private static final String ACTIVITY_SHOP = "ShopCondition.shopCodes";
    private static final String ACTIVITY_SHOP_TYPE = "ShopCondition.type";

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine templateDefine, ConditionRespDto conditionRespDto, T context, Map<String, ?> configParams) {
        Param param = templateDefine.getParam(ACTIVITY_SHOP);
        if (null == param) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u5e97\u94fa\u6761\u4ef6\u672a\u914d\u7f6e"}));
        }
        List shopCodes = (List)ConditionTemplate.converter(configParams.get(ACTIVITY_SHOP), param, templateDefine.getLoadClass());
        param = templateDefine.getParam(ACTIVITY_SHOP_TYPE);
        if (null == param) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u5e97\u94fa\u5305\u542b\u6761\u4ef6\u672a\u914d\u7f6e"}));
        }
        Integer shopType = (Integer)ConditionTemplate.converter(configParams.get(ACTIVITY_SHOP_TYPE), param, templateDefine.getLoadClass());
        String contextCode = context.getShopId();
        this.handleReChange(contextCode, shopType, shopCodes);
        return true;
    }

    private void handleReChange(String contextCode, Integer shopType, List<String> shopCodes) {
        boolean result = false;
        switch (shopType) {
            case 0: {
                return;
            }
            case 1: {
                result = this.checkShopType(contextCode, "2");
                break;
            }
            case 2: {
                result = this.checkShopType(contextCode, "1");
                break;
            }
            case 3: {
                if (!shopCodes.contains(contextCode)) {
                    throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u6ca1\u6709\u5e97\u94fa\u53c2\u4e0e\u8be5\u6d3b\u52a8"}));
                }
                return;
            }
            case 4: {
                if (shopCodes.contains(contextCode)) {
                    throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u6ca1\u6709\u5e97\u94fa\u53c2\u4e0e\u8be5\u6d3b\u52a8"}));
                }
                return;
            }
            default: {
                throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u6761\u4ef6\u6a21\u677f\u5e97\u94fa\u7c7b\u578b\u6709\u8bef"}));
            }
        }
        if (!result) {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u6ca1\u6709\u5e97\u94fa\u53c2\u4e0e\u8be5\u6d3b\u52a8"}));
        }
    }

    private <T extends EngineParams> void handleComm(T context, Integer shopType, List<String> shopCodes) {
        switch (shopType) {
            case 0: {
                break;
            }
            case 1: {
                context.getItems().removeIf(itemVo -> this.checkShopType(itemVo.getShopId(), "2"));
                break;
            }
            case 2: {
                context.getItems().removeIf(itemVo -> this.checkShopType(itemVo.getShopId(), "1"));
                break;
            }
            case 3: {
                context.getItems().removeIf(itemVo -> shopCodes.stream().noneMatch(shopCode -> Objects.equals(itemVo.getShopId(), shopCode)));
                break;
            }
            case 4: {
                context.getItems().removeIf(itemVo -> shopCodes.stream().anyMatch(shopCode -> Objects.equals(itemVo.getShopId(), shopCode)));
                break;
            }
            default: {
                throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u6761\u4ef6\u6a21\u677f\u5e97\u94fa\u7c7b\u578b\u6709\u8bef"}));
            }
        }
        if (CollectionUtils.isEmpty((Collection)context.getItems())) {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u6ca1\u6709\u5e97\u94fa\u53c2\u4e0e\u8be5\u6d3b\u52a8"}));
        }
    }

    private boolean checkShopType(String shopCode, String type) {
        IBizOrganizationQueryApi bizOrganizationQueryApi = (IBizOrganizationQueryApi)SpringBeanUtil.getBean(IBizOrganizationQueryApi.class);
        List shopList = (List)bizOrganizationQueryApi.getOrganizations((List)Lists.newArrayList((Object[])new String[]{shopCode})).getData();
        if (CollectionUtils.isEmpty((Collection)shopList)) {
            return false;
        }
        OrganizationDto shopInfo = (OrganizationDto)shopList.get(0);
        return Objects.equals(shopInfo.getType(), type);
    }
}

