/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.CouponConstants;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponErrorEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateErrorEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateGenerateTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.Param;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateStockService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.DateUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.das.CouponDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponEo;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CouponReceiveLimitCondition
extends ConditionTemplate {
    private static final Logger logger = LoggerFactory.getLogger(ConditionTemplate.class);
    @Autowired
    private ICacheService cacheService;
    @Autowired
    private CouponDas couponDas;
    @Autowired
    private ICouponTemplateStockService couponTemplateStockService;
    @Autowired
    private ICouponTemplateExtQueryService couponTemplateExtQueryService;
    public static final String RECEIVE_LIMIT = "CouponReceiveLimitCondition.limit";
    public static final String RECEIVE_LIMIT_PRE_DAY = "CouponReceiveLimitCondition.dayLimit";

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine templateDefine, ConditionRespDto conditionRespDto, T context, Map<String, ?> configParams) {
        long couponTemplateId = context.getCouponTemplateId();
        long memberId = context.getUserId();
        if (Objects.nonNull(context.getOrgId())) {
            memberId = context.getOrgId();
        }
        Param param = templateDefine.getParam(RECEIVE_LIMIT);
        Param dayLimtParam = templateDefine.getParam(RECEIVE_LIMIT_PRE_DAY);
        if (null == param || dayLimtParam == null) {
            throw new ProBizException(CouponTemplateErrorEnum.ENGINE_CONFIG_ERR.getMsg());
        }
        CouponTemplateExtRespDto template = this.couponTemplateExtQueryService.queryById(couponTemplateId);
        if (null == template) {
            throw new ProBizException(CouponTemplateErrorEnum.COUPON_TEMPLATE_EXIST.getMsg());
        }
        if (!CouponTemplateStatusEnum.ACTIVATE.getStatus().equals(template.getCouponTemplateStatus())) {
            logger.error("\u4f18\u60e0\u5238\u53d1\u9001\u5931\u8d25\uff0c\u5238\u6a21\u677f\u4e3a\u975e\u6fc0\u6d3b\u72b6\u6001\uff0ctemplate\uff1a{}", JSON.toJSON((Object)template));
            throw new ProBizException(CouponTemplateErrorEnum.COUPON_TEMPLATE_NOT_ACTIVATE.getMsg());
        }
        if (null != template.getInvalidTime() && new Date().after(template.getInvalidTime())) {
            logger.error("\u4f18\u60e0\u5238\u53d1\u9001\u5931\u8d25\uff0c\u5238\u6a21\u677f\u5df2\u8fc7\u671f\uff0ctemplate\uff1a{}", JSON.toJSON((Object)template));
            throw new ProBizException(CouponTemplateErrorEnum.COUPON_TEMPLATE_IS_EXPIRE.getMsg());
        }
        if (CouponTemplateGenerateTypeEnum.IS_GENERATE.getType().equals(template.getIsGenerateCode())) {
            throw new ProBizException(CouponTemplateErrorEnum.COUPON_IS_GENERATE_TYPE.getMsg());
        }
        if (null != template.getReceiveStartTime() && new Date().before(template.getReceiveStartTime())) {
            throw new ProBizException(CouponTemplateErrorEnum.COUPON_BEFORE_RECEIVE_START_TIME.getMsg());
        }
        if (null != template.getReceiveEndTime() && new Date().after(template.getReceiveEndTime())) {
            throw new ProBizException(CouponTemplateErrorEnum.COUPON_AFTER_RECEIVE_END_TIME.getMsg());
        }
        int limit = (Integer)ConditionTemplate.converter(configParams.get(RECEIVE_LIMIT), param, templateDefine.getLoadClass());
        Integer received = this.getHasSendNum(memberId, couponTemplateId);
        if (limit != 0 && received != null && received >= limit) {
            logger.info("\u53d1\u5238\u5931\u8d25\uff0c\u9886\u5238\u5df2\u7ecf\u8fbe\u5230\u4e0a\u9650\uff0cmemberId\uff1a{}\uff0ccouponTemplateId\uff1a{}\uff0climit\uff1a{}\uff0creceived\uff1a{}", new Object[]{memberId, couponTemplateId, limit, received});
            throw new ProBizException(CouponErrorEnum.COUPON_RECEIVE_TO_MAX.getMsg());
        }
        int dayLimit = (Integer)ConditionTemplate.converter(configParams.get(RECEIVE_LIMIT_PRE_DAY), dayLimtParam, templateDefine.getLoadClass());
        Integer dayReceive = this.getHasSendNumByDay(memberId, couponTemplateId);
        if (dayLimit != 0 && dayReceive != null && dayReceive >= dayLimit) {
            logger.info("\u53d1\u5238\u5931\u8d25\uff0c\u4f1a\u5458\u6bcf\u65e5\u9886\u5238\u5df2\u7ecf\u8fbe\u5230\u4e0a\u9650\uff0cmemberId\uff1a{}\uff0ccouponTemplateId\uff1a{}\uff0cdayLimit\uff1a{}\uff0cdayReceive\uff1a{}", new Object[]{memberId, couponTemplateId, dayLimit, dayReceive});
            throw new ProBizException(CouponErrorEnum.COUPON_DAY_RECEIVE_TO_MAX.getMsg());
        }
        Long availableStock = this.couponTemplateStockService.getAvailableStock(couponTemplateId);
        if (null == availableStock || availableStock <= 0L) {
            logger.info("\u53d1\u653e\u5238\u5931\u8d25\uff0c\u5238\u5e93\u5b58\u4e0d\u8db3\uff0cmemberId\uff1a{}\uff0ccouponTemplateId\uff1a{}\uff0climit\uff1a{}\uff0cavailableStock\uff1a{}", new Object[]{memberId, couponTemplateId, limit, availableStock});
            throw new ProBizException(CouponErrorEnum.COUPON_RECEIVE_OUT.getMsg());
        }
        boolean deduction = this.couponTemplateStockService.deductionAvailableStock(couponTemplateId, CouponConstants.ONCE_SEND_NUM);
        if (!deduction) {
            logger.info("\u53d1\u653e\u5238\u5931\u8d25\uff0c\u5238\u5e93\u5b58\u4e0d\u8db3\uff0cmemberId\uff1a{}\uff0ccouponTemplateId\uff1a{}\uff0climit\uff1a{}\uff0creceived\uff1a{}", new Object[]{memberId, couponTemplateId, limit, received});
            throw new ProBizException(CouponErrorEnum.COUPON_RECEIVE_OUT.getMsg());
        }
        context.getExtendsAttribute().put("received", received);
        context.getExtendsAttribute().put("dayReceived", dayReceive);
        return true;
    }

    private Integer getHasSendNum(Long memberId, Long couponTemplateId) {
        String sendKey = "coupon_send_num_" + couponTemplateId + "_" + memberId;
        Integer hasSendNum = (Integer)this.cacheService.getCache(sendKey, Integer.class);
        if (null == hasSendNum) {
            CouponEo select = new CouponEo();
            select.setUserId(memberId);
            select.setCouponTemplateId(couponTemplateId);
            hasSendNum = this.couponDas.count((BaseEo)select);
            this.cacheService.setCache(sendKey, (Object)hasSendNum, 86400);
        }
        return hasSendNum;
    }

    private Integer getHasSendNumByDay(Long memberId, Long couponTemplateId) {
        String sendKey = "coupon_send_num_day_" + couponTemplateId + "_" + memberId;
        Integer hasSendNum = (Integer)this.cacheService.getCache(sendKey, Integer.class);
        if (null == hasSendNum) {
            Date now = new Date();
            Date startDate = DateUtil.getStartTimeOfDay(now);
            Date endDate = DateUtil.getEndTimeOfDay(now);
            CouponEo select = new CouponEo();
            List<SqlFilter> sqlFilterList = SqlFilterBuilder.newInstance().buildEqualsSqlFilter("userId", memberId).buildEqualsSqlFilter("couponTemplateId", couponTemplateId).buildBetweenSqlFilter("receiveTime", DateFormatUtils.format((Date)startDate, (String)DatePattern.DATETIME_PATTERN.getPattern()), DateFormatUtils.format((Date)endDate, (String)DatePattern.DATETIME_PATTERN.getPattern())).get();
            select.setSqlFilters(sqlFilterList);
            hasSendNum = this.couponDas.count((BaseEo)select);
            int timeInterval = (int)((endDate.getTime() - now.getTime()) / 1000L);
            this.cacheService.setCache(sendKey, (Object)hasSendNum, timeInterval);
        }
        return hasSendNum;
    }

    public static Integer parseParams(String conditionParams, String key) {
        if (StringUtils.isNotEmpty((CharSequence)conditionParams)) {
            Integer result = JSON.parseObject((String)conditionParams).getInteger(key);
            return result;
        }
        return null;
    }
}

