/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.promotion.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.SystemException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.ItemsReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizExceptionCodeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.promotion.service.IItemsService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ItemsDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.ItemsEo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="itemsService")
@Transactional(rollbackFor={Exception.class})
public class ItemsServiceImpl
implements IItemsService {
    private final Logger logger = LoggerFactory.getLogger(ItemsServiceImpl.class);
    @Resource
    private ItemsDas itemsDas;

    @Override
    public Long add(ItemsReqDto reqDto) {
        if (reqDto != null) {
            ItemsEo forInsert = new ItemsEo();
            CubeBeanUtils.copyProperties((Object)forInsert, (Object)reqDto, (String[])new String[0]);
            this.itemsDas.insertThrowException(forInsert, (BusinessRuntimeException)new SystemException(ProBizExceptionCodeEnum.ITEM_CODE_REPEAT.getCode(), ProBizExceptionCodeEnum.ITEM_CODE_REPEAT.getMsg()));
            return forInsert.getId();
        }
        return null;
    }

    @Override
    public int addBatch(List<ItemsReqDto> batchReq) {
        if (CollectionUtils.isNotEmpty(batchReq)) {
            ArrayList batch = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)batch, batchReq, ItemsEo.class);
            return this.itemsDas.insertBatchThrowException((List)batch, (BusinessRuntimeException)new SystemException(ProBizExceptionCodeEnum.ITEM_CODE_REPEAT.getCode(), ProBizExceptionCodeEnum.ITEM_CODE_REPEAT.getMsg()));
        }
        return 0;
    }

    @Override
    public void modifyById(ItemsReqDto reqDto) {
        if (reqDto.getId() == null) {
            throw new SystemException(ProBizExceptionCodeEnum.ITEM_CODE_ID.getCode(), ProBizExceptionCodeEnum.ITEM_CODE_ID.getMsg());
        }
        ItemsEo forUpd = new ItemsEo();
        CubeBeanUtils.copyProperties((Object)forUpd, (Object)reqDto, (String[])new String[0]);
        this.itemsDas.updateSelectiveThrowException(forUpd, (BusinessRuntimeException)new SystemException(ProBizExceptionCodeEnum.ITEM_CODE_REPEAT.getCode(), ProBizExceptionCodeEnum.ITEM_CODE_REPEAT.getMsg()));
    }

    @Override
    public void modifyByCode(ItemsReqDto reqDto) {
        if (reqDto == null || StringUtils.isEmpty((CharSequence)reqDto.getCode())) {
            throw new SystemException(ProBizExceptionCodeEnum.ITEM_CODE_EMPTY.getCode(), ProBizExceptionCodeEnum.ITEM_CODE_EMPTY.getMsg());
        }
        ItemsEo source = this.itemsDas.selectByCode(reqDto.getCode());
        if (source == null) {
            throw new SystemException(ProBizExceptionCodeEnum.ITEM_NOT_EXIST.getCode(), ProBizExceptionCodeEnum.ITEM_NOT_EXIST.getMsg());
        }
        ItemsEo forUpd = new ItemsEo();
        CubeBeanUtils.copyProperties((Object)forUpd, (Object)reqDto, (String[])new String[0]);
        forUpd.setId(source.getId());
        this.itemsDas.updateSelectiveThrowException(forUpd, (BusinessRuntimeException)new SystemException(ProBizExceptionCodeEnum.ITEM_CODE_REPEAT.getCode(), ProBizExceptionCodeEnum.ITEM_CODE_REPEAT.getMsg()));
    }

    @Override
    public void modifyBatchByCode(List<ItemsReqDto> batchReq) {
        if (CollectionUtils.isNotEmpty(batchReq)) {
            batchReq.forEach(this::modifyByCode);
        }
    }

    @Override
    public void saveOrUpdateById(ItemsReqDto reqDto) {
        if (reqDto != null) {
            if (reqDto.getId() == null) {
                this.add(reqDto);
            } else {
                this.modifyById(reqDto);
            }
        }
    }

    @Override
    public void saveOrUpdateBatchById(List<ItemsReqDto> batchReq) {
        if (CollectionUtils.isNotEmpty(batchReq)) {
            ArrayList forInsert = Lists.newArrayList();
            batchReq.forEach(a -> {
                if (a.getId() != null) {
                    this.modifyById((ItemsReqDto)a);
                } else {
                    forInsert.add(a);
                }
            });
            this.addBatch(forInsert);
        }
    }

    @Override
    public void saveOrUpdateByCode(ItemsReqDto reqDto) {
        if (reqDto != null && StringUtils.isNotEmpty((CharSequence)reqDto.getCode())) {
            ItemsEo itemsEo = this.itemsDas.selectByCode(reqDto.getCode());
            if (itemsEo == null) {
                this.add(reqDto);
            } else {
                this.modifyByCode(reqDto);
            }
        }
    }

    @Override
    public void saveOrUpdateBatchByCode(List<ItemsReqDto> batchReq) {
        if (CollectionUtils.isNotEmpty(batchReq)) {
            ArrayList forInsert = Lists.newArrayList();
            batchReq.forEach(a -> {
                if (StringUtils.isEmpty((CharSequence)a.getCode())) {
                    throw new SystemException(ProBizExceptionCodeEnum.ITEM_CODE_EMPTY.getCode(), ProBizExceptionCodeEnum.ITEM_CODE_EMPTY.getMsg());
                }
                ItemsEo itemsEo = this.itemsDas.selectByCode(a.getCode());
                if (itemsEo == null) {
                    forInsert.add(a);
                } else {
                    this.logger.info("\u4fee\u6539\u5546\u54c1\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)a));
                    this.modifyByCode((ItemsReqDto)a);
                }
            });
            this.logger.info("\u65b0\u589e\u5546\u54c1\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)forInsert));
            this.addBatch(forInsert);
        }
    }

    @Override
    public void deleteByIds(List<Long> ids) {
        if (CollectionUtils.isNotEmpty(ids)) {
            ids.forEach(arg_0 -> ((ItemsDas)this.itemsDas).deleteById(arg_0));
        }
    }

    @Override
    public void deleteByCode(List<String> codes) {
        if (CollectionUtils.isNotEmpty(codes)) {
            codes.forEach(arg_0 -> ((ItemsDas)this.itemsDas).deleteByCode(arg_0));
        }
    }
}

