/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.tag.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.ItemSkuDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ConditionTemplateRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.seckill.model.SeckillItem;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.timediscount.model.TimeDisActItem;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.tag.service.IItemActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IConditionService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IConditionTemplateService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ItemConditionTemplate;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class ItemActivityServiceImpl
implements IItemActivityService {
    private Logger logger = LoggerFactory.getLogger(ItemActivityServiceImpl.class);
    @Autowired
    private IActivityService activityService;
    @Autowired
    private IConditionService conditionService;
    @Autowired
    private IConditionTemplateService conditionTemplateService;

    @Override
    @Cacheable(value={"itemApplyActivityCache"}, key="#itemId+'_'+#skuId+'_'+#activityId+'_'+#shopId")
    public boolean apply(Long itemId, @Nullable Long skuId, Long activityId, Long shopId) {
        ActivityRespDto activityDto = this.activityService.getActivity(activityId);
        ConditionReqDto reqDto = new ConditionReqDto();
        reqDto.setActivityId(activityId);
        List<Long> templateIdList = activityDto.getConditionDtos().stream().map(ConditionRespDto::getConditionTemplateId).collect(Collectors.toList());
        List<ConditionTemplateRespDto> conditionTemplateDtoList = this.conditionTemplateService.queryConditionTemplateBatch(templateIdList);
        for (ConditionTemplateRespDto conditionTemplateDto : conditionTemplateDtoList) {
            String conditionDefine = conditionTemplateDto.getConditionDefine();
            TemplateDefine define = (TemplateDefine)JSON.parseObject((String)conditionDefine, TemplateDefine.class);
            ItemConditionTemplate itemConditionTemplate = this.getItemCondition(conditionTemplateDto);
            if (!Objects.nonNull(itemConditionTemplate)) continue;
            for (ConditionRespDto conditionDto : activityDto.getConditionDtos()) {
                if (!conditionDto.getConditionTemplateId().equals(conditionTemplateDto.getId())) continue;
                try {
                    ItemVo itemVo = new ItemVo();
                    itemVo.setShopId(shopId.toString());
                    itemVo.setItemId(itemId.toString());
                    itemVo.setSkuId(skuId == null ? null : skuId.toString());
                    if (itemConditionTemplate.apply(define, conditionDto, itemVo)) continue;
                    return false;
                }
                catch (Exception e) {
                    this.logger.error("\u5224\u65ad\u5546\u54c1\u662f\u5426\u6ee1\u8db3\u7684\u6d3b\u52a8\u4f7f\u7528\u8303\u56f4\u51fa\u73b0\u5f02\u5e38 conditionId={},itemId={},shopId={}", new Object[]{conditionTemplateDto.getId(), itemId, shopId, e});
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Cacheable(value={"itemSkuActivityPriceCache"}, key="#itemId+'_'+#skuId+'_'+#activityId+'_'+#shopId", unless="#result == null")
    public ItemSkuDto queryItemSkuActivityPrice(Long itemId, @Nullable Long skuId, Long activityId, Long shopId) {
        Integer promotionMethod;
        List conditionItems;
        JSONObject jsonObject;
        ActivityRespDto activityDto = this.activityService.getActivity(activityId);
        List conditionRespDtos = activityDto.getConditionDtos();
        Long timeConditionTemplateId = 1196944771412880281L;
        Long secConditionTemplateId = 1196944771412880286L;
        ConditionRespDto timeDiscountCondition = null;
        ConditionRespDto secKillCondition = null;
        for (ConditionRespDto condition : conditionRespDtos) {
            if (timeConditionTemplateId.equals(condition.getConditionTemplateId())) {
                timeDiscountCondition = condition;
                break;
            }
            if (!secConditionTemplateId.equals(condition.getConditionTemplateId())) continue;
            secKillCondition = condition;
            break;
        }
        String shopSkuStr = shopId + "_" + skuId;
        if (Objects.nonNull(timeDiscountCondition)) {
            jsonObject = JSON.parseObject((String)timeDiscountCondition.getConditionParams());
            conditionItems = JSONArray.parseArray((String)jsonObject.getString("ItemTimeLimitCondition.items"), TimeDisActItem.class);
            promotionMethod = jsonObject.getInteger("ItemTimeLimitCondition.promotionMethod");
            for (TimeDisActItem conditionItem : conditionItems) {
                if (!shopSkuStr.equals(conditionItem.getShopId() + "_" + conditionItem.getSkuId())) continue;
                ItemSkuDto itemSkuDto = new ItemSkuDto();
                itemSkuDto.setItemId(itemId);
                itemSkuDto.setSkuId(skuId);
                itemSkuDto.setShopId(shopId);
                itemSkuDto.setActivityId(activityId);
                itemSkuDto.setActivityPrice(conditionItem.getActivityPrice());
                itemSkuDto.setDiscount(conditionItem.getDiscount());
                itemSkuDto.setPromotionMethod(promotionMethod);
                itemSkuDto.setActivityTemplateId(activityDto.getActivityTemplateId());
                return itemSkuDto;
            }
        }
        if (Objects.nonNull(secKillCondition)) {
            jsonObject = JSON.parseObject((String)secKillCondition.getConditionParams());
            conditionItems = JSONArray.parseArray((String)jsonObject.getString("SeckillItemCondition.items"), SeckillItem.class);
            promotionMethod = jsonObject.getInteger("SeckillItemCondition.promotionMethod");
            for (TimeDisActItem conditionItem : conditionItems) {
                if (!shopSkuStr.equals(conditionItem.getShopId() + "_" + conditionItem.getSkuId())) continue;
                ItemSkuDto itemSkuDto = new ItemSkuDto();
                itemSkuDto.setItemId(itemId);
                itemSkuDto.setSkuId(skuId);
                itemSkuDto.setShopId(shopId);
                itemSkuDto.setActivityId(activityId);
                itemSkuDto.setActivityPrice(conditionItem.getActivityPrice());
                itemSkuDto.setDiscount(conditionItem.getDiscount());
                itemSkuDto.setPromotionMethod(promotionMethod);
                itemSkuDto.setActivityTemplateId(activityDto.getActivityTemplateId());
                return itemSkuDto;
            }
        }
        return null;
    }

    private ItemConditionTemplate getItemCondition(ConditionTemplateRespDto conditionTemplateDto) {
        ConditionTemplate conditionTemplate = ConditionTemplate.getCondition(conditionTemplateDto);
        if (conditionTemplate instanceof ItemConditionTemplate) {
            return (ItemConditionTemplate)conditionTemplate;
        }
        return null;
    }
}

