/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.tag.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.api.ISearchIndexService;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.IndexDocContentVo;
import com.dtyunxi.huieryun.opensearch.vo.IndexDocumentVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchConditionVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.huieryun.opensearch.vo.SortFieldVo;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DirItemRelativeReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemShelfQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.TargetCustomerSimpleDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ExchangeSingleItemEsDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ConditionTemplateRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.BizActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.SupportSingleBuyEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.constants.SingleItemConstants;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.request.ActivityItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.model.ExcRuleContentDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.model.ExchangeRule;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.query.IActivityExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.tag.service.IItemActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.tag.service.IItemActivityTagService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IConditionService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IConditionTemplateService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.coupon.service.ICouponTemplateService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ItemConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.timediscount.condition.ItemTimeLimitCondition;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.SpringContextHelper;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ConditionDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ConditionEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.StdConditionEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponTemplateEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.client.utils.DateUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.stereotype.Service;

@Service
public class ItemActivityTagServiceImpl
implements IItemActivityTagService {
    private static Logger logger = LoggerFactory.getLogger(ItemActivityTagServiceImpl.class);
    private static final Long EXCHANGE_CUSTOMER_CONDITION_TEMPID = 1196944771412880293L;
    private static final Long EXCHANGE_MALL_CONDITION_TEMPID = 5196944771412880296L;
    private static final Long EXCHANGE_ITEM_CONDITION_TEMPID = 1196944771412880296L;
    private static final String EXCHANGECONDITION_RULE = "ExchangeCondition.rule";
    private static final String TARGETCUSTOMERCONDITION_VALUE = "TargetCustomerCondition.value";
    private static final String TARGETMALLCONDITION_MALLTYPES = "TargetMallCondition.mallTypes";
    @Resource
    private ISearchIndexService searchIndexService;
    @Resource
    private IOpenSearchService openSearchService;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IActivityService activityService;
    @Resource
    private IConditionTemplateService conditionTemplateService;
    @Resource
    private IItemActivityService itemActivityService;
    @Autowired
    private IConditionService conditionService;
    @Resource
    private IActivityExtQueryService activityExtQueryService;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private ICouponTemplateService couponTemplateService;
    @Resource
    private IItemSkuQueryApi itemSkuQueryApi;
    @Autowired
    private ConditionDas conditionDas;
    private static final String INDEX_ITEM_ACTIVITY_TAG = "item_activity_tag_";
    private static final String INDEX_TYPE_NAME = "item";
    @Value(value="${cube.global.profile:}")
    private String globalProfile;
    @Value(value="${single.item.delay.item: 5}")
    private long singleItemDelayTime;
    @Resource
    private ICommonsMqService commonsMqService;
    private static final DefaultConversionService CONVERSION_SERVICE = new DefaultConversionService();

    @Override
    public void addItemActivityTag(List<ItemActivityTagDto> itemActivityTags) {
        if (CollectionUtils.isEmpty(itemActivityTags)) {
            logger.info("\u4fdd\u5b58\u6d3b\u52a8\u6807\u7b7e\u6210\u529f\u6570\u91cf\uff1a0");
            return;
        }
        IndexDocumentVo documentVo = new IndexDocumentVo(INDEX_ITEM_ACTIVITY_TAG + this.globalProfile, INDEX_TYPE_NAME);
        List<IndexDocContentVo> contents = this.getIndexDocContents(itemActivityTags);
        documentVo.setContents(contents);
        this.searchIndexService.addData(documentVo);
        logger.info("\u4fdd\u5b58\u6d3b\u52a8\u6807\u7b7e\u6210\u529f\u6570\u91cf\uff1a{}", (Object)itemActivityTags.size());
    }

    private List<IndexDocContentVo> getIndexDocContents(List<ItemActivityTagDto> itemActivityTags) {
        ArrayList contents = Lists.newArrayList();
        itemActivityTags.forEach(itemActivityTagDto -> {
            String id = Optional.ofNullable(itemActivityTagDto.getId()).orElse(IdGenrator.getDistributedId() + "");
            IndexDocContentVo contentVo = new IndexDocContentVo();
            itemActivityTagDto.setId(id);
            Map docValueMap = ObjectHelper.bean2Map((Object)itemActivityTagDto);
            contentVo.setIndexId(id);
            contentVo.setDocValueMap(docValueMap);
            contents.add(contentVo);
        });
        return contents;
    }

    private List<IndexDocContentVo> getExchangeItemIndexDocContents(List<ExchangeSingleItemEsDto> singleItemEsDtos) {
        ArrayList contents = Lists.newArrayList();
        singleItemEsDtos.forEach(itemActivityTagDto -> {
            String id = this.getIndexId();
            IndexDocContentVo contentVo = new IndexDocContentVo();
            itemActivityTagDto.setId(id);
            Map docValueMap = ObjectHelper.bean2Map((Object)itemActivityTagDto);
            contentVo.setIndexId(id);
            contentVo.setDocValueMap(docValueMap);
            contents.add(contentVo);
        });
        return contents;
    }

    private String getIndexId() {
        return IdGenrator.getDistributedId() + "";
    }

    @Override
    public void deleteItemActivityTag(Long itemId, Long shopId) {
        ItemActivityTagQueryReqDto queryReqDto = new ItemActivityTagQueryReqDto();
        queryReqDto.setItemId(itemId);
        queryReqDto.setShopId(shopId);
        this.delete(queryReqDto);
    }

    @Override
    public PageInfo<ItemActivityTagDto> queryByPage(ItemActivityTagQueryReqDto itemActivityTagQueryReqDto, Integer pageNum, Integer pageSize) {
        OSSearchVo osSearchVo = this.buildOSSearchVo(itemActivityTagQueryReqDto);
        osSearchVo.setPage(pageNum.intValue());
        osSearchVo.setPageSize(pageSize.intValue());
        SearchResultVo searchResultVo = this.openSearchService.search(osSearchVo);
        if (searchResultVo == null) {
            return new PageInfo();
        }
        List<ItemActivityTagDto> list = this.convert(searchResultVo.getDocValues());
        PageInfo pageInfo = new PageInfo();
        pageInfo.setList(list);
        pageInfo.setTotal(searchResultVo.getTotalSize());
        pageInfo.setPages(searchResultVo.getTotalPageNum().intValue());
        pageInfo.setPageNum(pageNum.intValue());
        pageInfo.setPageSize(pageSize.intValue());
        return pageInfo;
    }

    @Override
    public void saveItemActivityTag(Long itemId, Long shopId, Long activityId) {
        ActivityRespDto activityRespDto = this.activityService.getById(activityId);
        if (null == itemId || activityId == null) {
            throw new ProBizException("\u5546\u54c1id\u548c\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList tagDtos = Lists.newArrayList();
        ItemActivityTagDto tagDto = this.getItemActivityTagDto(itemId, shopId, activityRespDto);
        tagDtos.add(tagDto);
        this.addItemActivityTag(tagDtos);
    }

    @Override
    public List<ActivityItemDto> getActivityItems(Long activityId) {
        ActivityRespDto activityRespDto = this.activityService.getById(activityId);
        if (null == activityRespDto) {
            return Collections.emptyList();
        }
        logger.info("\u83b7\u53d6\u6d3b\u52a8\u9002\u7528\u7684\u5546\u54c1\u5217\u8868, activityId:{}", (Object)activityId);
        ConditionReqDto reqDto = new ConditionReqDto();
        reqDto.setActivityId(activityId);
        List<ConditionRespDto> conditionDtos = this.conditionService.queryConditionList(reqDto);
        List<Long> templateIdList = conditionDtos.stream().map(ConditionRespDto::getConditionTemplateId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(templateIdList)) {
            logger.warn("\u67e5\u8be2\u6761\u4ef6\u5b9e\u4f8b\u5217\u8868\u4e3a\u7a7a\uff01");
            return Collections.emptyList();
        }
        List<ConditionTemplateRespDto> conditionTemplateDtos = this.conditionTemplateService.queryConditionTemplateBatch(templateIdList);
        HashSet items = Sets.newHashSet();
        int i = 0;
        for (ConditionTemplateRespDto conditionTemplateDto : conditionTemplateDtos) {
            String conditionDefine = conditionTemplateDto.getConditionDefine();
            TemplateDefine define = (TemplateDefine)JSON.parseObject((String)conditionDefine, TemplateDefine.class);
            ItemConditionTemplate itemConditionTemplate = this.getItemCondition(conditionTemplateDto);
            if (!Objects.nonNull(itemConditionTemplate)) continue;
            for (ConditionRespDto conditionDto : conditionDtos) {
                if (!conditionDto.getConditionTemplateId().equals(conditionTemplateDto.getId())) continue;
                Set<ActivityItemDto> batchItems = itemConditionTemplate.getItems(define, conditionDto, (Map)JSON.parseObject((String)conditionDto.getConditionParams(), Map.class));
                if (i == 0) {
                    items.addAll(batchItems);
                    continue;
                }
                items.retainAll(batchItems);
            }
            ++i;
        }
        logger.info("\u6d3b\u52a8\u9002\u7528\u7684\u5546\u54c1\u6570\u91cf\uff1a{}", (Object)items.size());
        return items.stream().collect(Collectors.toList());
    }

    private ItemConditionTemplate getItemCondition(ConditionTemplateRespDto conditionTemplateDto) {
        String conditionDefine = conditionTemplateDto.getConditionDefine();
        TemplateDefine conditionTemplateDefine = (TemplateDefine)JSON.parseObject((String)conditionDefine, TemplateDefine.class);
        String loadClass = conditionTemplateDefine.getLoadClass();
        Class<?> clazz = null;
        try {
            clazz = Class.forName(loadClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        if (!ItemConditionTemplate.class.isAssignableFrom(clazz)) {
            return null;
        }
        return (ItemConditionTemplate)SpringContextHelper.getBean(clazz);
    }

    @Override
    public void saveItemActivityTagByActivityId(Long activityId) {
        ActivityRespDto activityRespDto = this.activityService.getById(activityId);
        ArrayList tagDtos = Lists.newArrayList();
        List<ActivityItemDto> items = this.getActivityItems(activityId);
        logger.info("\u6839\u636e\u6d3b\u52a8id\u4fdd\u5b58\u5546\u54c1\u6d3b\u52a8\u6807\u7b7e,\u5546\u54c1\u6570\u91cf:{}", (Object)items.size());
        items.forEach(itemDto -> {
            ItemActivityTagDto tagDto = this.getItemActivityTagDto(itemDto.getItemId(), itemDto.getShopId(), activityRespDto);
            tagDtos.add(tagDto);
        });
        this.addItemActivityTag(tagDtos);
        if (ActivityStatusEnum.READY.getKey().equals(activityRespDto.getActivityStatus())) {
            logger.info("[\u6362\u8d2d\u5546\u54c1\u540c\u6b65\u6d3b\u52a8\u72b6\u6001mq\u6d88\u606f],\u5f00\u59cb\u53d1\u9001:{}", (Object)activityId);
            MessageResponse messageResponse = this.commonsMqService.sendDelaySingleMessage("change_single_item_activity_status_tag", (Object)activityId, Long.valueOf(this.singleItemDelayTime));
            logger.info("[\u6362\u8d2d\u5546\u54c1\u540c\u6b65\u6d3b\u52a8\u72b6\u6001mq\u6d88\u606f],\u53d1\u9001\u6210\u529f:{}", (Object)JSON.toJSONString((Object)messageResponse));
        }
    }

    @Override
    public void saveSingleItemByActivity(Long activityId) {
        ActivityRespDto activityRespDto = this.activityService.getActivity(activityId);
        if (!SingleItemConstants.SUPPORT_ACTIVITY_TYPE.contains(activityRespDto.getActivityTemplateId())) {
            return;
        }
        logger.info("[\u4fdd\u5b58\u6362\u8d2d\u5546\u54c1]\uff0c\u6d3b\u52a8ID\uff1a{}", (Object)activityId);
        this.deleteSingleItem(activityId);
        List<ExchangeSingleItemEsDto> singleItemEsDtos = this.getExchangeEsItems(activityId, activityRespDto);
        logger.info("[\u4e0d\u652f\u6301\u5355\u72ec\u8d2d\u4e70\u5546\u54c1]\uff1a{}", (Object)JSON.toJSONString(singleItemEsDtos));
        this.addExchangeItemEs(singleItemEsDtos);
    }

    private void addExchangeItemEs(List<ExchangeSingleItemEsDto> singleItemEsDtos) {
        if (CollectionUtils.isEmpty(singleItemEsDtos)) {
            logger.info("\u4fdd\u5b58\u6362\u8d2d\u6d3b\u52a8\u6362\u8d2d\u5546\u54c1\u4ec5\u652f\u6301\u5355\u72ec\u8d2d\u4e70\u6210\u529f\u6570\u91cf\uff1a0");
            return;
        }
        IndexDocumentVo documentVo = new IndexDocumentVo("single_buy_item_" + this.globalProfile, "exchange_item");
        List<IndexDocContentVo> contents = this.getExchangeItemIndexDocContents(singleItemEsDtos);
        documentVo.setContents(contents);
        this.searchIndexService.addData(documentVo);
        logger.info("\u4fdd\u5b58\u6d3b\u52a8\u6807\u7b7e\u6210\u529f\u6570\u91cf\uff1a{}", (Object)singleItemEsDtos.size());
    }

    public List<ExchangeSingleItemEsDto> getExchangeEsItems(Long activityId, ActivityRespDto activityRespDto) {
        if (activityRespDto == null) {
            activityRespDto = this.activityService.getActivity(activityId);
        }
        Integer selectCustomer = activityRespDto.getSelectCustomer();
        ConditionEo conditionEo = new ConditionEo();
        conditionEo.setActivityId(activityId);
        List conditionEos = this.conditionDas.select((BaseEo)conditionEo);
        ArrayList singleItems = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)conditionEos)) {
            ConditionEo exchangeCond;
            JSONObject jsonObject;
            ExchangeRule exchangeRule;
            List exchangeSingleItems;
            Map<Long, ConditionEo> conditionMap = conditionEos.stream().collect(Collectors.toMap(StdConditionEo::getConditionTemplateId, e -> e, (e1, e2) -> e1));
            ConditionEo customerCond = conditionMap.get(EXCHANGE_CUSTOMER_CONDITION_TEMPID);
            JSONObject customerConditionObj = JSON.parseObject((String)customerCond.getConditionParams());
            TargetCustomerSimpleDto targetCustomerSimpleDto = (TargetCustomerSimpleDto)JSON.parseObject((String)customerConditionObj.getString(TARGETCUSTOMERCONDITION_VALUE), TargetCustomerSimpleDto.class);
            List customerIds = targetCustomerSimpleDto.getCustomerIds();
            List customerTypeIds = targetCustomerSimpleDto.getCustomerTypeIds();
            List blackCustomerIds = targetCustomerSimpleDto.getBlackCustomerIds();
            List customerAreaCodes = targetCustomerSimpleDto.getCustomerAreaCodes();
            List subAreaCodes = targetCustomerSimpleDto.getSubAreaCodes();
            if (CollectionUtils.isNotEmpty((Collection)customerAreaCodes) && CollectionUtils.isNotEmpty((Collection)subAreaCodes)) {
                customerAreaCodes.addAll(subAreaCodes);
            }
            ConditionEo mallCond = conditionMap.get(EXCHANGE_MALL_CONDITION_TEMPID);
            JSONObject mallObj = JSON.parseObject((String)mallCond.getConditionParams());
            List mallTypes = (List)JSON.parseObject((String)mallObj.getString(TARGETMALLCONDITION_MALLTYPES), ArrayList.class);
            List<Long> conditionTpIds = activityRespDto.getConditionDtos().stream().map(ConditionRespDto::getConditionTemplateId).collect(Collectors.toList());
            List<ConditionTemplateRespDto> conditionTpDtos = this.conditionTemplateService.queryConditionTemplateBatch(conditionTpIds);
            logger.info("[\u4e0d\u652f\u6301\u5355\u72ec\u8d2d\u4e70\u5546\u54c1]\uff0cactivityId\uff1a{}", (Object)activityId);
            ActivityRespDto finalActivityRespDto = activityRespDto;
            if (SingleItemConstants.SUPPORT_APPLY_ITEM_ACTIVITY.contains(activityRespDto.getActivityTemplateId())) {
                ExchangeSingleItemEsDto baseSingleItem = new ExchangeSingleItemEsDto();
                baseSingleItem.setActivityId(activityId);
                baseSingleItem.setActivityStatus(activityRespDto.getActivityStatus());
                baseSingleItem.setActivityTemplateId(activityRespDto.getActivityTemplateId());
                baseSingleItem.setSelectCustomer(selectCustomer);
                baseSingleItem.setCustomerAreaCodes(customerAreaCodes);
                baseSingleItem.setCustomerIds(customerIds);
                baseSingleItem.setCustomerTypeIds(customerTypeIds);
                baseSingleItem.setBlackCustomerIds(blackCustomerIds);
                baseSingleItem.setMallTypes(mallTypes);
                baseSingleItem.setOrganizationId(activityRespDto.getOrganizationId());
                baseSingleItem.setShopName(activityRespDto.getOrganizationName());
                conditionTpDtos.forEach(conditionTpDto -> {
                    for (ConditionRespDto conditionDto : finalActivityRespDto.getConditionDtos()) {
                        ConditionTemplate conditionTemplate;
                        if (!conditionDto.getConditionTemplateId().equals(conditionTpDto.getId()) || !((conditionTemplate = ConditionTemplate.getCondition(conditionTpDto)) instanceof ItemTimeLimitCondition)) continue;
                        JSONObject activityParams = JSON.parseObject((String)conditionDto.getConditionParams());
                        ItemTimeLimitCondition itemConditionTemplate = (ItemTimeLimitCondition)conditionTemplate;
                        TemplateDefine define = (TemplateDefine)JSON.parseObject((String)conditionTpDto.getConditionDefine(), TemplateDefine.class);
                        List<ExchangeSingleItemEsDto> singleItemEsDtos = itemConditionTemplate.pareSingleItems(define, baseSingleItem, conditionDto, (Map<String, ?>)activityParams);
                        if (!CollectionUtils.isNotEmpty(singleItemEsDtos)) continue;
                        singleItems.addAll(singleItemEsDtos);
                    }
                });
            }
            if (Objects.equals(finalActivityRespDto.getActivityTemplateId(), BizActivityType.EXCHANGE_ACTIVITY.getId()) && CollectionUtils.isNotEmpty(exchangeSingleItems = ((ExcRuleContentDto)(exchangeRule = (ExchangeRule)JSON.parseObject((String)(jsonObject = JSON.parseObject((String)(exchangeCond = conditionMap.get(EXCHANGE_ITEM_CONDITION_TEMPID)).getConditionParams())).getString(EXCHANGECONDITION_RULE), ExchangeRule.class)).getExcRuleContents().get(0)).getExchangeItems().stream().map(item -> {
                ExchangeSingleItemEsDto singleItemEsDto = new ExchangeSingleItemEsDto();
                BeanUtils.copyProperties((Object)item, (Object)singleItemEsDto);
                singleItemEsDto.setActivityId(activityId);
                singleItemEsDto.setActivityStatus(finalActivityRespDto.getActivityStatus());
                singleItemEsDto.setActivityTemplateId(finalActivityRespDto.getActivityTemplateId());
                singleItemEsDto.setSelectCustomer(selectCustomer);
                singleItemEsDto.setCustomerAreaCodes(customerAreaCodes);
                singleItemEsDto.setCustomerIds(customerIds);
                singleItemEsDto.setCustomerTypeIds(customerTypeIds);
                singleItemEsDto.setBlackCustomerIds(blackCustomerIds);
                singleItemEsDto.setMallTypes(mallTypes);
                singleItemEsDto.setOrganizationId(finalActivityRespDto.getOrganizationId());
                return singleItemEsDto;
            }).collect(Collectors.toList()))) {
                singleItems.addAll(exchangeSingleItems);
            }
        }
        return singleItems;
    }

    public static void main(String[] args) {
        JSONObject itemLimit = JSON.parseObject((String)"{\"ItemTimeLimitCondition.items\":[{\"itemCode\":\"AA160105\",\"itemId\":1288931292510022463,\"itemName\":\"life.space\u76ca\u751f\u83cc\u7c89\uff0820\u888b\uff09\",\"price\":111,\"shopId\":1293894494667982871,\"skuId\":1288931292528896833},{\"itemCode\":\"AA160105D\",\"itemId\":1288931269102660305,\"itemName\":\"life.space\u76ca\u751f\u83cc\u7c89\uff0848\u888b\uff09\u793c\u76d2\u88c5\",\"price\":99999.9,\"shopId\":1293894494667982871,\"skuId\":1288931269122583251}],\"ItemTimeLimitCondition.sellerIds\":[],\"ItemTimeLimitCondition.type\":1}");
        List comItemDtos = (List)JSON.parseObject((String)itemLimit.getString("ItemTimeLimitCondition.items"), ArrayList.class);
        System.out.println(JSON.toJSONString((Object)comItemDtos));
    }

    private ItemActivityTagDto getItemActivityTagDto(Long itemId, Long shopId, ActivityRespDto activityRespDto) {
        CouponTemplateEo couponTemplateEo;
        ItemActivityTagDto itemActivityTagDto = new ItemActivityTagDto();
        itemActivityTagDto.setActivityId(activityRespDto.getId());
        itemActivityTagDto.setItemId(itemId);
        itemActivityTagDto.setActivityTag(activityRespDto.getTag());
        itemActivityTagDto.setEndTime(activityRespDto.getEndTime());
        itemActivityTagDto.setWeight(activityRespDto.getActivityTemplate().getWeight());
        itemActivityTagDto.setDimension(activityRespDto.getActivityTemplate().getDimension());
        itemActivityTagDto.setCreateTime(activityRespDto.getCreateTime());
        itemActivityTagDto.setInstanceId(activityRespDto.getInstanceId());
        itemActivityTagDto.setTenantId(activityRespDto.getTenantId());
        itemActivityTagDto.setShopId(shopId);
        itemActivityTagDto.setDisplay(Integer.valueOf(1));
        if (null == activityRespDto.getPreheatStartTime()) {
            itemActivityTagDto.setPreheatStartTime(activityRespDto.getBeginTime());
        } else {
            itemActivityTagDto.setPreheatStartTime(activityRespDto.getPreheatStartTime());
        }
        if (null != activityRespDto.getActivityTemplateId() && activityRespDto.getActivityTemplateId().equals(ActivityType.COUPON_ACTIVITY.getId()) && null != (couponTemplateEo = this.couponTemplateService.queryByActivityId(activityRespDto.getId())) && CouponTypeEnum.COUPON_PUSHED.getType().equals(couponTemplateEo.getCouponType())) {
            itemActivityTagDto.setDisplay(Integer.valueOf(0));
        }
        return itemActivityTagDto;
    }

    @Override
    public void saveItemActivityTagByItemId(Long itemId, Long shopId) {
        if (Objects.isNull(itemId)) {
            logger.info("\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u4e0d\u6dfb\u52a0\u5546\u54c1\u6d3b\u52a8\u6807\u7b7e\uff0citemId={}", (Object)itemId);
            return;
        }
        ArrayList tagDtos = Lists.newArrayList();
        ShopDto shopDto = (ShopDto)this.shopQueryApi.queryById(shopId.longValue(), new String[0]).getData();
        if (null == shopDto) {
            logger.info("\u5e97\u94fa\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u4e0d\u6dfb\u52a0\u5546\u54c1\u6d3b\u52a8\u6807\u7b7e\uff0cshopId={}", (Object)shopId);
            return;
        }
        List itemSkuRespDtos = (List)this.itemSkuQueryApi.queryByItemId(itemId).getData();
        Long skuId = null;
        if (CollectionUtils.isNotEmpty((Collection)itemSkuRespDtos)) {
            skuId = ((ItemSkuRespDto)itemSkuRespDtos.get(0)).getId();
        }
        ActivityQueryReqDto queryReqDto = new ActivityQueryReqDto();
        queryReqDto.setInstanceId(shopDto.getInstanceId());
        queryReqDto.setTenantId(shopDto.getTenantId());
        queryReqDto.setShopId(shopId);
        queryReqDto.setActivityStatusList((List)Lists.newArrayList((Object[])new String[]{ActivityStatusEnum.ACTIVATE.getKey(), ActivityStatusEnum.READY.getKey()}));
        List<ActivityRespDto> activityRespDtos = this.activityExtQueryService.queryActivityList(queryReqDto);
        Long finalSkuId = skuId;
        activityRespDtos.forEach(activityRespDto -> {
            boolean applicable = this.itemActivityService.apply(itemId, finalSkuId, activityRespDto.getId(), shopId);
            if (applicable) {
                ItemActivityTagDto tagDto = this.getItemActivityTagDto(itemId, shopId, (ActivityRespDto)activityRespDto);
                tagDtos.add(tagDto);
            }
        });
        this.addItemActivityTag(tagDtos);
    }

    @Override
    public List<ItemActivityTagDto> queryList(ItemActivityTagQueryReqDto itemActivityTagQueryReqDto) {
        ArrayList list = Lists.newArrayList();
        OSSearchVo osSearchVo = this.buildOSSearchVo(itemActivityTagQueryReqDto);
        osSearchVo.setPage(1);
        osSearchVo.setPageSize(1000);
        SearchResultVo searchResultVo = this.openSearchService.search(osSearchVo);
        if (null == searchResultVo) {
            return list;
        }
        list.addAll(this.convert(searchResultVo.getDocValues()));
        int i = 2;
        while ((long)i <= searchResultVo.getTotalPageNum()) {
            osSearchVo.setPage(i);
            osSearchVo.setPageSize(1000);
            SearchResultVo pageResult = this.openSearchService.search(osSearchVo);
            list.addAll(this.convert(pageResult.getDocValues()));
            ++i;
        }
        return list;
    }

    private OSSearchVo buildOSSearchVo(ItemActivityTagQueryReqDto queryReqDto) {
        String[] values;
        OSSearchVo osSearchVo = new OSSearchVo();
        osSearchVo.setIndexName(INDEX_ITEM_ACTIVITY_TAG + this.globalProfile);
        osSearchVo.setTypeName(INDEX_TYPE_NAME);
        if (null != queryReqDto.getDisplay()) {
            osSearchVo.addEqualFilter("display", queryReqDto.getDisplay().toString());
        }
        if (null != queryReqDto.getActivityId()) {
            osSearchVo.addEqualFilter("activityId", queryReqDto.getActivityId().toString());
        }
        if (null != queryReqDto.getCustomerId()) {
            osSearchVo.addEqualFilter("customerId", queryReqDto.getCustomerId().toString());
        }
        if (null != queryReqDto.getShopId()) {
            osSearchVo.addEqualFilter("shopId", queryReqDto.getShopId().toString());
        }
        if (null != queryReqDto.getItemId()) {
            osSearchVo.addEqualFilter("itemId", queryReqDto.getItemId().toString());
        }
        if (null != queryReqDto.getActivityTag()) {
            osSearchVo.addQuery("activityTag", new String[]{queryReqDto.getActivityTag()});
        }
        if (null != queryReqDto.getTenantId()) {
            osSearchVo.addEqualFilter("tenantId", String.valueOf(queryReqDto.getTenantId()));
        }
        if (null != queryReqDto.getInstanceId()) {
            osSearchVo.addEqualFilter("instanceId", String.valueOf(queryReqDto.getInstanceId()));
        }
        if (null != queryReqDto.getDimension()) {
            osSearchVo.addEqualFilter("dimension", queryReqDto.getDimension().toString());
        }
        if (null != queryReqDto.getPreheatStartTime()) {
            Date preheatStartTime = DateUtil.addHour((Date)queryReqDto.getPreheatStartTime(), (int)8);
            osSearchVo.addRangeFilter("preheatStartTime", null, DateUtils.formatDate((Date)preheatStartTime, (String)"YYYY-MM-dd'T'HH:mm:ss"));
        }
        if (CollectionUtils.isNotEmpty((Collection)queryReqDto.getDimensionList())) {
            values = (String[])queryReqDto.getDimensionList().stream().map(String::valueOf).toArray(String[]::new);
            osSearchVo.addInFilter("dimension", values);
        }
        if (CollectionUtils.isNotEmpty((Collection)queryReqDto.getItemIdList())) {
            values = (String[])queryReqDto.getItemIdList().stream().map(String::valueOf).toArray(String[]::new);
            osSearchVo.addInFilter("itemId", values);
        }
        if (CollectionUtils.isNotEmpty((Collection)queryReqDto.getShopIdList())) {
            values = (String[])queryReqDto.getShopIdList().stream().map(String::valueOf).toArray(String[]::new);
            osSearchVo.addInFilter("shopId", values);
        }
        if (CollectionUtils.isNotEmpty((Collection)queryReqDto.getActivityIdList())) {
            values = (String[])queryReqDto.getActivityIdList().stream().map(String::valueOf).toArray(String[]::new);
            osSearchVo.addInFilter("activityId", values);
        }
        ArrayList sortFields = Lists.newArrayList();
        if (SortOrder.ASC.name().equals(queryReqDto.getOrderByWeight())) {
            sortFields.add(SortFieldVo.build((String)"weight", (SortOrder)SortOrder.ASC));
        } else {
            sortFields.add(SortFieldVo.build((String)"weight", (SortOrder)SortOrder.DESC));
        }
        sortFields.add(SortFieldVo.build((String)"createTime", (SortOrder)SortOrder.DESC));
        osSearchVo.setSortFields((List)sortFields);
        return osSearchVo;
    }

    private List<ItemActivityTagDto> convert(List<Map<String, Object>> docValues) {
        if (CollectionUtils.isEmpty(docValues)) {
            return Collections.EMPTY_LIST;
        }
        List<ItemActivityTagDto> tagDtos = docValues.stream().map(doc -> {
            Object endTime;
            Object createTime;
            ItemActivityTagDto dto = new ItemActivityTagDto();
            dto.setId((String)CONVERSION_SERVICE.convert(doc.get("id"), String.class));
            dto.setActivityId((Long)CONVERSION_SERVICE.convert(doc.get("activityId"), Long.class));
            dto.setActivityTag((String)CONVERSION_SERVICE.convert(doc.get("activityTag"), String.class));
            dto.setWeight((Integer)CONVERSION_SERVICE.convert(doc.get("weight"), Integer.class));
            dto.setDimension((Integer)CONVERSION_SERVICE.convert(doc.get("dimension"), Integer.class));
            dto.setItemId((Long)CONVERSION_SERVICE.convert(doc.get("itemId"), Long.class));
            dto.setShopId((Long)CONVERSION_SERVICE.convert(doc.get("shopId"), Long.class));
            Object preheatStartTime = doc.get("preheatStartTime");
            if (null != preheatStartTime) {
                dto.setPreheatStartTime(DateTime.parse((String)preheatStartTime.toString()).toDate());
            }
            if (null != (createTime = doc.get("createTime"))) {
                dto.setCreateTime(DateTime.parse((String)createTime.toString()).toDate());
            }
            if (null != (endTime = doc.get("endTime"))) {
                dto.setEndTime(DateTime.parse((String)endTime.toString()).toDate());
            }
            return dto;
        }).collect(Collectors.toList());
        return tagDtos;
    }

    @Override
    public Set<ActivityItemDto> queryItems(ItemShelfQueryReqDto queryReqDto) {
        queryReqDto.setItemStatus(ItemStatus.ITEM_ONSHELF.getStatus());
        Set<Object> items = Sets.newHashSet();
        if (CollectionUtils.isEmpty((Collection)queryReqDto.getDirIds())) {
            this.queryShelfItemByPage(queryReqDto, items);
        } else {
            DirItemRelativeReqDto relativeReqDto = new DirItemRelativeReqDto();
            relativeReqDto.setDirIds(queryReqDto.getDirIds());
            List dirItems = (List)this.itemQueryApi.queryItemDirRelative(JSON.toJSONString((Object)relativeReqDto)).getData();
            if (CollectionUtils.isNotEmpty((Collection)dirItems)) {
                items = dirItems.stream().map(dirItem -> new ActivityItemDto(dirItem.getShopId(), dirItem.getItemId())).collect(Collectors.toSet());
            }
        }
        return items;
    }

    @Override
    public Set<ActivityItemDto> queryItemsForB2b(ItemShelfQueryReqDto queryReqDto) {
        queryReqDto.setItemStatus(ItemStatus.ITEM_ONSHELF.getStatus());
        HashSet items = Sets.newHashSet();
        this.queryShelfItemByPage(queryReqDto, items);
        return items;
    }

    @Override
    public List<ExchangeSingleItemEsDto> queryExchangeItemByShopId(Long shopId, SupportSingleBuyEnum supportType) {
        if (shopId == null) {
            return Lists.newArrayList();
        }
        OSSearchVo osSearchVo = new OSSearchVo();
        osSearchVo.setIndexName("single_buy_item_" + this.globalProfile);
        osSearchVo.setTypeName("exchange_item");
        osSearchVo.addEqualFilter("shopId", String.valueOf(shopId));
        if (supportType != null) {
            osSearchVo.addEqualFilter("supportSingleBuy", String.valueOf(supportType.getKey()));
        }
        osSearchVo.setPage(1);
        osSearchVo.setPageSize(1000);
        SearchResultVo searchResultVo = this.openSearchService.search(osSearchVo);
        if (null == searchResultVo) {
            return Lists.newArrayList();
        }
        ArrayList list = Lists.newArrayList();
        list.addAll(this.convertExchangeItem(searchResultVo.getDocValues()));
        int i = 2;
        while ((long)i <= searchResultVo.getTotalPageNum()) {
            osSearchVo.setPage(i);
            osSearchVo.setPageSize(1000);
            SearchResultVo pageResult = this.openSearchService.search(osSearchVo);
            list.addAll(this.convertExchangeItem(pageResult.getDocValues()));
            ++i;
        }
        return list;
    }

    private List<ExchangeSingleItemEsDto> convertExchangeItem(List<Map<String, Object>> docValues) {
        if (CollectionUtils.isEmpty(docValues)) {
            return Lists.newArrayList();
        }
        List<ExchangeSingleItemEsDto> notSupportSingleItemDtos = docValues.stream().map(doc -> {
            ExchangeSingleItemEsDto notSupportSingleItemDto = new ExchangeSingleItemEsDto();
            notSupportSingleItemDto.setItemId((Long)CONVERSION_SERVICE.convert(doc.get("itemId"), Long.class));
            notSupportSingleItemDto.setActivityId((Long)CONVERSION_SERVICE.convert(doc.get("activityId"), Long.class));
            notSupportSingleItemDto.setShopId((Long)CONVERSION_SERVICE.convert(doc.get("shopId"), Long.class));
            notSupportSingleItemDto.setSupportSingleBuy((Integer)CONVERSION_SERVICE.convert(doc.get("supportSingleBuy"), Integer.class));
            return notSupportSingleItemDto;
        }).collect(Collectors.toList());
        return notSupportSingleItemDtos;
    }

    private void queryShelfItemByPage(ItemShelfQueryReqDto queryReqDto, Set<ActivityItemDto> items) {
        PageInfo pageInfo;
        int pageNum = 1;
        do {
            if (this.isNotEmpty(pageInfo = (PageInfo)this.itemQueryApi.queryShelfItemByPage(queryReqDto, Integer.valueOf(pageNum), Integer.valueOf(1000)).getData()).booleanValue()) {
                List list = pageInfo.getList().stream().map(shelfDto -> {
                    ActivityItemDto activityItemDto = new ActivityItemDto();
                    activityItemDto.setShopId(shelfDto.getShopId());
                    activityItemDto.setItemId(shelfDto.getItemId());
                    return activityItemDto;
                }).collect(Collectors.toList());
                items.addAll(list);
            }
            ++pageNum;
        } while (this.isNotEmpty(pageInfo).booleanValue());
    }

    private <T> Boolean isNotEmpty(PageInfo<T> pageInfo) {
        return null != pageInfo && CollectionUtils.isNotEmpty((Collection)pageInfo.getList());
    }

    @Override
    public void deleteItemActivityTag(Long activityId) {
        ItemActivityTagQueryReqDto queryReqDto = new ItemActivityTagQueryReqDto();
        queryReqDto.setActivityId(activityId);
        this.delete(queryReqDto);
    }

    @Override
    public void deleteSingleItem(Long activityId) {
        logger.info("[\u5220\u9664\u4e0d\u652f\u6301\u5355\u72ec\u8d2d\u4e70\u5546\u54c1\u4fe1\u606f]\uff1a{}", (Object)activityId);
        SearchConditionVo searchConditionVo = new SearchConditionVo("single_buy_item_" + this.globalProfile, "exchange_item");
        ArrayList list = Lists.newArrayList();
        list.add(FilterFieldVo.equal((String)"activityId", (String)String.valueOf(activityId)));
        searchConditionVo.setFilterFields((List)list);
        this.searchIndexService.deleteDataByCondition(searchConditionVo);
    }

    private void delete(ItemActivityTagQueryReqDto queryReqDto) {
        if (null == queryReqDto.getShopId() && null == queryReqDto.getItemId() && null == queryReqDto.getActivityId() && null == queryReqDto.getId()) {
            logger.info("\u5fc5\u8981\u53c2\u6570\u7f3a\u5931\u5220\u9664\u5931\u8d25\uff0cqueryReqDto={}", (Object)JSON.toJSONString((Object)queryReqDto));
            return;
        }
        List<ItemActivityTagDto> tagDtoList = this.queryList(queryReqDto);
        if (CollectionUtils.isEmpty(tagDtoList)) {
            logger.info("activityId={},shopId={},itemId={}\u5546\u54c1\u65e0\u6d3b\u52a8\u6807\u7b7e\u4e0d\u7528\u5220\u9664", new Object[]{queryReqDto.getActivityId(), queryReqDto.getShopId(), queryReqDto.getItemId()});
            return;
        }
        SearchConditionVo searchConditionVo = new SearchConditionVo(INDEX_ITEM_ACTIVITY_TAG + this.globalProfile, INDEX_TYPE_NAME);
        ArrayList list = Lists.newArrayList();
        list.add(FilterFieldVo.equal((String)"activityId", (String)String.valueOf(queryReqDto.getActivityId())));
        searchConditionVo.setFilterFields((List)list);
        this.searchIndexService.deleteDataByCondition(searchConditionVo);
        logger.info("activityId={},shopId={},itemId={}\u5546\u54c1\u5220\u9664\u6d3b\u52a8\u6807\u7b7e\u6570\u91cf:{}", new Object[]{queryReqDto.getActivityId(), queryReqDto.getShopId(), queryReqDto.getItemId(), tagDtoList.size()});
    }
}

