/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBusinessRuntimeException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IConditionService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IConditionTemplateService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.BeanCopyUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ConditionDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ConditionEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ConditionTemplateEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ConditionServiceImpl
implements IConditionService {
    @Autowired
    private ConditionDas conditionDas;
    @Autowired
    private IConditionTemplateService conditionTemplateService;

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Long addCondition(ConditionReqDto dto) {
        ConditionEo eo = new ConditionEo();
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)eo);
        this.conditionDas.insert((BaseEo)eo);
        return eo.getId();
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void modifyCondition(ConditionReqDto dto) {
        ConditionEo eo = new ConditionEo();
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)eo);
        if (eo.getId() == null) {
            throw new ProBusinessRuntimeException(ProExceptionCode.RECORD_NOT_EXIST);
        }
        this.conditionDas.updateSelective((BaseEo)eo);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void deleteCondition(Long tId) {
        this.conditionDas.logicDeleteById(tId);
    }

    @Override
    public List<ConditionRespDto> queryConditionListByActivitys(List<Long> activityId, Long conditionTemplateId) {
        ConditionEo eo = new ConditionEo();
        if (conditionTemplateId != null) {
            eo.setConditionTemplateId(conditionTemplateId);
        }
        eo.setSqlFilters(Arrays.asList(SqlFilter.in((String)"activity_id", activityId)));
        List eoList = this.conditionDas.select((BaseEo)eo);
        ArrayList<ConditionRespDto> dtoList = new ArrayList<ConditionRespDto>();
        CubeBeanUtils.copyCollection(dtoList, (Collection)eoList, ConditionRespDto.class);
        return dtoList;
    }

    @Override
    public List<ConditionRespDto> queryConditionList(ConditionReqDto dto) {
        ConditionEo eo = this.getConditionEo(dto);
        List eoList = this.conditionDas.select((BaseEo)eo);
        ArrayList<ConditionRespDto> dtoList = new ArrayList<ConditionRespDto>();
        CubeBeanUtils.copyCollection(dtoList, (Collection)eoList, ConditionRespDto.class);
        return dtoList;
    }

    @Override
    @Cacheable(key="'cache_condition_list_' +  #activityId", value={"conditionListCache"}, unless="#result == null || #result.size()==0 ")
    public List<ConditionRespDto> queryConditionListByActivityId(Long activityId) {
        ConditionReqDto dto = new ConditionReqDto();
        dto.setActivityId(activityId);
        return this.queryConditionList(dto);
    }

    @Override
    @CacheEvict(key="'cache_condition_list_' +  #activityId", value={"conditionListCache"})
    public void clearConditionListByActivityId(Long activityId) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void insertConditionBatch(Long activityId, long activityTemplateId, List<ConditionReqDto> conditions) {
        if (!CollectionUtils.isEmpty(conditions)) {
            Collection<? extends ConditionTemplateEo> conditionTemplateEos = this.conditionTemplateService.queryByAcTemplateId(activityTemplateId);
            conditionTemplateEos.forEach(template -> {
                TemplateDefine conditionTemplateDefine = (TemplateDefine)JSON.parseObject((String)template.getConditionDefine(), TemplateDefine.class);
                ConditionReqDto matchDto = conditions.stream().filter(condition -> condition.getConditionTemplateId().equals(template.getId())).findAny().orElse(null);
                String params = "{}";
                if (null != matchDto) {
                    params = matchDto.getConditionParams();
                }
                ConditionTemplate.validateConfigParams(conditionTemplateDefine, params);
            });
            List<ConditionEo> conditionEoList = BeanCopyUtil.copyCollections(conditions, ConditionEo.class, new String[0]);
            conditionEoList.forEach(c -> {
                c.setActivityId(activityId);
                c.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
                c.setTenantId(ServiceContext.getContext().getRequestTenantId());
            });
            this.conditionDas.insertBatch(conditionEoList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyCondition(ConditionEo conditionEo) {
        if (null != conditionEo.getId()) {
            this.conditionDas.update((BaseEo)conditionEo);
        } else {
            this.conditionDas.updateSelective((BaseEo)conditionEo);
        }
    }

    @Override
    public void deleteByActivityId(long activity) {
        ConditionEo eo = new ConditionEo();
        eo.setActivityId(Long.valueOf(activity));
        this.conditionDas.delete((BaseEo)eo);
    }

    @Override
    public PageInfo<ConditionRespDto> queryConditionPage(ConditionReqDto reqDto, Integer pageNum, Integer pageSize) {
        this.checkBase(ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        ConditionEo eo = this.getConditionEo(reqDto);
        PageInfo pageInfo = this.conditionDas.selectPage((BaseEo)eo, pageNum, pageSize);
        ArrayList respDtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), respDtoList, ConditionRespDto.class);
        pageInfo.setList(respDtoList);
        return pageInfo;
    }

    private ConditionEo getConditionEo(ConditionReqDto reqDto) {
        ConditionEo eo = new ConditionEo();
        CubeBeanUtils.copyProperties((Object)eo, (Object)reqDto, (String[])new String[0]);
        eo.setSqlFilters(SqlFilterBuilder.newInstance().buildBetweenSqlFilter("create_time", reqDto.getCreateStartTime(), reqDto.getCreateEndTime()).get());
        return eo;
    }

    private void checkBase(Long instanceId, Long tenantId) {
    }
}

