/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionTemplateQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionTemplateReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ConditionTemplateRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.utils.ExpressionParser;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IConditionTemplateService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.ITriggerService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.BatchOperationUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.BeanCopyUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ConditionTemplateDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ConditionTemplateEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.TriggerEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ConditionTemplateServiceImpl
implements IConditionTemplateService {
    @Autowired
    private ConditionTemplateDas conditionTemplateDas;
    @Autowired
    private ITriggerService triggerService;

    @Override
    public Long addCondition(ConditionTemplateReqDto dto) {
        ConditionTemplateEo eo = BeanCopyUtil.copyProperties(ConditionTemplateEo.class, dto, new String[0]);
        eo.setConditionDefine(JSON.toJSONString((Object)dto.getConditionDefineDto()));
        this.conditionTemplateDas.insert((BaseEo)eo);
        return eo.getId();
    }

    @Override
    public void modifyCondition(Long id, ConditionTemplateReqDto dto) {
        ConditionTemplateEo eo = BeanCopyUtil.copyProperties(ConditionTemplateEo.class, dto, new String[0]);
        eo.setConditionDefine(JSON.toJSONString((Object)dto.getConditionDefineDto()));
        eo.setId(id);
        this.conditionTemplateDas.update((BaseEo)eo);
    }

    @Override
    public void deleteCondition(long ctId) {
        this.conditionTemplateDas.logicDeleteById(Long.valueOf(ctId));
    }

    @Override
    public Collection<ConditionTemplateRespDto> queryByRules(Set<Long> ruleIds) {
        LinkedList dtos = Lists.newLinkedList();
        BatchOperationUtil.batchQuery(ruleIds, d -> {
            Collection result = this.conditionTemplateDas.selectByRuleIds(d);
            dtos.addAll(BeanCopyUtil.copyCollections(result, ConditionTemplateRespDto.class, new String[0]));
        });
        return dtos;
    }

    @Override
    public List<ConditionTemplateRespDto> queryConditionTemplateBatch(List<Long> ids) {
        ArrayList dtos = Lists.newArrayList();
        ConditionTemplateEo eo = ConditionTemplateEo.newInstance();
        ArrayList sqlFilters = Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"id", ids)});
        eo.setSqlFilters((List)sqlFilters);
        List conditionTemplateEos = this.conditionTemplateDas.select((BaseEo)eo);
        CubeBeanUtils.copyCollection((Collection)dtos, (Collection)conditionTemplateEos, ConditionTemplateRespDto.class);
        return dtos;
    }

    @Override
    public ConditionTemplateRespDto queryById(Long id) {
        this.checkBase(ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        ConditionTemplateEo eo = this.checkById(id, ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        ConditionTemplateRespDto dto = new ConditionTemplateRespDto();
        CubeBeanUtils.copyProperties((Object)dto, (Object)eo, (String[])new String[0]);
        return dto;
    }

    @Override
    public List<ConditionTemplateRespDto> querActionTemplateList(ConditionTemplateQueryReqDto conditionTemplateQueryReqDto) {
        this.checkBase(ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        ConditionTemplateEo actionTemplateEo = ConditionTemplateEo.newInstance();
        CubeBeanUtils.copyProperties((Object)actionTemplateEo, (Object)conditionTemplateQueryReqDto, (String[])new String[0]);
        actionTemplateEo.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        actionTemplateEo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        this.setQueryTimeConditions(actionTemplateEo, conditionTemplateQueryReqDto.getCreateStartTime(), conditionTemplateQueryReqDto.getCreateEndTime());
        List actionTemplateEoList = this.conditionTemplateDas.select((BaseEo)actionTemplateEo);
        ArrayList<ConditionTemplateRespDto> actionTemplateRespDtoList = new ArrayList<ConditionTemplateRespDto>();
        CubeBeanUtils.copyCollection(actionTemplateRespDtoList, (Collection)actionTemplateEoList, ConditionTemplateRespDto.class);
        return actionTemplateRespDtoList;
    }

    @Override
    public PageInfo<ConditionTemplateRespDto> queryConditionTemplatePage(ConditionTemplateQueryReqDto conditionTemplateQueryReqDto, Integer pageNum, Integer pageSize) {
        this.checkBase(ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        ConditionTemplateEo eo = ConditionTemplateEo.newInstance();
        CubeBeanUtils.copyProperties((Object)eo, (Object)conditionTemplateQueryReqDto, (String[])new String[0]);
        eo.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        eo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        this.setQueryTimeConditions(eo, conditionTemplateQueryReqDto.getCreateStartTime(), conditionTemplateQueryReqDto.getCreateEndTime());
        PageInfo activityTemplateEoPageInfo = this.conditionTemplateDas.selectPage((BaseEo)eo, pageNum, pageSize);
        ArrayList conditionTemplateRespDtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)activityTemplateEoPageInfo.getList(), conditionTemplateRespDtoList, ConditionTemplateRespDto.class);
        activityTemplateEoPageInfo.setList(conditionTemplateRespDtoList);
        return activityTemplateEoPageInfo;
    }

    @Override
    public Collection<? extends ConditionTemplateEo> queryByAcTemplateId(long acTemplateId) {
        Collection<TriggerEo> triggerEos = this.triggerService.queryByAcTemplateId(acTemplateId);
        if (CollectionUtils.isEmpty(triggerEos)) {
            return Lists.newLinkedList();
        }
        Set ruleIds = triggerEos.parallelStream().flatMap(eo -> ExpressionParser.extractCondition((String)eo.getTriggerExpression()).stream()).collect(Collectors.toSet());
        return this.conditionTemplateDas.selectByRuleIds((List)Lists.newLinkedList(ruleIds));
    }

    private void checkBase(Long instanceId, Long tenantId) {
    }

    private void setQueryTimeConditions(ConditionTemplateEo eo, String startTime, String endTime) {
        ArrayList<SqlFilter> sqlFilterList = eo.getSqlFilters();
        if (StringUtils.isNotEmpty((CharSequence)startTime)) {
            if (sqlFilterList == null) {
                sqlFilterList = new ArrayList<SqlFilter>();
            }
            sqlFilterList.add(SqlFilter.gt((String)"create_time", (Object)startTime));
        }
        if (StringUtils.isNotEmpty((CharSequence)endTime)) {
            if (sqlFilterList == null) {
                sqlFilterList = new ArrayList();
            }
            sqlFilterList.add(SqlFilter.lt((String)"create_time", (Object)endTime));
        }
        eo.setSqlFilters(sqlFilterList);
    }

    private ConditionTemplateEo checkById(Long id, Long instanceId, Long tenantId) {
        ConditionTemplateEo actionTemplateEo = (ConditionTemplateEo)this.conditionTemplateDas.selectByPrimaryKey(id);
        return actionTemplateEo;
    }
}

