/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.crowdordering.condition;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.request.ActivityItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.Param;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ItemConditionTemplate;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class GroupItemsCondition
extends ItemConditionTemplate {
    private static final String CONFIG_PARAM_KEY_ITEMS = "GroupItemsCondition.items";

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine define, ConditionRespDto conditionRespDto, T context, Map<String, ?> configParams) {
        Param param = define.getParam(CONFIG_PARAM_KEY_ITEMS);
        if (null == param) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u9002\u7528\u5546\u54c1\u5236\u672a\u914d\u7f6e"}));
        }
        List items = (List)ConditionTemplate.converter(configParams.get(CONFIG_PARAM_KEY_ITEMS), param, define.getLoadClass());
        return true;
    }

    @Override
    public boolean apply(TemplateDefine define, ConditionRespDto conditionRespDto, ItemVo itemVo) {
        Map configParams = (Map)JSON.parseObject((String)conditionRespDto.getConditionParams(), Map.class);
        Param param = define.getParam(CONFIG_PARAM_KEY_ITEMS);
        List items = (List)ConditionTemplate.converter(configParams.get(CONFIG_PARAM_KEY_ITEMS), param, define.getLoadClass());
        if (CollectionUtils.isEmpty((Collection)items)) {
            return false;
        }
        return items.stream().anyMatch(groupItem -> {
            String target = itemVo.getItemId();
            String source = groupItem.getItemId().toString();
            if (null != itemVo.getSkuId()) {
                target = target + itemVo.getSkuId();
                source = source + groupItem.getSkuId();
            }
            return target.equals(source);
        });
    }

    @Override
    public Set<ActivityItemDto> getItems(TemplateDefine define, ConditionRespDto conditionRespDto, Map<String, ?> configParams) {
        Param param = define.getParam(CONFIG_PARAM_KEY_ITEMS);
        List items = (List)ConditionTemplate.converter(configParams.get(CONFIG_PARAM_KEY_ITEMS), param, define.getLoadClass());
        if (CollectionUtils.isEmpty((Collection)items)) {
            return Sets.newHashSet();
        }
        return items.stream().map(groupActivityItem -> {
            ActivityItemDto activityItemDto = new ActivityItemDto();
            activityItemDto.setItemId(groupActivityItem.getItemId());
            activityItemDto.setShopId(groupActivityItem.getShopId());
            return activityItemDto;
        }).collect(Collectors.toSet());
    }
}

