/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.apiimpl.query;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.biz.commons.annotation.ExcelColumnProperty;
import com.dtyunxi.cube.biz.commons.constants.OssConstant;
import com.dtyunxi.cube.biz.commons.utils.ExecutorUtils;
import com.dtyunxi.cube.biz.commons.utils.Object2FilterUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponTemplateExtReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponValidityTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.apiimpl.query.CouponExtQueryApiImpl;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateExtQueryService;
import com.dtyunxi.yundt.imarketing.commons.enums.EsIndexEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service(value="couponEsQueryApi")
public class CouponEsQueryApiImpl
extends CouponExtQueryApiImpl {
    private static Logger logger = LoggerFactory.getLogger(CouponEsQueryApiImpl.class);
    @Value(value="${huieryun.searchindexbuilder.indexname.prefix}")
    private String esPrefix;
    @Resource
    private IObjectStorageService objectStorageService;
    @Resource
    private ICouponTemplateExtQueryService couponTemplateExtQueryService;
    @Resource
    private IOpenSearchService openSearchService;
    @Resource
    private ICacheService cacheService;

    @Override
    public RestResponse<List<String>> exportCoupon(CouponReqDto couponReqDto) {
        logger.info("\u4f18\u60e0\u5238\u5bfc\u51fa\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)couponReqDto));
        String fileName = "Coupon_number_data_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss") + new Random().nextInt(100) + ".csv";
        ExecutorUtils.execute(() -> {
            logger.info("\u5f02\u6b65\u5bfc\u51fa\u5238\u6570\u636e...");
            List<CouponExtRespDto> list = this.searchData(couponReqDto);
            logger.info("\u4f18\u60e0\u5238\u5bfc\u51fa\u67e5\u8be2\u5b8c\u6bd5\uff0c\u603b\u5171\uff1a{}\u6761\u6570\u636e", (Object)list.size());
            String data = "";
            try {
                data = this.processData(list);
            }
            catch (Exception e) {
                logger.error("\u7ec4\u88c5\u6570\u636e\u51fa\u73b0\u5f02\u5e38=={}", (Throwable)e);
                throw new BizException("\u67e5\u8be2\u6570\u636e\u51fa\u73b0\u5f02\u5e38");
            }
            list.clear();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data.getBytes(Charset.forName("GB2312")));
            logger.info("Excel\u6587\u4ef6\uff1a{}\u5f00\u59cb\u4e0a\u4f20\u5230oss\u670d\u52a1\u5668...", (Object)fileName);
            String downloadUrl = null;
            try {
                downloadUrl = this.objectStorageService.put(OssConstant.BUCKET_NAME, fileName, (InputStream)inputStream);
            }
            catch (Exception e) {
                logger.error("\u5bfc\u51fa\u5238\u4e0a\u4f20oss\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
                throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u5bfc\u51fa\u5238\u4e0a\u4f20oss\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c"}));
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    logger.error("\u5173\u95ed\u6d41\u51fa\u73b0\u5f02\u5e38");
                }
            }
            logger.info("Excel\u4e0a\u4f20\u5230oss\u670d\u52a1\u5668\u5b8c\u6bd5,\u4e0b\u8f7d\u94fe\u63a5\uff1a{},\u5bfc\u51fa\u5165\u53c2\uff1a{}", (Object)downloadUrl, (Object)JSON.toJSONString((Object)couponReqDto));
        });
        ArrayList<String> returnUrls = new ArrayList<String>();
        String downloadUrl = this.objectStorageService.getFileUrl(fileName);
        logger.info("\u4e0b\u8f7dExcel\u94fe\u63a5\uff1a{}", (Object)downloadUrl);
        returnUrls.add(downloadUrl);
        return new RestResponse(returnUrls);
    }

    public RestResponse<Boolean> checkExportCoupon(String fileName) {
        boolean exists = this.objectStorageService.exists(OssConstant.BUCKET_NAME, fileName);
        return new RestResponse((Object)exists);
    }

    private static List<String> getTitles(Object object) {
        Class<?> clazz = object.getClass();
        Field[] fields = clazz.getDeclaredFields();
        TreeMap<Integer, String> columnMap = new TreeMap<Integer, String>();
        Field[] var4 = fields;
        int var5 = fields.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            Field field = var4[var6];
            field.setAccessible(true);
            try {
                String property = field.getName();
                new PropertyDescriptor(field.getName(), clazz);
                ExcelColumnProperty excelColumnProperty = field.getAnnotation(ExcelColumnProperty.class);
                if (excelColumnProperty == null) continue;
                columnMap.put(excelColumnProperty.index(), excelColumnProperty.columnName());
                continue;
            }
            catch (Exception var11) {
                var11.printStackTrace();
            }
        }
        return new ArrayList<String>(columnMap.values());
    }

    private String processData(List<CouponExtRespDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u6ca1\u6709\u4efb\u4f55\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e"}));
        }
        List<String> titles = CouponEsQueryApiImpl.getTitles(list.get(0));
        StringBuilder sb = new StringBuilder();
        int titleLength = titles.size();
        for (int i = 0; i < titleLength; ++i) {
            if (i == titleLength - 1) {
                sb.append(titles.get(i)).append("\n");
                continue;
            }
            sb.append(titles.get(i)).append(",");
        }
        logger.info("\u5f00\u59cb\u67e5\u8be2\u4f18\u60e0\u5238\u6a21\u677fbegin");
        List<Long> couponTemplateIds = list.stream().map(CouponExtRespDto::getCouponTemplateId).distinct().collect(Collectors.toList());
        logger.info("\u67e5\u8be2\u51fa\u6a21\u677f\u603b\u6570\uff1a{}", (Object)couponTemplateIds.size());
        HashMap<Long, CouponTemplateExtRespDto> longCouponTemplateExtRespDtoMap = new HashMap<Long, CouponTemplateExtRespDto>();
        int templateCount = 0;
        ArrayList<Long> tempIds = new ArrayList<Long>();
        for (Long couponId : couponTemplateIds) {
            Map<Long, CouponTemplateExtRespDto> eachMap;
            tempIds.add(couponId);
            if (++templateCount != 500 && templateCount != couponTemplateIds.size() || null == (eachMap = this.couponTemplateExtQueryService.listByIds2Map(couponTemplateIds)) || eachMap.size() <= 0) continue;
            longCouponTemplateExtRespDtoMap.putAll(eachMap);
        }
        couponTemplateIds.clear();
        logger.info("\u5f00\u59cb\u67e5\u8be2\u4f18\u60e0\u5238\u6a21\u677fend");
        logger.info("\u5f00\u59cb\u67e5\u8be2\u4f1a\u5458\u4fe1\u606fbegin");
        List userIds = list.stream().filter(couponExtRespDto -> !couponExtRespDto.getUserId().toString().startsWith("1000000")).map(couponExtRespDto -> couponExtRespDto.getUserId().toString()).distinct().collect(Collectors.toList());
        HashMap<String, String> phoneMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(userIds)) {
            ArrayList<String> batchIds = new ArrayList<String>();
            int count = 0;
            int total = 0;
            for (String memberid : userIds) {
                batchIds.add(memberid);
                if (++count < 1000 && ++total != userIds.size()) continue;
                OSSearchVo memberSearchVo = new OSSearchVo();
                memberSearchVo.setPage(1);
                memberSearchVo.setPageSize(batchIds.size());
                memberSearchVo.setIndexName(this.esPrefix + "_" + EsIndexEnum.MEMBER.getIndexName());
                memberSearchVo.setTypeName(EsIndexEnum.MEMBER.getTypeName());
                memberSearchVo.addInFilter("id", batchIds.toArray(new String[0]));
                SearchResultVo memberSearch = this.openSearchService.search(memberSearchVo);
                if (null != memberSearch && CollectionUtils.isNotEmpty((Collection)memberSearch.getDocValues())) {
                    List docValues = memberSearch.getDocValues();
                    for (Map map : docValues) {
                        String id = map.get("id").toString();
                        String phone = (String)map.get("phone");
                        if (!StringUtils.isNotBlank((CharSequence)phone)) continue;
                        phoneMap.put(id, phone);
                    }
                }
                batchIds.clear();
                count = 0;
                try {
                    Thread.sleep(500L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        logger.info("\u5f00\u59cb\u67e5\u8be2\u4f1a\u5458\u4fe1\u606fend");
        list.forEach(couponExtRespDto -> {
            try {
                String receivePhone;
                CouponStatusEnum couponStatusEnum;
                if (CouponValidityTypeEnum.FIXED_DATE.getType().equals(couponExtRespDto.getValidityType())) {
                    Long couponTemplateId = couponExtRespDto.getCouponTemplateId();
                    CouponTemplateExtRespDto couponTemplateExtRespDto = (CouponTemplateExtRespDto)longCouponTemplateExtRespDtoMap.get(couponTemplateId);
                    couponExtRespDto.setEffectiveTime(couponTemplateExtRespDto.getEffectiveTime());
                    couponExtRespDto.setInvalidTime(couponTemplateExtRespDto.getInvalidTime());
                }
                if (null != (couponStatusEnum = CouponStatusEnum.getByStatus((String)couponExtRespDto.getCouponStatus()))) {
                    couponExtRespDto.setCouponStatusDescription(couponStatusEnum.getDescription());
                }
                if (StringUtils.isEmpty((CharSequence)couponExtRespDto.getUsePhone())) {
                    couponExtRespDto.setUsePhone("");
                }
                if (StringUtils.isEmpty((CharSequence)couponExtRespDto.getCouponStatusDescription())) {
                    couponExtRespDto.setCouponStatusDescription("");
                }
                if (null != couponExtRespDto.getUseTime()) {
                    couponExtRespDto.setUseTimeStr(DateUtil.getDateFormat((Date)couponExtRespDto.getUseTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                } else {
                    couponExtRespDto.setUseTimeStr("");
                }
                if (StringUtils.isEmpty((CharSequence)couponExtRespDto.getBatchNo())) {
                    couponExtRespDto.setBatchNo("");
                }
                couponExtRespDto.setReceivePhone(StringUtils.isNotBlank((CharSequence)(receivePhone = (String)phoneMap.get(couponExtRespDto.getUserId().toString()))) ? receivePhone : "");
                if (StringUtils.isEmpty((CharSequence)couponExtRespDto.getCouponTemplateCode())) {
                    couponExtRespDto.setCouponTemplateCode("");
                }
                sb.append("\t").append(couponExtRespDto.getCouponTemplateCode()).append(",");
                sb.append("\t").append(couponExtRespDto.getBatchNo()).append(",");
                sb.append("\t").append(couponExtRespDto.getCouponCode()).append(",");
                sb.append("\t").append(couponExtRespDto.getReceivePhone()).append(",");
                sb.append("\t").append(couponExtRespDto.getUsePhone()).append(",");
                sb.append("\t").append(DateUtil.getDateFormat((Date)couponExtRespDto.getEffectiveTime(), (String)"yyyy-MM-dd HH:mm:ss")).append(",");
                sb.append("\t").append(DateUtil.getDateFormat((Date)couponExtRespDto.getInvalidTime(), (String)"yyyy-MM-dd HH:mm:ss")).append(",");
                sb.append("\t").append(DateUtil.getDateFormat((Date)couponExtRespDto.getUseTime(), (String)"yyyy-MM-dd HH:mm:ss")).append(",");
                sb.append("\t").append(couponExtRespDto.getCouponStatusDescription()).append("\r\n");
            }
            catch (Exception e) {
                logger.error("\u5f53\u524d\u62fc\u88c5\u6570\u636e\u6709\u8bef,\u5f53\u524ddto=={},\u5f02\u5e38\u4fe1\u606f=={}", (Object)JSONObject.toJSONString((Object)couponExtRespDto), (Object)e);
                throw new BizException("\u62fc\u63a5\u6570\u636e\u51fa\u73b0\u5f02\u5e38");
            }
        });
        userIds.clear();
        list.clear();
        phoneMap.clear();
        return sb.toString();
    }

    public List<CouponExtRespDto> searchData(CouponReqDto couponReqDto) {
        int pageNum = 0;
        String keepAlive = "1m";
        int pageSize = 10000;
        OSSearchVo osSearchVo = new OSSearchVo();
        osSearchVo.setPage(pageNum);
        osSearchVo.setPageSize(10000);
        osSearchVo.setIndexName(this.esPrefix + "_" + EsIndexEnum.COUPON.getIndexName());
        osSearchVo.setTypeName(EsIndexEnum.COUPON.getTypeName());
        this.processQuery(couponReqDto, osSearchVo);
        ArrayList docValues = new ArrayList();
        osSearchVo.addEqualFilter("dr", "0");
        osSearchVo.addSort("createTime", SortOrder.DESC);
        osSearchVo.setUseScroll(true);
        osSearchVo.setKeepAlive("1m");
        SearchResultVo search = this.openSearchService.search(osSearchVo);
        if (null == search || CollectionUtils.isEmpty((Collection)search.getDocValues())) {
            logger.info("\u4ecees\u4e2d\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u6570\u636e");
            return Lists.newArrayList();
        }
        Long totalSize = search.getTotalSize();
        Long totalPageNum = search.getTotalPageNum();
        logger.info("\u67e5\u8be2\u9700\u8981\u5bfc\u51fa\u7684\u5238\u6570\u636e\uff0c\u603b\u5171\u6761\u6570\uff1a{}", (Object)totalSize);
        if (totalSize > 1000000L) {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u5bfc\u51fa\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e1000000\uff0c\u5f53\u524d\u6761\u6570\uff1a" + totalSize}));
        }
        if (CollectionUtils.isNotEmpty((Collection)search.getDocValues())) {
            docValues.addAll(search.getDocValues());
        }
        Integer currentNum = search.getDocValues().size();
        logger.info("\u5238\u5bfc\u51faes\u67e5\u8be2\u8fdb\u5ea6.{}/{}>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>{}/{}", new Object[]{pageNum, totalPageNum, currentNum, totalSize});
        String scrollId = search.getScrollId();
        logger.info("\u901a\u8fc7\u6e38\u6807\u5f62\u5f0f\u67e5\u8be2\u5238\u5217\u8868\uff1ascrollId\uff1a{}\uff0ckeepAlive\uff1a{}", (Object)scrollId, (Object)"1m");
        SearchResultVo searchResultVo = this.openSearchService.searchWithScrollId(scrollId, "1m");
        while (null != searchResultVo) {
            ++pageNum;
            List docs = searchResultVo.getDocValues();
            if (CollectionUtils.isEmpty((Collection)docs)) break;
            docValues.addAll(docs);
            currentNum = currentNum + docs.size();
            logger.info("\u5238\u5bfc\u51faes\u67e5\u8be2\u8fdb\u5ea6..{}/{}>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>{}/{}", new Object[]{pageNum, totalPageNum, currentNum, totalSize});
            docs.clear();
            searchResultVo = this.openSearchService.searchWithScrollId(scrollId, "1m");
            logger.info("es\u67e5\u8be2\u5230\u7684\u6570\u636e, scrollId={}, couponListSize={}", (Object)scrollId, (Object)searchResultVo.getDocValues().size());
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        logger.info("\u5238\u5bfc\u51faes\u67e5\u8be2\u8fdb\u5ea6\u5b8c\u6bd5{}/{}**************************************************************************{}/{}", new Object[]{pageNum, totalPageNum, currentNum, totalSize});
        ArrayList<CouponExtRespDto> list = new ArrayList<CouponExtRespDto>();
        Iterator iterator = docValues.iterator();
        while (iterator.hasNext()) {
            Map next = (Map)iterator.next();
            CouponExtRespDto couponExtRespDto = (CouponExtRespDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)next), CouponExtRespDto.class);
            list.add(couponExtRespDto);
            iterator.remove();
        }
        logger.info("\u5238\u5bfc\u51fa\u8f6c\u6362CouponExtRespDto\u96c6\u5408\u5b8c\u6bd5**************************************************************************");
        docValues.clear();
        return list;
    }

    private void processQuery(CouponReqDto couponReqDto, OSSearchVo osSearchVo) {
        FilterFieldVo dynamicDateFilter;
        ArrayList<FilterFieldVo> filterFieldVos;
        String toTime;
        String fromTime;
        if (null != couponReqDto.getUserId()) {
            osSearchVo.addEqualFilter("userId", couponReqDto.getUserId().toString());
        }
        if (StringUtils.isNotBlank((CharSequence)couponReqDto.getCouponCode())) {
            osSearchVo.addEqualFilter("couponCode", couponReqDto.getCouponCode());
        }
        if (StringUtils.isNotBlank((CharSequence)couponReqDto.getCouponTemplateCode())) {
            osSearchVo.addEqualFilter("couponTemplateCode", couponReqDto.getCouponTemplateCode());
        }
        if (null != couponReqDto.getTemplateIds()) {
            osSearchVo.addInFilter("couponTemplateId", couponReqDto.getTemplateIds());
        }
        if (null != couponReqDto.getUserId()) {
            osSearchVo.addEqualFilter("userId", couponReqDto.getUserId().toString());
        }
        if (StringUtils.isNotBlank((CharSequence)couponReqDto.getCouponStatus())) {
            osSearchVo.addEqualFilter("couponStatus", couponReqDto.getCouponStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)couponReqDto.getBatchNo())) {
            osSearchVo.addEqualFilter("batchNo", couponReqDto.getBatchNo());
        }
        if (null != couponReqDto.getEffectiveTimeStart()) {
            fromTime = DateUtil.getDateToString((Date)couponReqDto.getEffectiveTimeStart());
            toTime = DateUtil.getDateToString((Date)couponReqDto.getEffectiveTimeEnd());
            filterFieldVos = new ArrayList<FilterFieldVo>();
            this.processCouponTemplate(couponReqDto.getEffectiveTimeStart(), couponReqDto.getEffectiveTimeEnd(), filterFieldVos, 1);
            dynamicDateFilter = FilterFieldVo.compound((LogicalSymbol)LogicalSymbol.OR);
            dynamicDateFilter.addSubFilterFieldVos(new FilterFieldVo[]{this.validityTypeQuery(CouponValidityTypeEnum.DYNAMIC_DATE.getType().toString())});
            dynamicDateFilter.addSubFilterFieldVos(new FilterFieldVo[]{this.dynamicQueryDateValue("effectiveTime", fromTime, toTime)});
            filterFieldVos.add(dynamicDateFilter);
            osSearchVo.addFilters(filterFieldVos);
        }
        if (null != couponReqDto.getInvalidTimeStart()) {
            fromTime = DateUtil.getDateToString((Date)couponReqDto.getInvalidTimeStart());
            toTime = DateUtil.getDateToString((Date)couponReqDto.getInvalidTimeEnd());
            filterFieldVos = new ArrayList();
            this.processCouponTemplate(couponReqDto.getInvalidTimeStart(), couponReqDto.getInvalidTimeEnd(), filterFieldVos, 2);
            dynamicDateFilter = FilterFieldVo.compound((LogicalSymbol)LogicalSymbol.OR);
            dynamicDateFilter.addSubFilterFieldVos(new FilterFieldVo[]{this.validityTypeQuery(CouponValidityTypeEnum.DYNAMIC_DATE.getType().toString())});
            dynamicDateFilter.addSubFilterFieldVos(new FilterFieldVo[]{this.dynamicQueryDateValue("invalidTime", fromTime, toTime)});
            filterFieldVos.add(dynamicDateFilter);
            osSearchVo.addFilters(filterFieldVos);
        }
        if (null != couponReqDto.getUseTimeStart()) {
            String fromValue = DateUtil.getDateToString((Date)couponReqDto.getUseTimeStart());
            String toValue = DateUtil.getDateToString((Date)couponReqDto.getUseTimeEnd());
            osSearchVo.addRangeFilter("useTime", fromValue, toValue);
        }
        if (StringUtils.isNotBlank((CharSequence)couponReqDto.getOrderCode())) {
            osSearchVo.addEqualFilter("orderCode", couponReqDto.getOrderCode());
        }
    }

    private void processCouponTemplate(Date timeStart, Date timeEnd, List<FilterFieldVo> filterFieldVos, Integer type) {
        CouponTemplateExtReqDto couponTemplateExtReqDto = new CouponTemplateExtReqDto();
        if (type == 1) {
            couponTemplateExtReqDto.setEffectiveTimeBeginTime(timeStart);
            couponTemplateExtReqDto.setEffectiveTimeEndTime(timeEnd);
        } else if (type == 2) {
            couponTemplateExtReqDto.setInvalidTimeBeginTime(timeStart);
            couponTemplateExtReqDto.setInvalidTimeEndTime(timeEnd);
        } else {
            return;
        }
        couponTemplateExtReqDto.setValidityType(CouponValidityTypeEnum.FIXED_DATE.getType());
        String templateFilter = Object2FilterUtil.object2Filter((Object)couponTemplateExtReqDto);
        PageInfo<CouponTemplateExtRespDto> templatePage = this.couponTemplateExtQueryService.queryByPage(templateFilter, 1, 2000);
        if (templatePage.getTotal() > 2000L) {
            throw new ProBizException(ProExceptionCode.PARAMS_ERR.format(new String[]{"\u67e5\u8be2\u8303\u56f4\u8fc7\u5927\uff0c\u67e5\u8be2\u5f53\u524d\u5238\u6a21\u677f\u6570\u5927\u4e8e200\uff0c" + templatePage.getTotal() + "\u4e2a"}));
        }
        ArrayList<String> templateIds = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)templatePage.getList())) {
            templatePage.getList().forEach(templateExtRespDto -> templateIds.add(templateExtRespDto.getId().toString()));
        }
        this.dynamicQuery(filterFieldVos, templateIds);
    }

    private FilterFieldVo validityTypeQuery(String value) {
        FilterFieldVo typeFilter = FilterFieldVo.compound((LogicalSymbol)LogicalSymbol.AND);
        typeFilter.setFieldName("validityType");
        typeFilter.setEqualValue(value);
        typeFilter.setFilterType(FilterFieldVo.FilterType.TERM);
        return typeFilter;
    }

    private FilterFieldVo dynamicQueryDateValue(String key, String from, String to) {
        FilterFieldVo typeFilter = FilterFieldVo.compound((LogicalSymbol)LogicalSymbol.AND);
        typeFilter.setFieldName(key);
        typeFilter.setFromValue(from);
        typeFilter.setToValue(to);
        typeFilter.setFilterType(FilterFieldVo.FilterType.RANGE);
        return typeFilter;
    }

    private FilterFieldVo couponTemplateIdsQuery(String[] values) {
        FilterFieldVo typeFilter = FilterFieldVo.compound((LogicalSymbol)LogicalSymbol.AND);
        typeFilter.setFieldName("couponTemplateId");
        typeFilter.setInValues(values);
        typeFilter.setFilterType(FilterFieldVo.FilterType.TERMS);
        return typeFilter;
    }

    private void dynamicQuery(List<FilterFieldVo> filterFieldVos, List<String> templateIds) {
        if (CollectionUtils.isNotEmpty(templateIds)) {
            FilterFieldVo fixedDateFilter = FilterFieldVo.compound((LogicalSymbol)LogicalSymbol.OR);
            fixedDateFilter.addSubFilterFieldVos(new FilterFieldVo[]{this.validityTypeQuery(CouponValidityTypeEnum.FIXED_DATE.getType().toString())});
            String[] array = new String[templateIds.size()];
            fixedDateFilter.addSubFilterFieldVos(new FilterFieldVo[]{this.couponTemplateIdsQuery(templateIds.toArray(array))});
            filterFieldVos.add(fixedDateFilter);
        }
    }
}

