/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.action;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.biz.commons.enums.BestoreShopChannel;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.biz.member.api.common.constants.enums.ModuleType;
import com.dtyunxi.yundt.cube.biz.member.api.common.constants.enums.PointTypeEnum;
import com.dtyunxi.yundt.cube.biz.member.api.common.util.CenterMemberCheckUtil;
import com.dtyunxi.yundt.cube.biz.member.api.point.enums.PointEventEnum;
import com.dtyunxi.yundt.cube.center.member.api.basis.query.IMemberQueryApi;
import com.dtyunxi.yundt.cube.center.member.api.common.dto.request.PointsTradeInfoReqDto;
import com.dtyunxi.yundt.cube.center.member.api.common.dto.response.MemberRespDto;
import com.dtyunxi.yundt.cube.center.member.api.point.IPointsTradeApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActionTemplateRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.utils.MapUtils;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.utils.RedisUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ActionTemplate;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointExchangeAction
extends ActionTemplate {
    private Logger logger = LoggerFactory.getLogger(PointExchangeAction.class);
    @Resource
    private IPointsTradeApi pointsTradeApi;
    @Resource
    private IMemberQueryApi memberQueryApi;

    @Override
    public <T extends EngineParams> boolean execute(ActionTemplateRespDto actionTemplateRespDto, ActionRespDto actionRespDto, T t, Map<String, ?> map) {
        if (!CenterMemberCheckUtil.isLoadModule((ModuleType)ModuleType.POINT)) {
            return true;
        }
        this.logger.info("-------\u5f00\u59cb\u79ef\u5206\u5151\u6362-------");
        for (ItemVo item : t.getItems()) {
            PointsTradeInfoReqDto info = new PointsTradeInfoReqDto();
            info.setMemberId(Long.valueOf(t.getUserId()));
            info.setOrderNo(t.getOrderCode());
            info.setChannel(BestoreShopChannel.getByShopCode((String)t.getShopId()).getName());
            info.setChannelNo(t.getShopId());
            info.setTradeNo(MapUtils.getString((Map)t.getExtendsAttribute(), (Object)"payTradeCode", (String)""));
            HashMap<String, String> temp = new HashMap<String, String>(2);
            temp.put("eventCode", PointEventEnum.Z_PT_RPD.getEventCode());
            temp.put("channelSource", t.getProgramSrc());
            temp.put("platCode", MapUtils.getString((Map)t.getExtendsAttribute(), (Object)"platCode"));
            info.setExtension(JSON.toJSONString(temp));
            temp.clear();
            int point = MapUtils.getIntValue((Map)item.getExtendsAttribute(), (Object)"additionalPoints", (int)0);
            if (point <= 0) continue;
            info.setPoints(point);
            info.setTradeSource(PointEventEnum.Z_PT_RPD.getEventCode() + "|" + t.getActivityId() + "|" + MapUtils.getString((Map)item.getExtendsAttribute(), (Object)"payTradeCode", (String)"") + "|" + item.getItemId());
            info.setRemark(PointEventEnum.Z_PT_RPD.getEventName());
            info.setMemberModelId(((MemberRespDto)this.memberQueryApi.queryMemberAndItemsById(Long.valueOf(t.getUserId()), new String[]{"memberInfo"}).getData()).getMemberModelId());
            if (item.getDiscountPrice().compareTo(BigDecimal.ZERO) < 1) {
                temp.put("pointType", PointTypeEnum.POINT_EXCHANGE.getCode());
            } else {
                temp.put("pointType", PointTypeEnum.POINT_EXCHANGE_WITH_CASH.getCode());
            }
            temp.put("orderNo", t.getOrderCode());
            info.setExtFields(temp);
            this.pointsTradeApi.decrease(info);
        }
        DateTime toDay = DateTime.now();
        DateTime newDay = toDay.plusDays(1);
        DateTime dateTime = new DateTime(newDay.year().get(), newDay.monthOfYear().get(), newDay.dayOfMonth().get(), 0, 0, 0);
        RedisUtil.incrByAndExpire((ICacheService)SpringBeanUtil.getBean(ICacheService.class), "PointExchangeCondition.dayLimit" + t.getActivityId() + t.getUserId(), 1, dateTime.toDate());
        return true;
    }
}

