/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.mq;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.ItemMessage;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IItemActivityPriceService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.tag.service.IItemActivityTagService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="ITEM_ON_OFF_SHELF")
public class ItemShelfProsessor
implements IMessageProcessor<ItemMessage> {
    public static final Logger logger = LoggerFactory.getLogger(ItemShelfProsessor.class);
    @Resource
    private IItemActivityTagService itemActivityTagService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IItemActivityPriceService itemActivityPriceService;
    @Resource
    private IActivityService activityService;

    public MessageResponse process(ItemMessage message) {
        logger.info("\u6536\u5230\u5546\u54c1\u4e0a/\u4e0b\u67b6\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)message));
        try {
            boolean lock = this.cacheService.add(message.getBizId(), (Object)message.getBizId(), 604800);
            if (lock) {
                if (message.getOperateType() == 1) {
                    this.itemActivityTagService.saveItemActivityTagByItemId(message.getItemId(), message.getShopId());
                } else {
                    this.itemActivityTagService.deleteItemActivityTag(message.getItemId(), message.getShopId());
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u4e0a/\u4e0b\u67b6\u6d88\u606f\u5904\u7406\u5f02\u5e38", (Throwable)e);
        }
        return MessageResponse.SUCCESS;
    }
}

