/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.mq;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.OrderStatusChangeOrderDetailDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.BizActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IActivityExtService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="ORDER_STATUS_CHANGE_TAG", msgType="publish")
public class OrderStatusChangeProcessor
implements IMessageProcessor<OrderStatusChangeOrderDetailDto> {
    private static final Logger logger = LoggerFactory.getLogger(OrderStatusChangeProcessor.class);
    @Resource
    private ICacheService cacheService;
    @Resource
    private IActivityExtService activityExtService;
    @Autowired
    private IActivityService activityService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse process(OrderStatusChangeOrderDetailDto orderStatusChangeOrderDetailDto) {
        String oldName = Thread.currentThread().getName();
        Thread.currentThread().setName("OrderStatusChangeProcessor_Thread" + orderStatusChangeOrderDetailDto.getOrderCode());
        logger.info("\u6536\u5230\u8ba2\u5355\u53f7={},\u72b6\u6001={}\uff0c\u53d8\u66f4\u6d88\u606f={}", new Object[]{orderStatusChangeOrderDetailDto.getOrderCode(), orderStatusChangeOrderDetailDto.getOrderTradeStatus(), JSON.toJSONString((Object)orderStatusChangeOrderDetailDto)});
        String key = "order_change_status:" + orderStatusChangeOrderDetailDto.getOrderCode() + orderStatusChangeOrderDetailDto.getOrderTradeStatus();
        boolean add = this.cacheService.add(key, (Object)60);
        if (add) {
            try {
                List<Long> activityIds = orderStatusChangeOrderDetailDto.getActivitys().stream().map(OrderStatusChangeOrderDetailDto.OrderActivityInfoReqDto::getActivityId).distinct().collect(Collectors.toList());
                List<ActivityRespDto> activityRespDtos = this.activityService.queryByIds(activityIds);
                Map<Long, ActivityRespDto> activityMap = activityRespDtos.stream().filter(e -> !Objects.equals(BizActivityType.COMBINATION_ACTIVITY.getId(), e.getActivityTemplateId())).collect(Collectors.toMap(ActivityRespDto::getId, e -> e, (e1, e2) -> e1));
                List activits = orderStatusChangeOrderDetailDto.getActivitys().stream().filter(e -> activityMap.containsKey(e.getActivityId())).collect(Collectors.toList());
                logger.info("\u8fc7\u6ee4\u5957\u88c5\u540e\u6d3b\u52a8\u4fe1\u606f\uff1a{}", activits);
                if (CollectionUtils.isNotEmpty(activits)) {
                    orderStatusChangeOrderDetailDto.setActivitys(activits);
                    this.activityExtService.handleOrderStatusChangeMessage(orderStatusChangeOrderDetailDto);
                }
            }
            catch (Exception e3) {
                logger.error("\u5904\u7406\u8ba2\u5355\u53f7{},\u6d88\u606f\u5931\u8d25", (Object)orderStatusChangeOrderDetailDto.getOrderCode(), (Object)e3);
                MessageResponse messageResponse = MessageResponse.SUCCESS;
                return messageResponse;
            }
            finally {
                this.cacheService.delCache(key);
                Thread.currentThread().setName(oldName);
            }
        }
        Thread.currentThread().setName(oldName);
        return MessageResponse.SUCCESS;
    }
}

