/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.Bool;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponBatchStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponErrorEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateErrorEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponBatchCreateReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponGenBatchFlowService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.query.ICouponGenBatchFlowQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.utils.SerialCodeGenerateUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.das.CouponGenBatchFlowDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponGenBatchFlowEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponTemplateEo;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class CouponGenBatchFlowServiceImpl
implements ICouponGenBatchFlowService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CouponGenBatchFlowDas couponGenBatchFlowDas;
    @Autowired
    private ICouponGenBatchFlowQueryService couponGenBatchFlowQueryService;
    @Autowired
    private ILockService lockService;

    @Override
    public String createCouponGenBatchFlow(CouponTemplateExtRespDto couponTemplateExtRespDto, CouponBatchCreateReqDto couponBatchCreateReqDto) {
        String batchNo;
        block10: {
            Long couponTemplateId = couponBatchCreateReqDto.getCouponTemplateId();
            Integer num = couponBatchCreateReqDto.getNum();
            this.logger.info("\u751f\u6210\u4f18\u60e0\u5238\u6279\u6b21, couponBatchCreateReqDto={}", (Object)JSON.toJSONString((Object)couponBatchCreateReqDto));
            Mutex mutex = this.lockService.lock(CouponTemplateEo.class.getName(), couponTemplateId.toString(), 1, 20, TimeUnit.SECONDS);
            batchNo = null;
            try {
                if (mutex != null) {
                    if (num == null || num < 1) {
                        throw new ProBizException(CouponErrorEnum.COUPON_BATCH_GENERATE_NUM_NO_EXIST.getMsg());
                    }
                    if (couponTemplateExtRespDto.getRemainingQuantity() < (long)num.intValue()) {
                        throw new ProBizException(CouponTemplateErrorEnum.COUPON_TEMPLATE_STOCK_INSUFFICIENT.getMsg());
                    }
                    if (Bool.NO.getKey().equals(couponTemplateExtRespDto.getIsGenerateCode())) {
                        throw new ProBizException(CouponTemplateErrorEnum.COUPON_TEMPLATE_CANNOT_GENERATECODE.getMsg());
                    }
                    if (!couponTemplateExtRespDto.getCouponTemplateStatus().equals(CouponTemplateStatusEnum.ACTIVATE.getStatus())) {
                        throw new ProBizException("\u4f18\u60e0\u5238\u6a21\u677f--" + couponTemplateExtRespDto.getCouponName() + "\u4e0d\u662f" + CouponTemplateStatusEnum.ACTIVATE.getDescribe() + "\u72b6\u6001");
                    }
                    String maxBatchNo = this.couponGenBatchFlowQueryService.queryMaxBatchNo(couponTemplateExtRespDto.getId());
                    batchNo = SerialCodeGenerateUtil.generateCouponBatchNo(maxBatchNo);
                    CouponGenBatchFlowEo couponGenBatchFlowEo = CouponGenBatchFlowEo.newInstance();
                    couponGenBatchFlowEo.setCouponTemplateId(couponTemplateExtRespDto.getId());
                    couponGenBatchFlowEo.setCouponCode(couponTemplateExtRespDto.getCouponCode());
                    couponGenBatchFlowEo.setCouponName(couponTemplateExtRespDto.getCouponName());
                    couponGenBatchFlowEo.setBatchStatus(CouponBatchStatusEnum.GENERATING.getStatus());
                    couponGenBatchFlowEo.setQuantity(num);
                    couponGenBatchFlowEo.setBatchNo(batchNo);
                    this.couponGenBatchFlowDas.insert((BaseEo)couponGenBatchFlowEo);
                    break block10;
                }
                this.logger.warn("\u6279\u91cf\u751f\u6210\u4f18\u60e0\u5238\u65f6\u83b7\u53d6\u4e0d\u5230\u5206\u5e03\u5f0f\u9501, couponTemplateId={}, num={}", (Object)couponTemplateId, (Object)num);
                throw new ProBizException(CouponErrorEnum.COUPON_BATCH_CREATE_SYSTEM_BUSY.getMsg());
            }
            catch (ProBizException e) {
                this.logger.error("\u6279\u91cf\u751f\u6210\u4f18\u60e0\u5238error, message={}, e", (Object)e.getMessage(), (Object)e);
                throw e;
            }
            finally {
                this.lockService.unlock(mutex);
            }
        }
        return batchNo;
    }

    @Override
    public void updateBatchStatus(Long couponTemplateId, String batchNo, CouponBatchStatusEnum couponBatchStatusEnum) {
        if (StringUtils.isBlank((CharSequence)batchNo) || couponBatchStatusEnum == null) {
            return;
        }
        CouponGenBatchFlowEo couponGenBatchFlowEo = this.couponGenBatchFlowQueryService.queryById(couponTemplateId, batchNo);
        if (null != couponGenBatchFlowEo) {
            CouponGenBatchFlowEo update = CouponGenBatchFlowEo.newInstance();
            update.setId(couponGenBatchFlowEo.getId());
            update.setBatchStatus(couponBatchStatusEnum.getStatus());
            this.couponGenBatchFlowDas.updateSelective((BaseEo)update);
        }
    }
}

