/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.timediscount;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityItemRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityItemQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.BaseActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.PromotionActivityItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.PromotionActivitySkuDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.exchange.ExchangeActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.timediscount.TimeDiscountActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.timediscount.model.TimeDisActItem;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.AbstractBaseTemplate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeDiscountItemsCondition
extends AbstractBaseTemplate {
    private static Logger logger = LoggerFactory.getLogger(TimeDiscountItemsCondition.class);

    @Override
    public long getConditionTemplateId() {
        return 1196944771412880281L;
    }

    @Override
    public long getRuleId() {
        return 0L;
    }

    @Override
    public boolean support(ActivityType type) {
        return ActivityType.TIME_DISCOUNT_ACTIVITY.equals((Object)type) || ActivityType.EXCHANGE_ACTIVITY.equals((Object)type);
    }

    @Override
    public <T extends BaseActivityDto> ConditionReqDto convertToCondition(T t) {
        ConditionReqDto condition = this.getConditionReqDto();
        HashMap conditionParam = Maps.newHashMap();
        ArrayList timeDisActItems = Lists.newArrayList();
        List activityItems = Lists.newArrayList();
        Integer promotionMethod = null;
        if (t instanceof TimeDiscountActivityDto) {
            TimeDiscountActivityDto timeDiscountActivityDto = (TimeDiscountActivityDto)t;
            activityItems = timeDiscountActivityDto.getActivityItems();
            promotionMethod = timeDiscountActivityDto.getPromotionMethod();
        } else if (t instanceof ExchangeActivityDto) {
            ExchangeActivityDto exchangeActivityDto = (ExchangeActivityDto)t;
            activityItems = exchangeActivityDto.getActivityItems();
        }
        Integer finalPromotionMethod = promotionMethod;
        activityItems.forEach(itemDto -> itemDto.getSkus().forEach(skuDto -> {
            TimeDisActItem timeDisActItem = new TimeDisActItem();
            timeDisActItem.setItemId(skuDto.getItemId());
            timeDisActItem.setSkuId(skuDto.getSkuId());
            timeDisActItem.setPrice(skuDto.getSellPrice());
            timeDisActItem.setActivityPrice(skuDto.getPromotionPrice());
            timeDisActItem.setSkuName(skuDto.getSkuName());
            timeDisActItem.setItemCode(itemDto.getItemCode());
            timeDisActItem.setPromotionMethod(finalPromotionMethod);
            timeDisActItem.setDiscount(skuDto.getDiscount());
            timeDisActItem.setShopId(itemDto.getShopId());
            timeDisActItems.add(timeDisActItem);
        }));
        conditionParam.put("ItemTimeLimitCondition.items", timeDisActItems);
        condition.setConditionParams(JSON.toJSONString((Object)conditionParam));
        return condition;
    }

    @Override
    protected <T extends BaseActivityDto> void parse(ConditionRespDto conditionRespDto, T t) {
        Long activityId = t.getId();
        IActivityItemQueryApi activityItemQueryApi = (IActivityItemQueryApi)SpringBeanUtil.getBean((String)"activityItemQueryApiImpl", IActivityItemQueryApi.class);
        JSONObject jsonObject = JSON.parseObject((String)conditionRespDto.getConditionParams());
        List conditionItems = JSONArray.parseArray((String)jsonObject.getString("ItemTimeLimitCondition.items"), TimeDisActItem.class);
        ActivityItemQueryReqDto activityItemQueryReqDto = new ActivityItemQueryReqDto();
        activityItemQueryReqDto.setActivityId(activityId);
        List items = (List)activityItemQueryApi.queryAll(activityItemQueryReqDto).getData();
        Map<Long, List<ActivityItemRespDto>> group = items.stream().collect(Collectors.groupingBy(activitItem -> activitItem.getShopId() + activitItem.getItemId()));
        Integer promotionMethod = null;
        ArrayList itemIds = Lists.newArrayList();
        HashSet shopIds = Sets.newHashSet();
        ArrayList skuIds = Lists.newArrayList();
        ArrayList shelfReqDtos = Lists.newArrayList();
        items.forEach(activityItem -> {
            itemIds.add(activityItem.getItemId());
            skuIds.add(activityItem.getSkuId());
            shopIds.add(activityItem.getShopId());
            ShelfReqDto shelfReqDto = new ShelfReqDto();
            shelfReqDto.setSkuId(activityItem.getSkuId());
            shelfReqDto.setShopId(activityItem.getShopId());
            shelfReqDtos.add(shelfReqDto);
        });
        Map<Long, ItemRespDto> itemMap = this.queryItemByIds(itemIds);
        Map<Long, ShopBaseDto> shopMap = this.queryShopByIds(shopIds);
        Map<Long, ItemSkuRespDto> skuMap = this.queryItemSku(skuIds);
        Map<String, BigDecimal> priceMap = this.queryItemPrice(shelfReqDtos);
        Map<String, Long> stockMap = this.queryItemStock(shelfReqDtos);
        ArrayList activityItems = Lists.newArrayList();
        for (List<ActivityItemRespDto> itemDtos : group.values()) {
            Long itemId = itemDtos.get(0).getItemId();
            Long shopId = itemDtos.get(0).getShopId();
            if (!itemMap.containsKey(itemId)) continue;
            ItemRespDto itemRespDto = itemMap.get(itemId);
            PromotionActivityItemDto activityItemDto = new PromotionActivityItemDto();
            activityItemDto.setItemId(itemId);
            activityItemDto.setItemCode(itemRespDto.getCode());
            activityItemDto.setItemName(itemRespDto.getName());
            activityItemDto.setShopId(shopId);
            if (shopMap.containsKey(shopId)) {
                activityItemDto.setShopName(shopMap.get(shopId).getName());
            }
            activityItems.add(activityItemDto);
            Long totalStock = 0L;
            ArrayList activitySkuDtos = Lists.newArrayList();
            BigDecimal minPrice = null;
            for (ActivityItemRespDto skuDto : itemDtos) {
                Long stock;
                String shopSkuKey;
                BigDecimal price;
                ItemSkuRespDto skuRespDto;
                Long skuId = skuDto.getSkuId();
                TimeDisActItem timeDisActItem = this.getTimeDisActItem(skuDto.getSkuId(), conditionItems);
                PromotionActivitySkuDto activitySkuDto = new PromotionActivitySkuDto();
                activitySkuDto.setSkuId(skuDto.getSkuId());
                activitySkuDto.setDiscount(timeDisActItem.getDiscount());
                activitySkuDto.setItemId(skuDto.getItemId());
                activitySkuDto.setPromotionPrice(skuDto.getActivityPrice());
                if (skuMap.containsKey(skuId) && StringUtils.isNotBlank((String)(skuRespDto = skuMap.get(skuId)).getAttr())) {
                    Map skuAttrMap = (Map)ObjectHelper.Json2Bean((String)skuRespDto.getAttr(), Map.class);
                    String skuName = StringUtils.join(skuAttrMap.values(), (String)" ");
                    activitySkuDto.setSkuName(skuName);
                }
                if (null != (price = priceMap.get(shopSkuKey = skuDto.getShopId() + skuDto.getSkuId().toString())) && (null == minPrice || price.compareTo(minPrice) == -1)) {
                    minPrice = price;
                }
                if (ItemTypeEnum.BUNDLE.getType().equals(itemRespDto.getType())) {
                    stock = this.queryBundleItemStock(itemId, skuId, shopId);
                } else {
                    stock = stockMap.get(shopId + skuId.toString());
                    if (null == stock) {
                        stock = 0L;
                    }
                }
                activitySkuDto.setStock(stock);
                activitySkuDto.setSellPrice(price);
                totalStock = totalStock + stock;
                activitySkuDtos.add(activitySkuDto);
                promotionMethod = timeDisActItem.getPromotionMethod();
            }
            activityItemDto.setSkus((List)activitySkuDtos);
            activityItemDto.setTotalStock(totalStock);
            activityItemDto.setSellPrice(minPrice);
        }
        if (t instanceof TimeDiscountActivityDto) {
            TimeDiscountActivityDto timeDiscountActivityDto = (TimeDiscountActivityDto)t;
            timeDiscountActivityDto.setPromotionMethod(promotionMethod);
            timeDiscountActivityDto.setActivityItems((List)activityItems);
        } else if (t instanceof ExchangeActivityDto) {
            ExchangeActivityDto exchangeActivityDto = (ExchangeActivityDto)t;
            exchangeActivityDto.setActivityItems((List)activityItems);
        }
    }

    private TimeDisActItem getTimeDisActItem(Long skuId, List<TimeDisActItem> conditionItems) {
        return conditionItems.stream().filter(timeDisActItem -> timeDisActItem.getSkuId().equals(skuId)).findFirst().orElseGet(() -> new TimeDisActItem());
    }
}

