/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.Param;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.support.DefaultConversionService;

public abstract class Template<ExtensionPoint, TemplateDto, InstanceDto> {
    private static final Logger logger = LoggerFactory.getLogger(Template.class);
    private static final DefaultConversionService CONVERSION_SERVICE = new DefaultConversionService();
    private static final Map<String, Class<?>> CLASS_MAPPING = new HashMap();
    protected Map<String, ExtensionPoint> extensionPointMap;
    private Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExtensionPoint(String key, ExtensionPoint extensionPoint) {
        if (this.extensionPointMap == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.extensionPointMap == null) {
                    this.extensionPointMap = new HashMap<String, ExtensionPoint>();
                }
            }
        }
        this.extensionPointMap.put(key, extensionPoint);
    }

    public <T extends EngineParams> void validateParams(T params) throws ProBizException {
    }

    public abstract <T extends EngineParams> boolean execute(TemplateDto var1, InstanceDto var2, T var3, Map<String, ?> var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T> T converter(Object data, Param param, String loadClass) {
        if (null == data && !param.isRequired()) {
            return null;
        }
        Class<?> clazz = Template.getClazz(param.getName(), param.getValueType(), loadClass);
        try {
            if (null == clazz) {
                clazz = CLASS_MAPPING.get(param.getValueType());
                if (null == clazz) {
                    Map<String, Class<?>> map = CLASS_MAPPING;
                    synchronized (map) {
                        clazz = CLASS_MAPPING.get(param.getValueType());
                        if (null == clazz) {
                            try {
                                clazz = Class.forName(param.getValueType());
                                CLASS_MAPPING.put(param.getValueType(), clazz);
                            }
                            catch (ClassNotFoundException e) {
                                throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u6761\u4ef6[" + loadClass + "]\u914d\u7f6e\u53c2\u6570" + param.getName() + " \u7c7b\u578b" + param.getValueType() + "\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684class"}));
                            }
                        }
                    }
                }
                if (data instanceof JSONArray) {
                    return (T)JSON.parseArray((String)data.toString(), clazz);
                }
                return (T)JSON.parseObject((String)data.toString(), clazz);
            }
            if (param.isMultiple()) {
                if (data instanceof JSONArray) {
                    JSONArray temp = (JSONArray)data;
                    LinkedList coll = Lists.newLinkedList();
                    Class<?> tempClass = clazz;
                    temp.forEach(t -> coll.add(CONVERSION_SERVICE.convert(t, tempClass)));
                    return (T)coll;
                }
                throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u6761\u4ef6[" + loadClass + "]\u914d\u7f6e\u53c2\u6570" + param.getName() + "\u9700\u8981\u96c6\u5408\u7c7b\u578b"}));
            }
            if (Date.class.isAssignableFrom(clazz)) {
                return (T)DateTime.parse((String)data.toString(), (DateTimeFormatter)DateTimeFormat.forPattern((String)param.getPattern())).toDate();
            }
            return (T)CONVERSION_SERVICE.convert(data, clazz);
        }
        catch (ProBizException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u6761\u4ef6[" + loadClass + "]\u914d\u7f6e\u53c2\u6570" + param.getName() + "\u7c7b\u578b\u8f6c\u6362\u9519\u8bef"}));
        }
    }

    private static Class<?> getClazz(String name, String type, String conditionClass) {
        switch (type.toLowerCase()) {
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "string": {
                return String.class;
            }
            case "date": {
                return Date.class;
            }
        }
        return null;
    }
}

