/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityRelationReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityRelationExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityRelationRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.AuditStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.BizActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IActivityRelationService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityRelationDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityRelationEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.StActivityRelationEo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.aop.framework.AopContext;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class ActivityRelationServiceImpl
implements IActivityRelationService {
    private static final String ACTIVITY_RELATION_CACHE = "activity_relation_";
    @Resource
    private ActivityRelationDas activityRelationDas;
    @Resource
    private ActivityDas activityDas;

    @Override
    public boolean overlap(Long sourceActivityId, List<Long> targetActivityIds) {
        for (Long targetActivityId : targetActivityIds) {
            if (this.overlap(sourceActivityId, targetActivityId)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Cacheable(value={"activityRelationCache"}, key="#sourceId +'_'+#targetId")
    public boolean overlap(Long sourceId, Long targetId) {
        boolean result = false;
        ActivityRelationEo param = new ActivityRelationEo();
        param.setBizId(sourceId);
        List sourceList = this.activityRelationDas.select((BaseEo)param);
        if (CollectionUtils.isNotEmpty((Collection)sourceList)) {
            param.setBizId(targetId);
            param.setTargetTemplateId(((ActivityRelationEo)sourceList.get(0)).getSourceTemplateId());
            List targetList = this.activityRelationDas.select((BaseEo)param);
            if (CollectionUtils.isNotEmpty((Collection)targetList)) {
                block0: for (ActivityRelationEo source : sourceList) {
                    for (ActivityRelationEo target : targetList) {
                        if (!source.getSourceTemplateId().equals(target.getTargetTemplateId()) || !source.getTargetTemplateId().equals(target.getSourceTemplateId()) || (source.getRelation() & target.getRelation()) != 1) continue;
                        result = true;
                        continue block0;
                    }
                }
            }
        }
        this.currentProxy().setOverlap(sourceId, targetId, result);
        return result;
    }

    @Override
    @Cacheable(value={"activityRelationCache"}, key="#sourceId +'_'+#targetId")
    public boolean newOverlap(Long sourceId, Long targetId) {
        boolean result = false;
        ActivityRelationEo param = new ActivityRelationEo();
        param.setBizId(sourceId);
        param.setTargetActivityId(targetId);
        param.setRelation(Integer.valueOf(1));
        List sourceList = this.activityRelationDas.select((BaseEo)param);
        if (CollectionUtils.isNotEmpty((Collection)sourceList)) {
            result = true;
        } else {
            ActivityRelationEo query = new ActivityRelationEo();
            query.setBizId(targetId);
            query.setTargetActivityId(sourceId);
            query.setRelation(Integer.valueOf(1));
            List targetList = this.activityRelationDas.select((BaseEo)query);
            if (CollectionUtils.isNotEmpty((Collection)targetList)) {
                result = true;
            }
        }
        this.currentProxy().newSetOverlap(targetId, sourceId, result);
        return result;
    }

    private IActivityRelationService currentProxy() {
        return (IActivityRelationService)AopContext.currentProxy();
    }

    @Override
    @Cacheable(value={"activityRelationCache"}, key="#sourceId +'_'+#targetId")
    public boolean setOverlap(Long sourceId, Long targetId, boolean result) {
        return result;
    }

    @Override
    @Cacheable(value={"activityRelationCache"}, key="#sourceId +'_'+#targetId")
    public boolean newSetOverlap(Long sourceId, Long targetId, boolean result) {
        return result;
    }

    @Override
    public void add(Long activityId, Long activityTpId, List<ActivityRelationReqDto> relationReqDtos) {
        if (CollectionUtils.isEmpty(relationReqDtos)) {
            return;
        }
        List relationEos = relationReqDtos.stream().map(relationDto -> {
            ActivityRelationEo relationEo = new ActivityRelationEo();
            relationEo.setActivityId(activityId);
            relationEo.setBizId(activityId);
            relationEo.setSourceTemplateId(activityTpId);
            relationEo.setTargetTemplateId(relationDto.getTargetTemplateId());
            relationEo.setRelation(relationDto.getRelation());
            relationEo.setTargetActivityId(relationDto.getTargetActivityId());
            relationEo.setTargetType(relationDto.getTargetType());
            return relationEo;
        }).collect(Collectors.toList());
        this.activityRelationDas.insertBatch(relationEos);
    }

    @Override
    public List<ActivityRelationRespDto> queryByActivityId(Long activityId) {
        ActivityRelationEo param = new ActivityRelationEo();
        param.setActivityId(activityId);
        List relationEos = this.activityRelationDas.select((BaseEo)param);
        if (CollectionUtils.isEmpty((Collection)relationEos)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ActivityRelationRespDto> dtos = new ArrayList<ActivityRelationRespDto>();
        CubeBeanUtils.copyCollection(dtos, (Collection)relationEos, ActivityRelationRespDto.class);
        return dtos;
    }

    @Override
    public void add(List<ActivityRelationReqDto> relationReqDtos) {
        if (CollectionUtils.isEmpty(relationReqDtos)) {
            return;
        }
        List relationEos = relationReqDtos.stream().map(relationDto -> {
            ActivityRelationEo relationEo = new ActivityRelationEo();
            relationEo.setBizId(relationDto.getBizId());
            relationEo.setSourceTemplateId(relationDto.getSourceTemplateId());
            relationEo.setTargetTemplateId(relationDto.getTargetTemplateId());
            relationEo.setRelation(relationDto.getRelation());
            return relationEo;
        }).collect(Collectors.toList());
        this.activityRelationDas.insertBatch(relationEos);
    }

    @Override
    public List<ActivityRelationRespDto> query(ActivityRelationReqDto reqDto) {
        ActivityRelationEo param = new ActivityRelationEo();
        CubeBeanUtils.copyProperties((Object)param, (Object)reqDto, (String[])new String[0]);
        List relationEos = this.activityRelationDas.select((BaseEo)param);
        if (CollectionUtils.isEmpty((Collection)relationEos)) {
            Collections.emptyList();
        }
        ArrayList respDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)respDtos, (Collection)relationEos, ActivityRelationRespDto.class);
        respDtos.forEach(respDto -> {
            BizActivityType type = BizActivityType.getByType((Long)respDto.getTargetTemplateId());
            if (null != type) {
                respDto.setTargetTemplateName(type.getName());
            }
        });
        return respDtos;
    }

    @Override
    public void add(Long bizId, List<ActivityRelationReqDto> relationReqDtos) {
        ActivityRelationEo relationEo = new ActivityRelationEo();
        relationEo.setBizId(bizId);
        this.activityRelationDas.logicDelete((BaseEo)relationEo);
        this.add(relationReqDtos);
    }

    @Override
    public List<ActivityRelationExtRespDto> queryExt(ActivityRelationReqDto reqDto) {
        ActivityEo eo;
        ArrayList respDtos = Lists.newArrayList();
        ActivityRelationEo param = new ActivityRelationEo();
        CubeBeanUtils.copyProperties((Object)param, (Object)reqDto, (String[])new String[0]);
        List relationEos = this.activityRelationDas.select((BaseEo)param);
        List<Object> activityIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)relationEos)) {
            activityIds = relationEos.stream().map(StActivityRelationEo::getTargetActivityId).collect(Collectors.toList());
            List activityEos = this.activityDas.getMapper().selectList((Wrapper)new QueryWrapper().in((Object)"id", (Collection)activityIds));
            Map<Long, ActivityEo> activityMap = activityEos.stream().collect(Collectors.toMap(BaseEo::getId, e -> e, (e1, e2) -> e1));
            for (ActivityRelationEo relationEo : relationEos) {
                ActivityRelationExtRespDto respDto = new ActivityRelationExtRespDto();
                CubeBeanUtils.copyProperties((Object)respDto, (Object)relationEo, (String[])new String[0]);
                ActivityEo activityEo = activityMap.get(relationEo.getTargetActivityId());
                if (Objects.nonNull(activityEo)) {
                    respDto.setActivityName(activityEo.getActivityName());
                    respDto.setActivityCode(activityEo.getActivityCode());
                    respDto.setActivityStatus(activityEo.getActivityStatus());
                    respDto.setAuditStatus(activityEo.getAuditStatus());
                    respDto.setBeginTime(activityEo.getBeginTime());
                    respDto.setEndTime(activityEo.getEndTime());
                }
                respDtos.add(respDto);
            }
        }
        if (Objects.nonNull(param.getBizId()) && (eo = (ActivityEo)this.activityDas.selectByPrimaryKey(param.getBizId())).getAuditStatus().equals(AuditStatusEnum.AUDIT_PASS.getKey())) {
            ActivityRelationEo query = new ActivityRelationEo();
            query.setTargetActivityId(eo.getId());
            List relationResult = this.activityRelationDas.select((BaseEo)query);
            List activityBizIds = relationResult.stream().map(StActivityRelationEo::getBizId).collect(Collectors.toList());
            activityBizIds.removeIf(activityIds::contains);
            if (CollectionUtils.isNotEmpty(activityBizIds)) {
                List activityBizEos = this.activityDas.getMapper().selectList((Wrapper)new QueryWrapper().in((Object)"id", activityBizIds));
                for (ActivityEo activityBizEo : activityBizEos) {
                    if (!activityBizEo.getAuditStatus().equals(AuditStatusEnum.AUDIT_PASS.getKey())) continue;
                    ActivityRelationExtRespDto extRespDto = new ActivityRelationExtRespDto();
                    extRespDto.setActivityName(activityBizEo.getActivityName());
                    extRespDto.setActivityCode(activityBizEo.getActivityCode());
                    extRespDto.setActivityStatus(activityBizEo.getActivityStatus());
                    extRespDto.setAuditStatus(activityBizEo.getAuditStatus());
                    extRespDto.setBeginTime(activityBizEo.getBeginTime());
                    extRespDto.setEndTime(activityBizEo.getEndTime());
                    extRespDto.setTargetActivityId(activityBizEo.getId());
                    extRespDto.setTargetTemplateId(activityBizEo.getActivityTemplateId());
                    respDtos.add(extRespDto);
                }
            }
        }
        return respDtos;
    }

    @Override
    public void deleteActivityRelationByBizId(Long bizId) {
        ActivityRelationEo activityRelationEo = new ActivityRelationEo();
        activityRelationEo.setBizId(bizId);
        this.activityRelationDas.logicDelete((BaseEo)activityRelationEo);
    }
}

