/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.query.impl;

import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponBatchStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.query.ICouponGenBatchFlowQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.das.CouponGenBatchFlowDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponGenBatchFlowEo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponGenBatchFlowQueryServiceImpl
implements ICouponGenBatchFlowQueryService {
    @Autowired
    private CouponGenBatchFlowDas couponGenBatchFlowDas;

    @Override
    public String queryMaxBatchNo(Long couponTemplateId) {
        CouponGenBatchFlowEo query = CouponGenBatchFlowEo.newInstance();
        query.setCouponTemplateId(couponTemplateId);
        query.setOrderByDesc("batchNo");
        List list = this.couponGenBatchFlowDas.select((BaseEo)query);
        return CollectionUtils.isEmpty((Collection)list) ? null : ((CouponGenBatchFlowEo)list.get(0)).getBatchNo();
    }

    @Override
    public CouponGenBatchFlowEo queryById(Long couponTemplateId, String batchNo) {
        if (StringUtils.isBlank((CharSequence)batchNo) || couponTemplateId == null) {
            return null;
        }
        CouponGenBatchFlowEo query = CouponGenBatchFlowEo.newInstance();
        query.setCouponTemplateId(couponTemplateId);
        query.setBatchNo(batchNo);
        return (CouponGenBatchFlowEo)this.couponGenBatchFlowDas.selectOne((BaseEo)query);
    }

    @Override
    public List<CouponGenBatchFlowEo> queryGeneratingBatch(Long couponTemplateId) {
        if (couponTemplateId == null) {
            return null;
        }
        CouponGenBatchFlowEo query = CouponGenBatchFlowEo.newInstance();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.eq((String)"coupon_template_id", (Object)couponTemplateId));
        sqlFilters.add(SqlFilter.eq((String)"batchStatus", (Object)CouponBatchStatusEnum.GENERATING.getStatus()));
        Calendar calendar = Calendar.getInstance();
        calendar.add(11, -2);
        String judgeTime = DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)calendar.getTime());
        sqlFilters.add(SqlFilter.gt((String)"create_time", (Object)judgeTime));
        query.setSqlFilters((List)sqlFilters);
        return this.couponGenBatchFlowDas.select((BaseEo)query);
    }
}

