/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore;

import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.constants.enums.ObjectType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.constants.enums.ReturnType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.PresentDetailRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.AbstractConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.enums.DiscountType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.enums.PromotionCategory;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.enums.Stair;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.vo.RechargeGiftConditionVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.vo.RechargeGiftConfigVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.promotion.service.query.IPresentQueryService;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class RechargeGiftCondition
extends AbstractConditionTemplate<RechargeGiftConditionVo> {
    private static final String CONDITION = "RechargeGiftCondition.condition";
    private static final String CONFIG = "RechargeGiftCondition.config";
    private static final String TYPE = "RechargeGiftCondition.type";

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine templateDefine, ConditionRespDto conditionRespDto, T context, Map<String, ?> configParams) {
        BigDecimal amount = (BigDecimal)MapUtils.getObject((Map)context.getExtendsAttribute(), (Object)"rechargeAmt");
        RechargeGiftConfigVo configVo = (RechargeGiftConfigVo)((Object)this.getParam(CONFIG, templateDefine, configParams, "\u50a8\u503c\u914d\u7f6e\u672a\u914d\u7f6e"));
        List conditionVos = this.sort((List)this.getParam(CONDITION, templateDefine, configParams, "\u50a8\u503c\u8d60\u793c\u6761\u4ef6\u672a\u914d\u7f6e"));
        String returnTypeStr = (String)this.getParam(TYPE, templateDefine, configParams, "\u8fd4\u8fd8\u7c7b\u578b\u672a\u914d\u7f6e");
        ReturnType returnType = ReturnType.valueOf((String)returnTypeStr);
        boolean result = false;
        for (RechargeGiftConditionVo condition : conditionVos) {
            condition.setRechargeGiftConfigVo(configVo);
            condition.setReturnType(returnType);
            PromotionCategory promotionCategory = PromotionCategory.getByType(condition.getCondition());
            if (promotionCategory == null) {
                throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u7c7b\u522b\u672a\u914d\u7f6e"}));
            }
            result |= this.switchPromotionCategory(promotionCategory, Stair.newStair(), context, amount, null, null, condition);
        }
        if (result) {
            context.getExtendsAttribute().put(RechargeGiftConfigVo.class.getSimpleName(), configVo);
            return result;
        }
        throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u4e0d\u6ee1\u8db3\u53c2\u4e0e\u6d3b\u52a8\u6761\u4ef6"}));
    }

    @Override
    <T extends EngineParams> void handleDiscount(T context, BigDecimal itemTotalAmt, DiscountType discountType, RechargeGiftConditionVo conditionVo) {
        ReturnType returnType = conditionVo.getReturnType();
        Map extendsAttribute = context.getExtendsAttribute();
        switch (returnType) {
            case DEPOSIT: {
                BigDecimal rechargeGiftAmt = (BigDecimal)MapUtils.getObject((Map)extendsAttribute, (Object)"rechargeGiftAmt", (Object)BigDecimal.ZERO);
                extendsAttribute.put("rechargeGiftAmt", rechargeGiftAmt.add(conditionVo.getNum()));
                break;
            }
            case COUPON: {
                Long couponGroup = conditionVo.getObjGroupId();
                PresentDetailRespDto present = ((IPresentQueryService)SpringBeanUtil.getBean(IPresentQueryService.class)).queryDetailById(couponGroup);
                if (present == null || !CollectionUtils.isNotEmpty((Collection)present.getPresentList())) break;
                HashMap couponMap = Maps.newHashMap();
                present.getPresentList().forEach(coupon -> {
                    if (conditionVo.getObjectType().equals((Object)ObjectType.SINGLE)) {
                        couponMap.put(coupon.getCode(), conditionVo.getNum().intValue());
                    } else {
                        couponMap.put(coupon.getCode(), coupon.getNum());
                    }
                });
                Map sourceCoupons = (Map)MapUtils.getObject((Map)extendsAttribute, (Object)"returnCoupon", new HashMap(1));
                Map<String, Integer> result = Stream.concat(couponMap.entrySet().stream(), sourceCoupons.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum));
                sourceCoupons.putAll(result);
                extendsAttribute.put("returnCoupon", sourceCoupons);
                break;
            }
            case POINT: {
                BigDecimal oldValue = (BigDecimal)MapUtils.getObject((Map)extendsAttribute, (Object)"returnPoints", (Object)BigDecimal.ZERO);
                extendsAttribute.put("returnPoints", conditionVo.getNum().add(oldValue));
                break;
            }
            default: {
                throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u8fd4\u8d60\u7c7b\u578b\u6709\u8bef"}));
            }
        }
    }

    @Override
    public <T extends EngineParams> boolean eachFull(T context, BigDecimal itemTotalAmt, Integer itemTotalNum, DiscountType discountType, RechargeGiftConditionVo conditionConfig) {
        int discountCount;
        if (itemTotalAmt.compareTo(BigDecimal.ZERO) > 0 && conditionConfig.getLimitAmount().compareTo(BigDecimal.ZERO) > 0 && (discountCount = itemTotalAmt.divide(conditionConfig.getLimitAmount(), 0, 1).intValue()) > 0) {
            BigDecimal disCountValue = conditionConfig.getNum().multiply(new BigDecimal(discountCount));
            BigDecimal limit = conditionConfig.getRechargeGiftConfigVo().getEachFullLimit();
            if (limit != null && disCountValue.compareTo(limit) > 0) {
                conditionConfig.setNum(limit);
            } else {
                conditionConfig.setNum(disCountValue);
            }
            this.handleDiscount(context, itemTotalAmt, discountType, conditionConfig);
            return true;
        }
        return false;
    }

    @Override
    public <T extends EngineParams> boolean full(T context, BigDecimal itemTotalAmt, Integer itemTotalNum, DiscountType discountType, RechargeGiftConditionVo conditionConfig) {
        if (itemTotalAmt.compareTo(conditionConfig.getLimitAmount()) >= 0) {
            this.handleDiscount(context, itemTotalAmt, discountType, conditionConfig);
            return true;
        }
        return false;
    }

    @Override
    public <T extends EngineParams> boolean stair(T context, BigDecimal itemTotalAmt, Integer itemTotalNum, DiscountType discountType, RechargeGiftConditionVo conditionConfig) {
        throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u50a8\u503c\u8d60\u793c\u4e0d\u80fd\u542b\u6709\"\u9636\u68af\"\u6761\u4ef6"}));
    }

    @Override
    public <T extends EngineParams> boolean equal(T context, BigDecimal itemTotalAmt, Integer itemTotalNum, DiscountType discountType, RechargeGiftConditionVo conditionConfig) {
        throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u50a8\u503c\u8d60\u793c\u4e0d\u80fd\u542b\u6709\"\u7b49\u4e8e\"\u6761\u4ef6"}));
    }
}

