/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ConditionTemplateType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.BaseActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.PopulationDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.AbstractBaseTemplate;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class MemberCondition
extends AbstractBaseTemplate {
    private static final Logger logger = LoggerFactory.getLogger(MemberCondition.class);

    @Override
    public long getConditionTemplateId() {
        return ConditionTemplateType.TARGET_POPULATION.getId();
    }

    @Override
    public long getRuleId() {
        return 1196945569982147605L;
    }

    @Override
    public boolean support(ActivityType type) {
        return true;
    }

    @Override
    protected <T extends BaseActivityDto> void parse(ConditionRespDto conditionRespDto, T t) {
        JSONObject conditionObj = JSON.parseObject((String)conditionRespDto.getConditionParams());
        Integer type = conditionObj.getInteger("PopulationCondition.type");
        PopulationDto population = new PopulationDto();
        population.setType(type);
        String valueStr = conditionObj.getString("PopulationCondition.value");
        if (!StringUtils.isEmpty((Object)valueStr)) {
            List ids = JSON.parseArray((String)valueStr, Long.class);
            if (type == 2) {
                population.setLevelIds(ids);
            }
        }
        t.setPopulation(population);
    }

    @Override
    public <T extends BaseActivityDto> ConditionReqDto convertToCondition(T t) {
        ConditionReqDto conditionReqDto = this.getConditionReqDto();
        PopulationDto population = t.getPopulation();
        if (null == population || null == population.getType()) {
            population = new PopulationDto();
            population.setType(Integer.valueOf(0));
        }
        HashMap param = Maps.newHashMap();
        param.put("PopulationCondition.type", population.getType());
        param.put("PopulationCondition.value", population.getLevelIds());
        conditionReqDto.setConditionParams(JSON.toJSONString((Object)param));
        return conditionReqDto;
    }
}

