/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.impl;

import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.ActivityItemTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityItemRuleService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.mq.vo.ItemStockMsg;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.KeyGenerated;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityItemDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityItemEo;
import com.dtyunxi.yundt.imarketing.constants.MqTopicDefinition;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityItemRuleServiceImpl
implements IActivityItemRuleService {
    private static final Logger logger = LoggerFactory.getLogger(ActivityItemRuleServiceImpl.class);
    @Autowired
    private ICacheService cacheService;
    @Autowired
    private ActivityItemDas activityItemService;
    @Autowired
    private ICommonsMqService mqService;
    @Autowired
    private MqTopicDefinition mqTopicDefinition;

    @Override
    public void load(ActivityEo activity) {
        long expirationTime = activity.getEndTime().getTime() - System.currentTimeMillis();
        int seconds = (int)(expirationTime / 1000L);
        ActivityItemEo query = ActivityItemEo.newInstance();
        query.setActivityId(activity.getId());
        List activityItemRespDtos = this.activityItemService.select((BaseEo)query);
        logger.info("\u5f00\u59cb\u521d\u59cb\u5316\u6d3b\u52a8\u5546\u54c1\u4fe1\u606f\uff1a{}", (Object)activity.getId());
        for (ActivityItemEo itemEo : activityItemRespDtos) {
            String key = KeyGenerated.itemRule(activity.getId());
            String itemKey = KeyGenerated.item(itemEo);
            logger.debug("\u521d\u59cb\u5316\u6d3b\u52a8:{}\u5546\u54c1:{}\u5e93\u5b58:{}", new Object[]{activity.getId(), itemKey, itemEo.getRemainingStock()});
            this.cacheService.hset(key, itemKey, (Object)itemEo.getRemainingStock(), seconds + 86400);
            if (!Objects.nonNull(itemEo.getActivityStock())) continue;
            String newKey = KeyGenerated.joinNumRule(activity.getId());
            logger.debug("\u521d\u59cb\u5316\u6d3b\u52a8:{}\u5546\u54c1:{}\u53c2\u4e0e\u6b21\u6570:{}", new Object[]{activity.getId(), itemKey, itemEo.getActivityStock()});
            this.cacheService.hset(newKey, itemKey, (Object)itemEo.getActivityStock(), seconds + 86400);
        }
    }

    @Override
    public void unload(long acId) {
        this.cacheService.delCache(KeyGenerated.itemRule(acId));
    }

    @Override
    public int get(long acId, long id, Long shopId, ActivityItemTypeEnum type) {
        Integer count = (Integer)this.cacheService.hget(KeyGenerated.itemRule(acId), KeyGenerated.item(id, shopId, type), Integer.class);
        if (count == null) {
            return 0;
        }
        return count;
    }

    @Override
    public boolean increase(long acId, long id, Long shopId, int num, ActivityItemTypeEnum type, String msg) {
        long result = this.cacheService.hincrBy(KeyGenerated.itemRule(acId), KeyGenerated.item(id, shopId, type), num);
        if (result < 0L) {
            this.cacheService.hincrBy(KeyGenerated.itemRule(acId), KeyGenerated.item(id, shopId, type), -num);
            return false;
        }
        ItemStockMsg itemStockMsg = new ItemStockMsg(acId, id, type, num);
        MessageResponse messageResponse = this.mqService.sendDelaySingleMessage(this.mqTopicDefinition.getItemTopic(), "MARKETING-GIFT-STOCK", (Object)itemStockMsg, Long.valueOf(1L));
        logger.info("\u6d3b\u52a8\uff1a{}, \u5546\u54c1\uff1a{}, \u7c7b\u578b\uff1a{}, \u57fa\u4e8e\uff1a{}\u539f\u56e0\u3002\u8fdb\u884c\u5e93\u5b58\u65b0\u589e:{}\u4e2a.\u5bf9\u5e94msg\u6d88\u606f\uff1a{},\u81ea\u5b9a\u4e49\u6d88\u606fID\uff1a{}", new Object[]{acId, id, type, msg, num, messageResponse.getData(), itemStockMsg.getSerial()});
        return true;
    }

    @Override
    public boolean increaseReal(long acId, long id, Long shopId, int num, ActivityItemTypeEnum type) {
        ActivityItemEo result = this.getActivityItemEo(acId, id, shopId, type);
        if (null == result) {
            logger.error("\u5b9e\u9645\u7269\u7406\u6d3b\u52a8\u5e93\u5b58\u6263\u51cf\u5f02\u5e38\u3002 \u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u4fe1\u606f \u6d3b\u52a8ID\uff1a{} \u5546\u54c1ID\uff1a{}\uff0c\u5e97\u94faid\uff1a{},\u5546\u54c1\u7c7b\u578b\uff1a{}\u3002\u4fe1\u606f\u88ab\u5ffd\u7565", new Object[]{acId, id, shopId, type});
            return true;
        }
        return this.activityItemService.updateRemainByOptLock(result.getId().longValue(), num);
    }

    private ActivityItemEo getActivityItemEo(long acId, long id, Long shopId, ActivityItemTypeEnum type) {
        ActivityItemEo result;
        if (type.equals((Object)ActivityItemTypeEnum.GIFT)) {
            result = (ActivityItemEo)this.activityItemService.selectByPrimaryKey(Long.valueOf(id));
        } else {
            ActivityItemEo query = new ActivityItemEo();
            query.setActivityId(Long.valueOf(acId));
            query.setSkuId(Long.valueOf(id));
            query.setItemType(type.toString());
            query.setShopId(shopId);
            result = (ActivityItemEo)this.activityItemService.selectOne((BaseEo)query);
        }
        return result;
    }

    @Override
    public boolean increaseJoinNum(long acId, long id, Long shopId, int num, ActivityItemTypeEnum type, String msg) {
        long result = this.cacheService.hincrBy(KeyGenerated.joinNumRule(acId), KeyGenerated.item(id, shopId, type), num);
        if (result < 0L) {
            this.cacheService.hincrBy(KeyGenerated.joinNumRule(acId), KeyGenerated.item(id, shopId, type), -num);
            return false;
        }
        ItemStockMsg itemStockMsg = new ItemStockMsg(acId, id, type, num);
        itemStockMsg.setShopId(shopId);
        MessageResponse messageResponse = this.mqService.sendDelaySingleMessage(this.mqTopicDefinition.getItemTopic(), "MARKETING-ITEM-JOIN-NUM", (Object)itemStockMsg, Long.valueOf(1L));
        logger.info("\u6d3b\u52a8\uff1a{}, \u5546\u54c1\uff1a{}, \u7c7b\u578b\uff1a{}, \u57fa\u4e8e\uff1a{}\u539f\u56e0\u3002\u8fdb\u884c\u5e93\u5b58\u65b0\u589e:{}\u4e2a.\u5bf9\u5e94msg\u6d88\u606f\uff1a{},\u81ea\u5b9a\u4e49\u6d88\u606fID\uff1a{}", new Object[]{acId, id, type, msg, num, messageResponse.getData(), itemStockMsg.getSerial()});
        return true;
    }

    @Override
    public boolean increaseRealJoinNum(long acId, long id, Long shopId, int num, ActivityItemTypeEnum type) {
        ActivityItemEo result = this.getActivityItemEo(acId, id, shopId, type);
        if (null == result) {
            logger.error("\u5b9e\u9645\u7269\u7406\u6d3b\u52a8\u5269\u4f59\u53c2\u4e0e\u6b21\u6570\u6263\u51cf\u5f02\u5e38\u3002 \u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u4fe1\u606f \u6d3b\u52a8ID\uff1a{} \u5546\u54c1ID\uff1a{}\uff0c\u5e97\u94faid\uff1a{},\u5546\u54c1\u7c7b\u578b\uff1a{}\u3002\u4fe1\u606f\u88ab\u5ffd\u7565", new Object[]{acId, id, shopId, type});
            return true;
        }
        return this.activityItemService.updateJoinNumByOptLock(result.getId().longValue(), num);
    }

    @Override
    public int getJoinNum(long acId, long id, Long shopId, ActivityItemTypeEnum type) {
        Integer count = (Integer)this.cacheService.hget(KeyGenerated.joinNumRule(acId), KeyGenerated.item(id, shopId, type), Integer.class);
        if (count == null) {
            return 0;
        }
        return count;
    }
}

