/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.apiimpl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.cube.biz.commons.utils.ExecutorUtils;
import com.dtyunxi.cube.biz.commons.utils.HttpClientUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.biz.member.api.basis.IMemberInfoBestoreApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.IEngineApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponBatchStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponErrorEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateErrorEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponBatchCreateReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponBatchSendReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponGifReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponInvalidReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponReleaseReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponSendReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponStatisticReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponUseReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.PersonalizeCouponRefReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponNoticeUseRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponPushRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponSendRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponStatisticDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.ICouponExtApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponChannelEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponValidityTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponAnonymousService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponCacheService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponExtService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponGenBatchFlowService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.query.ICouponExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.query.ICouponGenBatchFlowQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.BeanCopyUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.conf.ext.ICouponUserExtPt;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.das.CouponGifRecordDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponGenBatchFlowEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponGifRecordEo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="couponExtApi")
public class CouponExtApiImpl
implements ICouponExtApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int BATCH_NUM = 1000;
    @Autowired
    private ICouponExtService couponExtService;
    @Resource
    private CouponGifRecordDas couponGifRecordDas;
    @Autowired
    private ICouponExtQueryService couponExtQueryService;
    @Autowired
    private ICouponAnonymousService couponAnonymousService;
    @Autowired
    private ICouponTemplateExtQueryService couponTemplateExtQueryService;
    @Autowired
    private ICouponGenBatchFlowService couponGenBatchFlowService;
    @Autowired
    private ICouponGenBatchFlowQueryService couponGenBatchFlowQueryService;
    @CubeResource
    private ICouponUserExtPt couponUserExtPt;
    @Autowired
    private ICouponCacheService couponCacheService;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IMemberInfoBestoreApi memberInfoBestoreApi;
    @Resource
    private IEngineApi engineApi;

    public RestResponse<Void> invalid(Long id) {
        this.couponExtService.invalid(id);
        return RestResponse.VOID;
    }

    public RestResponse<Void> batchInvalid(List<Long> ids) {
        this.couponExtService.batchInvalid(ids);
        return RestResponse.VOID;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<String> batchCreate(CouponBatchCreateReqDto couponBatchCreateReqDto) {
        this.logger.info("\u6279\u91cf\u751f\u6210\u4f18\u60e0\u5238, couponBatchCreateReqDto={}, cpu\u6838\u5fc3\u6570={}", (Object)JSON.toJSONString((Object)couponBatchCreateReqDto), (Object)Runtime.getRuntime().availableProcessors());
        CouponTemplateExtRespDto couponTemplateExtRespDto = this.couponTemplateExtQueryService.queryById(couponBatchCreateReqDto.getCouponTemplateId());
        if (null == couponTemplateExtRespDto) {
            throw new ProBizException(CouponTemplateErrorEnum.COUPON_TEMPLATE_EXIST.getMsg());
        }
        if (CouponValidityTypeEnum.FIXED_DATE.getType().equals(couponTemplateExtRespDto.getValidityType()) && couponTemplateExtRespDto.getInvalidTime() != null && new Date().after(couponTemplateExtRespDto.getInvalidTime())) {
            throw new ProBizException(CouponTemplateErrorEnum.COUPON_TEMPLATE_IS_EXPIRE.getMsg());
        }
        List<CouponGenBatchFlowEo> batchFlowEos = this.couponGenBatchFlowQueryService.queryGeneratingBatch(couponBatchCreateReqDto.getCouponTemplateId());
        if (CollectionUtils.isNotEmpty(batchFlowEos)) {
            throw new ProBizException(CouponTemplateErrorEnum.COUPON_IS_GENERATING.getMsg());
        }
        String batchNo = this.couponGenBatchFlowService.createCouponGenBatchFlow(couponTemplateExtRespDto, couponBatchCreateReqDto);
        ExecutorUtils.execute(() -> {
            Integer quantity = couponBatchCreateReqDto.getNum();
            int num = quantity / 1000;
            if (num == 0) {
                this.couponAnonymousService.asyncBatchSave(couponTemplateExtRespDto, batchNo, quantity);
            } else {
                for (int i = 0; i < num; ++i) {
                    this.couponAnonymousService.asyncBatchSave(couponTemplateExtRespDto, batchNo, 1000);
                }
                int remainder = quantity % 1000;
                if (remainder > 0) {
                    this.couponAnonymousService.asyncBatchSave(couponTemplateExtRespDto, batchNo, remainder);
                }
            }
            this.couponGenBatchFlowService.updateBatchStatus(couponBatchCreateReqDto.getCouponTemplateId(), batchNo, CouponBatchStatusEnum.FINISH_SUCCESS);
        });
        return new RestResponse((Object)batchNo);
    }

    public RestResponse<CouponSendRespDto> receiveCoupon(CouponSendReqDto couponSendReqDto) {
        return new RestResponse((Object)this.couponExtService.receiveCoupon(couponSendReqDto));
    }

    public RestResponse<CouponSendRespDto> spellCoupon(CouponSendReqDto couponSendReqDto) {
        return new RestResponse((Object)this.couponExtService.spellCoupon(couponSendReqDto));
    }

    public RestResponse<CouponPushRespDto> pushCoupon(CouponBatchSendReqDto couponBatchSendReqDto) {
        return new RestResponse((Object)this.couponExtService.pushCoupon(couponBatchSendReqDto));
    }

    public RestResponse<CouponPushRespDto> pushCouponByExternal(CouponBatchSendReqDto couponBatchSendReqDto) {
        return new RestResponse((Object)this.couponExtService.pushCouponByExternal(couponBatchSendReqDto));
    }

    public RestResponse<CouponPushRespDto> reviceCoupon2C(CouponBatchSendReqDto couponBatchSendReqDto) {
        return new RestResponse((Object)this.couponExtService.reviceCoupon2C(couponBatchSendReqDto));
    }

    public RestResponse<Boolean> releaseCoupon(CouponReleaseReqDto couponReleaseReqDto) {
        return new RestResponse((Object)this.couponExtService.releaseCoupon(couponReleaseReqDto));
    }

    public RestResponse<Boolean> releaseCouponByPaymentCode(CouponReleaseReqDto couponReleaseReqDto) {
        return new RestResponse((Object)this.couponExtService.releaseCouponByPaymentCode(couponReleaseReqDto));
    }

    public RestResponse<List<CouponExtRespDto>> useCoupon(CouponUseReqDto couponUseReqDto) {
        List list = this.couponUserExtPt.useCoupon(couponUseReqDto);
        this.sendNote(list);
        return new RestResponse((Object)list);
    }

    private void sendNote(List<CouponExtRespDto> list) {
        list.forEach(couponExtRespDto -> {
            if (CouponChannelEnum.TAOBAO.getChannel().equals(couponExtRespDto.getChannel()) || CouponChannelEnum.PIN_TUAN.getChannel().equals(couponExtRespDto.getChannel()) || CouponTypeEnum.GROUP_PURCHASE.getType().equals(couponExtRespDto.getCouponType())) {
                couponExtRespDto = this.couponExtQueryService.queryByCode(couponExtRespDto.getUserId(), couponExtRespDto.getCouponCode());
                this.logger.info("\u624b\u6dd8\u53d1\u5238\u3001\u62fc\u56e2\u53d1\u5238\u3001\u56e2\u8d2d\u5238\u901a\u77e5\u7b2c\u4e09\u65b9, couponExtRespDto={}", (Object)JSON.toJSONString((Object)couponExtRespDto));
                CouponNoticeUseRespDto couponTaobaoUseRespDto = new CouponNoticeUseRespDto(couponExtRespDto);
                this.commonsMqService.sendSingleMessageAsync("BIZ-MARKETING-COUPON-NOTICE-USE", (Object)JSON.toJSONString((Object)couponTaobaoUseRespDto));
            }
        });
    }

    public RestResponse<CouponStatisticDto> statisticCoupon(CouponStatisticReqDto couponStatisticReqDto) {
        return new RestResponse((Object)this.couponExtService.statisticCoupon(couponStatisticReqDto));
    }

    public RestResponse<String> exportStatisticCoupon(CouponStatisticReqDto couponStatisticReqDto) {
        return new RestResponse((Object)this.couponExtService.exportStatisticCoupon(couponStatisticReqDto));
    }

    public RestResponse<Boolean> invalidCoupon(CouponReleaseReqDto couponReleaseReqDto) {
        return new RestResponse((Object)this.couponExtService.invalidCoupon(couponReleaseReqDto));
    }

    public RestResponse<List<CouponExtRespDto>> reverseByOuterOrderCode(CouponReleaseReqDto couponReleaseReqDto) {
        return new RestResponse(this.couponExtService.reverseByOuterOrderCode(couponReleaseReqDto));
    }

    public RestResponse<Void> importFileInvalid(String fileUrl) {
        if (StringUtils.isBlank((CharSequence)fileUrl)) {
            throw new ProBizException(CouponErrorEnum.COUPON_PARAMES_ERROR.getMsg());
        }
        byte[] bytes = HttpClientUtils.doGetRawData((String)fileUrl);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        Optional.ofNullable(inputStream).orElseThrow(() -> new ProBizException(CouponErrorEnum.COUPON_PARAMES_ERROR.getMsg()));
        ExcelImportResult data = EasyPoiExportUtil.importExcel((InputStream)inputStream, (Integer)0, (Integer)1, CouponExtRespDto.class);
        List<String> couponCodes = data.getList().stream().map(CouponExtRespDto::getCouponCode).distinct().collect(Collectors.toList());
        this.couponExtService.batchInvalidByCodes(couponCodes);
        return RestResponse.VOID;
    }

    public RestResponse<Void> invalid(CouponInvalidReqDto couponInvalidReqDto) {
        this.couponExtService.invalid(couponInvalidReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Boolean> shift(Long userId1, Long userId2) {
        return new RestResponse((Object)this.couponExtService.shift(userId1, userId2));
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse couponGif(CouponGifReqDto dto) {
        Long targetId;
        Long sourceId;
        this.logger.info("dto=={}", (Object)JSONObject.toJSONString((Object)dto));
        if (StringUtils.isNotBlank((CharSequence)dto.getSourcePhone()) && null != (sourceId = (Long)this.memberInfoBestoreApi.queryMemberIdByPhone(dto.getSourcePhone()).getData())) {
            dto.setSourceMemberId(sourceId);
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getTargetPhone()) && null != (targetId = (Long)this.memberInfoBestoreApi.queryMemberIdByPhone(dto.getTargetPhone()).getData())) {
            dto.setTargetMemberId(targetId);
        }
        if (null == dto.getSourceMemberId() || null == dto.getTargetMemberId()) {
            throw new BizException("\u8f6c\u8d60\u4f1a\u5458\u4fe1\u606f\u9519\u8bef,\u65e0\u6cd5\u6b63\u5e38\u8fdb\u884c");
        }
        CouponExtRespDto couponExtRespDto = this.couponExtQueryService.queryByCode(dto.getSourceMemberId(), dto.getCouponCode());
        if (null == couponExtRespDto) {
            throw new BizException("\u4f18\u60e0\u5238\u4fe1\u606f\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u5238\u7801\u662f\u5426\u6b63\u786e");
        }
        if (!CouponStatusEnum.CREATE.getStatus().equals(couponExtRespDto.getCouponStatus())) {
            throw new BizException("\u4f18\u60e0\u5238\u72b6\u6001\u4e0d\u6b63\u786e,\u8bf7\u91cd\u65b0\u786e\u8ba4\u4f18\u60e0\u5238\u7801\u6b63\u786e\u6027");
        }
        Boolean valid = this.validMemberCoupon(dto.getTargetMemberId(), couponExtRespDto.getCouponTemplateId());
        if (!valid.booleanValue()) {
            throw new BizException("\u76ee\u6807\u4f1a\u5458\u5df2\u5b58\u5728\u76f8\u540c\u7684\u4f18\u60e0\u5238\u4fe1\u606f,\u4e0d\u53ef\u518d\u8f6c\u8d60");
        }
        EngineParams engineParams = new EngineParams();
        engineParams.setActivityId(couponExtRespDto.getActivityId().longValue());
        engineParams.setCouponTemplateId(couponExtRespDto.getCouponTemplateId().longValue());
        engineParams.setUserId(dto.getSourceMemberId());
        try {
            RestResponse coupon_gif = this.engineApi.execute("COUPON_GIF", engineParams);
            this.logger.info("\u5224\u65ad\u5f15\u64ce\u8fd4\u56de=={}", (Object)JSONObject.toJSONString((Object)coupon_gif));
        }
        catch (Exception e) {
            this.logger.error("\u5224\u65ad\u8f6c\u8d60\u5f15\u64ce\u5f02\u5e38=={}", (Throwable)e);
            throw new BizException("\u6b64\u4f18\u60e0\u5238\u4e0d\u652f\u6301\u8f6c\u8d60");
        }
        CouponEo newCouponEo = BeanCopyUtil.copyProperties(CouponEo.class, couponExtRespDto, new String[0]);
        newCouponEo.setId(null);
        newCouponEo.setUserId(dto.getTargetMemberId());
        this.couponExtService.deleteCouponById(couponExtRespDto.getId());
        this.couponExtService.insertCoupon(newCouponEo);
        this.couponCacheService.deleteMemberCouponCache(dto.getSourceMemberId(), CouponStatusEnum.CREATE.getStatus());
        this.saveCouponGifRecord(dto, couponExtRespDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> addPrsnRefByCouponCode(List<PersonalizeCouponRefReqDto> personalizeCouponRefReqDtos) {
        this.couponExtService.addPrsnRefByCouponCode(personalizeCouponRefReqDtos);
        return RestResponse.VOID;
    }

    private Boolean validMemberCoupon(Long targetMemberId, Long couponTemplateId) {
        List<CouponExtRespDto> couponExtRespDtos = this.couponExtQueryService.queryCouponByUserIdAndTemplateId(targetMemberId, couponTemplateId);
        if (CollectionUtils.isNotEmpty(couponExtRespDtos)) {
            return false;
        }
        return true;
    }

    private void saveCouponGifRecord(CouponGifReqDto dto, CouponExtRespDto couponExtRespDto) {
        CouponGifRecordEo couponGifRecordEo = new CouponGifRecordEo();
        couponGifRecordEo.setCouponCode(dto.getCouponCode());
        couponGifRecordEo.setCouponTemplateId(couponExtRespDto.getCouponTemplateId());
        couponGifRecordEo.setGifTime(new Date());
        couponGifRecordEo.setSourceMemberId(dto.getSourceMemberId());
        couponGifRecordEo.setTargetMemberId(dto.getTargetMemberId());
        couponGifRecordEo.setInstanceId(couponExtRespDto.getInstanceId());
        couponGifRecordEo.setTenantId(couponExtRespDto.getTenantId());
        this.couponGifRecordDas.insert((BaseEo)couponGifRecordEo);
    }
}

