/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.biz.member.api.basis.dto.response.MemberInfoDetailRespDto;
import com.dtyunxi.yundt.cube.biz.member.api.basis.query.IMemberInfoExtQueryApi;
import com.dtyunxi.yundt.cube.biz.member.api.common.dto.loyalty.request.MemberLevelDefineRespDto;
import com.dtyunxi.yundt.cube.biz.member.api.common.service.IMemberLevelDefineQueryApi;
import com.dtyunxi.yundt.dataengine.center.tag.api.dto.request.TagExistEntityInClusterReqDto;
import com.dtyunxi.yundt.dataengine.center.tag.api.query.IClusterQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.Param;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.enums.PopulationType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ILoadConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.seckill.util.SeckillKeyUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class PopulationCondition
extends ConditionTemplate
implements ILoadConditionTemplate {
    private static final String POPULATION_TYPE = "PopulationCondition.type";
    private static final String POPULATION_TYPE_VALUE = "PopulationCondition.value";
    private static final Logger logger = LoggerFactory.getLogger(PopulationCondition.class);
    @Resource
    private ICacheService commonCacheService;

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine define, ConditionRespDto conditionRespDto, T context, Map<String, ?> configParams) {
        if (!context.getPopulationFlag().booleanValue()) {
            return true;
        }
        Param param = define.getParam(POPULATION_TYPE);
        if (null == param) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u76ee\u6807\u4eba\u7fa4\u7c7b\u578b\u672a\u914d\u7f6e"}));
        }
        Object data = configParams.get(POPULATION_TYPE);
        PopulationType populationType = null;
        if (null != data) {
            logger.warn("\u89e3\u6790\u51fa\u6765\u7684\u662f=={}", (Object)JSONObject.toJSONString(data));
            Integer type = (Integer)ConditionTemplate.converter(configParams.get(POPULATION_TYPE), param, define.getLoadClass());
            populationType = PopulationType.getByType(type);
        }
        if (null == populationType) {
            populationType = PopulationType.ALL;
        }
        if (populationType != null) {
            List<Long> valueIds = this.getPopulationValue(define, configParams);
            switch (populationType) {
                case ALL: {
                    return true;
                }
                case CROWD: {
                    return this.crowd(context.getUserId(), valueIds);
                }
                case LEVEL: {
                    return this.level(context.getUserId(), valueIds, context.getCouponTemplateId(), context);
                }
            }
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u76ee\u6807\u4eba\u7fa4\u7c7b\u578b\u9519\u8bef"}));
        }
        throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u76ee\u6807\u4eba\u7fa4\u7c7b\u578b\u9519\u8bef"}));
    }

    private <T extends EngineParams> boolean level(Long userId, List<Long> valueIds, Long couponTemplateId, T params) {
        if (CollectionUtils.isEmpty(valueIds)) {
            return true;
        }
        MemberInfoDetailRespDto memberInfo = (MemberInfoDetailRespDto)((IMemberInfoExtQueryApi)SpringBeanUtil.getBean(IMemberInfoExtQueryApi.class)).queryMemberInfoDetail(userId).getData();
        if (memberInfo != null) {
            Long userLevelId = memberInfo.getMemberLevelDefineId();
            boolean isExist = valueIds.stream().anyMatch(levelIds -> Objects.equals(userLevelId, levelIds));
            params.getExtendsAttribute().put("memberLevelId", userLevelId);
            if (isExist) {
                return true;
            }
        }
        throw new ProBizException("11012", this.getErrorMsg(valueIds, couponTemplateId));
    }

    private String getErrorMsg(List<Long> valueIds, Long couponTemplateId) {
        IMemberLevelDefineQueryApi memberLevelDefineQueryApi = (IMemberLevelDefineQueryApi)SpringBeanUtil.getBean(IMemberLevelDefineQueryApi.class);
        List levelNames = valueIds.stream().map(levelId -> {
            MemberLevelDefineRespDto level = (MemberLevelDefineRespDto)memberLevelDefineQueryApi.queryMemberLevelDefineDetail(levelId).getData();
            if (null != level) {
                return level.getName() + "\u4f1a\u5458";
            }
            return "";
        }).collect(Collectors.toList());
        String msg = "\u4eb2~" + StringUtils.join(levelNames, (String)"\u3001");
        msg = null != couponTemplateId && couponTemplateId > 0L ? msg + "\u624d\u53ef\u4ee5\u9886\u53d6\u54e6~" : msg + "\u624d\u53ef\u4ee5\u53c2\u4e0e\u6d3b\u52a8\u54e6~";
        return msg;
    }

    private boolean crowd(Long userId, List<Long> valueIds) {
        if (CollectionUtils.isEmpty(valueIds)) {
            return true;
        }
        IClusterQueryApi tagCusterApi = (IClusterQueryApi)SpringBeanUtil.getBean(IClusterQueryApi.class);
        Environment environment = (Environment)SpringBeanUtil.getBean(Environment.class);
        Long tenantId = (Long)environment.getProperty("lppz.tenantId", Long.class);
        Long instanceId = (Long)environment.getProperty("lppz.instanceId", Long.class);
        IMemberInfoExtQueryApi memberQueryApi = (IMemberInfoExtQueryApi)SpringBeanUtil.getBean(IMemberInfoExtQueryApi.class);
        MemberInfoDetailRespDto memberInfo = (MemberInfoDetailRespDto)memberQueryApi.queryMemberInfoDetail(userId).getData();
        Iterator<Long> iterator = valueIds.iterator();
        if (iterator.hasNext()) {
            Long targetId = iterator.next();
            TagExistEntityInClusterReqDto reqDto = new TagExistEntityInClusterReqDto();
            reqDto.setEntityId(memberInfo.getMemberNo());
            reqDto.setClusterId(targetId);
            try {
                return (Boolean)tagCusterApi.existEntityInCluster(tenantId, instanceId, reqDto).getData();
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528\u6807\u7b7e\u4e2d\u5fc3\u51fa\u9519\u3002\u5224\u5b9a\u4e3a\u5931\u8d25");
                return false;
            }
        }
        throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u7528\u6237[" + userId + "]\u4e0d\u5728\u4eba\u7fa4[" + StringUtils.join(valueIds, (String)",") + "]\u4e2d\uff0c\u6ca1\u6709\u8d44\u683c\u53c2\u52a0\u6d3b\u52a8"}));
    }

    private List<Long> getPopulationValue(TemplateDefine define, Map<String, ?> configParams) {
        Param param = define.getParam(POPULATION_TYPE_VALUE);
        if (param != null && configParams.get(POPULATION_TYPE_VALUE) != null) {
            return (List)ConditionTemplate.converter(configParams.get(POPULATION_TYPE_VALUE), param, define.getLoadClass());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void load(TemplateDefine define, ConditionRespDto conditionRespDto, Map<String, ?> activityParams, int expire) {
        Long activityId = conditionRespDto.getActivityId();
        logger.info("\u3010activityId={}\u3011\u6d3b\u52a8\u52a0\u8f7d\u4eba\u7fa4\u6761\u4ef6\u7684\u4f1a\u5458\u7b49\u7ea7\u5f00\u59cb=====", (Object)activityId);
        Param param = define.getParam(POPULATION_TYPE);
        Integer type = (Integer)ConditionTemplate.converter(activityParams.get(POPULATION_TYPE), param, define.getLoadClass());
        PopulationType populationType = PopulationType.getByType(type);
        if (populationType == null) {
            logger.info("\u3010activityId={}\u3011\u6d3b\u52a8\u4eba\u7fa4\u6761\u4ef6\u672a\u914d\u7f6e", (Object)activityId);
        }
        if (populationType != null) {
            List<Long> valueIds = this.getPopulationValue(define, activityParams);
            if (CollectionUtils.isEmpty(valueIds)) {
                logger.info("\u3010activityId={}\u3011\u6d3b\u52a8\u4eba\u7fa4\u6761\u4ef6\u4f1a\u5458\u7b49\u7ea7\u672a\u914d\u7f6e", (Object)activityId);
            }
            this.commonCacheService.lpush(SeckillKeyUtil.getCacheKey("activity_population_level", activityId), valueIds, expire);
        }
        logger.info("\u3010activityId={}\u3011\u6d3b\u52a8\u52a0\u8f7d\u4eba\u7fa4\u6761\u4ef6\u7684\u4f1a\u5458\u7b49\u7ea7\u7ed3\u675f=====", (Object)activityId);
    }
}

