/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.impl;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityJoinNumService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ActivityJoinNumServiceImpl
implements IActivityJoinNumService {
    private Logger logger = LoggerFactory.getLogger(ActivityJoinNumServiceImpl.class);
    @Resource
    private ICacheService cacheService;

    @Override
    public Long increase(Long activityId, Long userId, int num) {
        Long result = this.cacheService.incrBy(this.getKey(activityId, userId), Long.valueOf(num).longValue());
        this.logger.info("\u64cd\u4f5c\u6d3b\u52a8\u53c2\u4e0e\u6b21\u6570\uff0cactivityId={}, userId={}, \u589e\u52a0{}\uff0c\u64cd\u4f5c\u540e\u6d3b\u52a8\u53c2\u4e0e\u6b21\u6570\uff1a{}", new Object[]{activityId, userId, num, result});
        return result;
    }

    @Override
    public Long decrease(Long activityId, Long userId, int num) {
        Long joinNum = this.cacheService.decrBy(this.getKey(activityId, userId), Long.valueOf(num).longValue());
        if (joinNum < 0L) {
            joinNum = this.cacheService.incrBy(this.getKey(activityId, userId), Long.valueOf(num).longValue());
            this.logger.info("activityId={}, userId={}, num={},\u6d3b\u52a8\u53c2\u4e0e\u6b21\u6570\u51cf\u5c11\u5931\u8d25", new Object[]{activityId, userId, num});
        }
        this.logger.info("activityId={}, userId={}, \u51cf\u5c11{}\uff0c\u64cd\u4f5c\u540e\u6d3b\u52a8\u53c2\u6b21\u6570\uff1a{}", new Object[]{activityId, userId, num, joinNum});
        return joinNum;
    }

    @Override
    public Long getJoinNum(Long activityId, Long userId) {
        Long joinNum = (Long)this.cacheService.getCache(this.getKey(activityId, userId), Long.class);
        return joinNum == null ? 0L : joinNum;
    }

    private String getKey(Long activityId, Long userId) {
        return "activityJoinNum:" + activityId + ":" + userId;
    }
}

