/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.converter.promotion.condition;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ConditionTemplateType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.ConditionDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.Promotion;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionInfoDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionRulesDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.PromotionInfoRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.utils.MapUtils;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.converter.promotion.condition.AbstractBaseTemplate;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.util.StringUtils;

public class MoneyOffExtCondition
extends AbstractBaseTemplate {
    @Override
    public boolean support(ActivityType type) {
        return ActivityType.FULL_DISCOUNT_ACTIVITY.equals((Object)type) || ActivityType.OVERALL_REDUCTION_ACTIVITY.equals((Object)type);
    }

    @Override
    public long getConditionTemplateId() {
        return ConditionTemplateType.ACTIVITY_MONEY_OFF_EXT.getId();
    }

    @Override
    public long getRuleId() {
        return 1196945569812278401L;
    }

    @Override
    public Map<String, Object> processRule(PromotionDto dto) {
        PromotionInfoDto info = (PromotionInfoDto)dto;
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        ArrayList mapList = new ArrayList(4);
        for (PromotionRulesDto rule : info.getRuleDtos()) {
            HashMap<String, Object> temp = new HashMap<String, Object>(3);
            temp.put("limitAmount", rule.getLimitAmount());
            temp.put("condition", rule.getCondition());
            temp.put("discountValue", rule.getDiscountValue());
            temp.put("priceType", rule.getPriceType());
            temp.put("returnType", rule.getReturnType());
            mapList.add(temp);
        }
        param.put("MoneyOffExtCondition.condition", mapList);
        if (ActivityType.FULL_DISCOUNT_ACTIVITY.equals((Object)dto.getInfoDto().getActivityType())) {
            param.put("MoneyOffExtCondition.type", 0);
        } else {
            param.put("MoneyOffExtCondition.type", 1);
        }
        return param;
    }

    @Override
    public List<ConditionDto> changeToRules(ConditionRespDto conditionRespDto, PromotionInfoRespDto resp) {
        ArrayList ruleList = Lists.newArrayList();
        JSONObject conditionObj = JSON.parseObject((String)conditionRespDto.getConditionParams());
        List conditionArr = JSON.parseArray((String)conditionObj.getString("MoneyOffExtCondition.condition"), JSONObject.class);
        if (CollectionUtils.isNotEmpty((Collection)conditionArr)) {
            conditionArr.forEach(condition -> {
                PromotionRulesDto rulesDto = PromotionRulesDto.defaultInstance((Map)condition);
                rulesDto.setDiscountValue(MapUtils.getString((Map)condition, (Object)"discountValue"));
                ruleList.add(rulesDto);
            });
        }
        return ruleList;
    }

    @Override
    public void changeToLPPZPromotion(ConditionDto c, String activityId, PromotionInfoRespDto localPromotion, Promotion promotion) {
        if (!(c instanceof PromotionRulesDto)) {
            return;
        }
        if (ActivityType.FULL_DISCOUNT_ACTIVITY.equals((Object)localPromotion.getInfoDto().getActivityType())) {
            promotion.setPromType("A");
        } else {
            promotion.setPromType("B");
        }
        PromotionRulesDto rule = (PromotionRulesDto)c;
        Promotion newP = promotion.clone();
        if (CollectionUtils.isNotEmpty((Collection)promotion.getSubPromotions())) {
            newP = (Promotion)promotion.getSubPromotions().get(0);
            promotion.getSubPromotions().clear();
        }
        newP.setDiscount(rule.getPriceType(), rule.getLimitAmount());
        newP.setCondition(rule.getCondition(), promotion.getPromId());
        if (2 == rule.getCondition()) {
            newP.setEachFull(true);
        } else if (3 == rule.getCondition()) {
            newP.setLadde(true);
            newP.setLaddeId(promotion.getPromId());
        }
        String type = "price";
        int newScale = 2;
        if (2 == rule.getPriceType()) {
            type = "quantity";
            newScale = 0;
        }
        StringBuilder express = new StringBuilder();
        String prefix = "(";
        String suffix = ")";
        String space = "";
        if (localPromotion.getRuleList().size() > 1) {
            String t = rule.getLimitAmount().setScale(newScale, 2).toString();
            prefix = "";
            suffix = "";
            space = " ";
            if (StringUtils.isEmpty((Object)newP.getPriceExpr())) {
                express.append("<#if (").append(type).append(">= ").append(t).append(")>");
            } else {
                express.append(newP.getPriceExpr());
                express.append("<#elseif (").append(type).append(">= ").append(t).append(")>");
            }
        }
        String price = new BigDecimal(rule.getDiscountValue()).setScale(2, RoundingMode.HALF_UP).toString();
        switch (rule.getReturnType()) {
            case CASH: {
                express.append("#{").append(prefix).append("price-").append(space).append(price).append(suffix).append(";M50}");
                break;
            }
            case DISCOUNT: {
                express.append("#{").append(prefix).append("price*").append(space).append(price).append(suffix).append(";M50}");
                break;
            }
            default: {
                throw new ProBizException(ProExceptionCode.SYSTEM_ERR.format(new String[]{"\u4e0d\u652f\u6301\u7684\u79ef\u5206\u5151\u6362\u7c7b\u578b"}));
            }
        }
        newP.setPriceExpr(express.toString());
        promotion.addSubPromotions(newP);
    }
}

