/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.fullreduction.condition;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.request.ActivityItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.Param;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.tag.service.IItemActivityTagService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ItemConditionTemplate;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemFullDecCondition
extends ItemConditionTemplate {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String CONFIG_PARAM_KEY_TYPE = "ItemFullDecCondition.type";
    private static final String CONFIG_PARAM_KEY_SELLERIDS = "ItemFullDecCondition.sellerIds";
    private static final String CONFIG_PARAM_KEY_ITEMS = "ItemFullDecCondition.items";
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItemActivityTagService itemActivityTagService;
    @Resource
    private IActivityService activityService;

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine define, ConditionRespDto conditionRespDto, T context, Map<String, ?> configParams) {
        Param typeParam = define.getParam(CONFIG_PARAM_KEY_TYPE);
        Param sellerIdsParam = define.getParam(CONFIG_PARAM_KEY_SELLERIDS);
        Param param = define.getParam(CONFIG_PARAM_KEY_ITEMS);
        this.validateParams(typeParam, sellerIdsParam, param);
        List items = (List)ConditionTemplate.converter(configParams.get(CONFIG_PARAM_KEY_ITEMS), param, define.getLoadClass());
        if (CollectionUtils.isEmpty((Collection)items)) {
            return false;
        }
        if (context.getActivityFlag().booleanValue()) {
            List skuIds = items.stream().map(entity -> entity.getSkuId()).collect(Collectors.toList());
            context.getItems().removeIf(itemVo -> skuIds.stream().noneMatch(skuId -> Objects.equals(Long.parseLong(itemVo.getSkuId()), skuId)));
        } else {
            List itemIds = items.stream().map(entity -> entity.getItemId()).collect(Collectors.toList());
            context.getItems().removeIf(itemVo -> itemIds.stream().noneMatch(itemId -> Objects.equals(Long.parseLong(itemVo.getItemId()), itemId)));
        }
        return CollectionUtils.isNotEmpty((Collection)context.getItems());
    }

    public void validateParams(Param typeParam, Param sellerIdsParam, Param param) throws ProBizException {
        if (null == typeParam) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u6d3b\u52a8\u5546\u54c1\u8303\u56f4[type]\u672a\u914d\u7f6e"}));
        }
        if (null == sellerIdsParam) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u9009\u62e9\u5546\u6237ID[sellerIds]\u672a\u914d\u7f6e"}));
        }
        if (null == param) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u90e8\u5206\u5546\u54c1\u6761\u4ef6[items]\u672a\u914d\u7f6e"}));
        }
    }

    @Override
    public boolean apply(TemplateDefine define, ConditionRespDto conditionRespDto, ItemVo itemVo) {
        Param param = define.getParam(CONFIG_PARAM_KEY_ITEMS);
        if (null == param) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u5546\u54c1\u6761\u4ef6[items]\u672a\u914d\u7f6e"}));
        }
        JSONObject configParams = JSON.parseObject((String)conditionRespDto.getConditionParams());
        List items = (List)ConditionTemplate.converter(configParams.get(CONFIG_PARAM_KEY_ITEMS), param, define.getLoadClass());
        if (CollectionUtils.isNotEmpty((Collection)items)) {
            return items.stream().anyMatch(item -> {
                String target = item.getItemId().toString();
                String source = itemVo.getItemId();
                if (null != itemVo.getSkuId()) {
                    target = target + item.getSkuId();
                    source = source + itemVo.getSkuId();
                }
                target = target + item.getShopId();
                source = source + itemVo.getShopId();
                return target.equals(source);
            });
        }
        return false;
    }

    @Override
    public Set<ActivityItemDto> getItems(TemplateDefine define, ConditionRespDto conditionRespDto, Map<String, ?> configParams) {
        Param param = define.getParam(CONFIG_PARAM_KEY_ITEMS);
        Set<Object> availableItems = Sets.newHashSet();
        ActivityRespDto activityRespDto = this.activityService.queryById(conditionRespDto.getActivityId());
        if (null == activityRespDto) {
            return Collections.EMPTY_SET;
        }
        List items = (List)ConditionTemplate.converter(configParams.get(CONFIG_PARAM_KEY_ITEMS), param, define.getLoadClass());
        if (CollectionUtils.isNotEmpty((Collection)items)) {
            availableItems = items.stream().map(fullDecActItem -> new ActivityItemDto(fullDecActItem.getShopId(), fullDecActItem.getItemId())).collect(Collectors.toSet());
        }
        return availableItems;
    }
}

