/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.request.ActivityItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ActivityCoupon;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.Param;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.tag.service.IItemActivityTagService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ItemConditionTemplate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CouponItemsCondition
extends ItemConditionTemplate {
    public static final String COUPON_ITEM_CONDITION = "CouponItemsCondition.items";
    private Logger logger = LoggerFactory.getLogger(CouponItemsCondition.class);
    @Autowired
    private IItemQueryApi itemQueryApi;
    @Resource
    private IActivityService activityService;
    @Resource
    private IItemActivityTagService itemActivityTagService;

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine define, ConditionRespDto conditionRespDto, T context, Map<String, ?> configParams) {
        Param param = define.getParam(COUPON_ITEM_CONDITION);
        if (null == param) {
            throw new ProBizException("\u5355\u54c1\u6761\u4ef6\u672a\u914d\u7f6e");
        }
        Collection items = (Collection)ConditionTemplate.converter(configParams.get(COUPON_ITEM_CONDITION), param, define.getLoadClass());
        if (CollectionUtils.isEmpty((Collection)items)) {
            return true;
        }
        List<String> includeItemIds = CouponItemsCondition.parseIncludeParams(items, false);
        ArrayList<ItemVo> matchItems = new ArrayList<ItemVo>();
        for (ItemVo itemVo : context.getItems()) {
            if (!includeItemIds.contains(itemVo.getItemId())) continue;
            matchItems.add(itemVo);
        }
        if (CollectionUtils.isEmpty(matchItems)) {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u4f18\u60e0\u5238\u53ef\u7528\u5546\u54c1\u4e0d\u7b26\u5408\u6761\u4ef6\uff0c\u5f53\u524d\u4f18\u60e0\u5238\u4e0d\u53ef\u7528"}));
        }
        ActivityCoupon activityCoupon = context.getCouponByActivityId(Long.valueOf(context.getActivityId()));
        if (null != activityCoupon) {
            activityCoupon.setItems(matchItems);
        }
        return true;
    }

    public static List<CouponTemplateItemDto> parseParams(String conditionParams) {
        if (StringUtils.isBlank((CharSequence)conditionParams)) {
            return Collections.emptyList();
        }
        JSONArray jsonArray = JSON.parseObject((String)conditionParams).getJSONArray(COUPON_ITEM_CONDITION);
        if (jsonArray == null) {
            return Collections.emptyList();
        }
        return jsonArray.toJavaList(CouponTemplateItemDto.class);
    }

    public static List<String> parseIncludeParams(Collection<CouponTemplateItemDto> items, boolean isExclude) {
        if (CollectionUtils.isEmpty(items)) {
            return Lists.newArrayList();
        }
        ArrayList itemIds = items.stream().filter(param -> param.isExclude() == isExclude).map(CouponTemplateItemDto::getItemCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(itemIds)) {
            itemIds = Lists.newArrayList();
        }
        return itemIds;
    }

    @Override
    public boolean apply(TemplateDefine define, ConditionRespDto conditionRespDto, ItemVo itemVo) {
        JSONObject configParams = JSON.parseObject((String)conditionRespDto.getConditionParams());
        ArrayList<ItemVo> items = new ArrayList<ItemVo>();
        items.add(itemVo);
        EngineParams engineParams = new EngineParams();
        engineParams.setItems(items);
        engineParams.setActivityId(conditionRespDto.getActivityId().longValue());
        try {
            this.execute(define, conditionRespDto, (EngineParams)engineParams, (Map<String, ?>)configParams);
        }
        catch (ProBizException e) {
            this.logger.info("\u6761\u4ef6\u68c0\u67e5\u4e0d\u901a\u8fc7", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public Set<ActivityItemDto> getItems(TemplateDefine define, ConditionRespDto conditionRespDto, Map<String, ?> configParams) {
        Param param = define.getParam(COUPON_ITEM_CONDITION);
        if (null == param) {
            throw new ProBizException("\u5355\u54c1\u6761\u4ef6\u672a\u914d\u7f6e");
        }
        Collection items = (Collection)ConditionTemplate.converter(configParams.get(COUPON_ITEM_CONDITION), param, define.getLoadClass());
        return items.stream().map(couponItem -> new ActivityItemDto(couponItem.getShopId(), Long.valueOf(couponItem.getItemCode()))).collect(Collectors.toSet());
    }
}

